/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner;

import com.intellij.uiDesigner.HierarchyChangeListener;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.jetbrains.annotations.NotNull;

public abstract class SelectionWatcher {
    private final MyPropertyChangeListener myChangeListener;
    private RadRootContainer myRootContainer;
    private final GuiEditor myEditor;
    private final HierarchyChangeListener myHierarchyChangeListener;

    public SelectionWatcher(final GuiEditor editor) {
        this.myEditor = editor;
        this.myChangeListener = new MyPropertyChangeListener();
        this.myRootContainer = editor.getRootContainer();
        this.install(this.myRootContainer);
        this.myHierarchyChangeListener = new HierarchyChangeListener(){

            @Override
            public void hierarchyChanged() {
                if (SelectionWatcher.this.myRootContainer != editor.getRootContainer()) {
                    SelectionWatcher.this.deinstall(SelectionWatcher.this.myRootContainer);
                    SelectionWatcher.this.myRootContainer = editor.getRootContainer();
                    SelectionWatcher.this.install(SelectionWatcher.this.myRootContainer);
                }
            }
        };
        editor.addHierarchyChangeListener(this.myHierarchyChangeListener);
    }

    public void dispose() {
        this.deinstall(this.myRootContainer);
        this.myEditor.removeHierarchyChangeListener(this.myHierarchyChangeListener);
    }

    private void install(@NotNull RadComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/uiDesigner/SelectionWatcher", "install"));
        }
        component.addPropertyChangeListener(this.myChangeListener);
        if (component instanceof RadContainer) {
            RadContainer container = (RadContainer)component;
            for (int i = container.getComponentCount() - 1; i >= 0; --i) {
                this.install(container.getComponent(i));
            }
        }
    }

    private void deinstall(@NotNull RadComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/uiDesigner/SelectionWatcher", "deinstall"));
        }
        component.removePropertyChangeListener(this.myChangeListener);
        if (component instanceof RadContainer) {
            RadContainer container = (RadContainer)component;
            for (int i = container.getComponentCount() - 1; i >= 0; --i) {
                this.deinstall(container.getComponent(i));
            }
        }
    }

    protected abstract void selectionChanged(RadComponent var1, boolean var2);

    private final class MyPropertyChangeListener
    implements PropertyChangeListener {
        private MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("selected".equals(e.getPropertyName())) {
                Boolean selected = (Boolean)e.getNewValue();
                SelectionWatcher.this.selectionChanged((RadComponent)e.getSource(), selected);
            } else if ("children".equals(e.getPropertyName())) {
                RadComponent[] oldChildren = (RadComponent[])e.getOldValue();
                for (int i = oldChildren.length - 1; i >= 0; --i) {
                    SelectionWatcher.this.deinstall(oldChildren[i]);
                }
                RadComponent[] newChildren = (RadComponent[])e.getNewValue();
                for (int i = newChildren.length - 1; i >= 0; --i) {
                    SelectionWatcher.this.install(newChildren[i]);
                }
            }
        }
    }
}

