/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.uiDesigner.inspections.EditorQuickFixProvider;
import com.intellij.uiDesigner.inspections.FormErrorCollector;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.make.FormElementNavigatable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormFileErrorCollector
extends FormErrorCollector {
    private final InspectionManager myManager;
    private final PsiFile myFile;
    private final boolean myOnTheFly;
    private final List<ProblemDescriptor> myProblems = new ArrayList<ProblemDescriptor>();

    public FormFileErrorCollector(PsiFile file, InspectionManager manager, boolean onTheFly) {
        this.myManager = manager;
        this.myFile = file;
        this.myOnTheFly = onTheFly;
    }

    @Override
    public void addError(String inspectionId, IComponent component, @Nullable IProperty prop, @NotNull String errorMessage, EditorQuickFixProvider ... editorQuickFixProviders) {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/uiDesigner/inspections/FormFileErrorCollector", "addError"));
        }
        ProblemDescriptor problemDescriptor = this.myManager.createProblemDescriptor((PsiElement)this.myFile, JDOMUtil.escapeText((String)errorMessage), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly);
        if (problemDescriptor instanceof ProblemDescriptorBase && component != null) {
            FormElementNavigatable navigatable = new FormElementNavigatable(this.myFile.getProject(), this.myFile.getVirtualFile(), component.getId());
            ((ProblemDescriptorBase)problemDescriptor).setNavigatable((Navigatable)navigatable);
        }
        this.myProblems.add(problemDescriptor);
    }

    public ProblemDescriptor[] result() {
        return this.myProblems.toArray(new ProblemDescriptor[this.myProblems.size()]);
    }
}

