/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.radComponents;

import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.uiDesigner.propertyInspector.properties.BindingProperty;
import com.intellij.uiDesigner.radComponents.CustomPropertiesPanel;
import com.intellij.uiDesigner.radComponents.RadButtonGroup;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ButtonGroupPropertiesPanel
implements CustomPropertiesPanel {
    private JTextField myNameTextField;
    private JCheckBox myBindToFieldCheckBox;
    private JPanel myPanel;
    private final RadRootContainer myRootContainer;
    private final RadButtonGroup myGroup;
    private final List<ChangeListener> myListeners;

    public ButtonGroupPropertiesPanel(RadRootContainer rootContainer, RadButtonGroup group) {
        this.$$$setupUI$$$();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myRootContainer = rootContainer;
        this.myGroup = group;
        this.myNameTextField.setText(group.getName());
        this.myBindToFieldCheckBox.setSelected(group.isBound());
        this.myBindToFieldCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ButtonGroupPropertiesPanel.this.saveButtonGroupIsBound();
            }
        });
        this.myNameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ButtonGroupPropertiesPanel.this.saveButtonGroupName();
            }
        });
        this.myNameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonGroupPropertiesPanel.this.saveButtonGroupName();
            }
        });
    }

    private void saveButtonGroupIsBound() {
        if (this.myGroup.isBound() != this.myBindToFieldCheckBox.isSelected()) {
            this.myGroup.setBound(this.myBindToFieldCheckBox.isSelected());
            this.notifyListeners(new ChangeEvent(this.myGroup));
            if (this.myGroup.isBound()) {
                BindingProperty.updateBoundFieldName(this.myRootContainer, null, this.myGroup.getName(), ButtonGroup.class.getName());
            } else {
                BindingProperty.checkRemoveUnusedField(this.myRootContainer, this.myGroup.getName(), FormEditingUtil.getNextSaveUndoGroupId(this.myRootContainer.getProject()));
            }
        }
    }

    private void saveButtonGroupName() {
        String newName;
        String oldName = this.myGroup.getName();
        if (!oldName.equals(newName = this.myNameTextField.getText())) {
            this.myGroup.setName(newName);
            this.notifyListeners(new ChangeEvent(this.myGroup));
            if (this.myGroup.isBound()) {
                BindingProperty.updateBoundFieldName(this.myRootContainer, oldName, newName, ButtonGroup.class.getName());
            }
        }
    }

    @Override
    public JComponent getComponent() {
        return this.myPanel;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.myListeners.remove(listener);
    }

    private void notifyListeners(ChangeEvent event) {
        for (ChangeListener changeListener : this.myListeners) {
            changeListener.stateChanged(event);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JTextField jTextField;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("button.group.name.label"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myNameTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myBindToFieldCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("button.group.bound.checkbox"));
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

