/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.rt.engine;

import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.intellij.plugins.xsltDebugger.rt.engine.Breakpoint;
import org.intellij.plugins.xsltDebugger.rt.engine.BreakpointImpl;
import org.intellij.plugins.xsltDebugger.rt.engine.BreakpointManager;

public class BreakpointManagerImpl
implements BreakpointManager {
    private final TIntObjectHashMap<Map<String, Breakpoint>> myBreakpoints = new TIntObjectHashMap();

    @Override
    public Breakpoint setBreakpoint(File file, int line) {
        return this.setBreakpoint(file.toURI().toASCIIString(), line);
    }

    @Override
    public synchronized void removeBreakpoint(String uri, int line) {
        Map s = (Map)this.myBreakpoints.get(line);
        if (s != null) {
            s.remove(BreakpointManagerImpl.normalizeUri(uri));
        }
    }

    @Override
    public synchronized List<Breakpoint> getBreakpoints() {
        final ArrayList<Breakpoint> breakpoints = new ArrayList<Breakpoint>();
        this.myBreakpoints.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<Map<String, Breakpoint>>(){

            public boolean execute(int i, Map<String, Breakpoint> map) {
                breakpoints.addAll(map.values());
                return true;
            }
        });
        return breakpoints;
    }

    @Override
    public void removeBreakpoint(Breakpoint bp) {
        this.removeBreakpoint(bp.getUri(), bp.getLine());
    }

    @Override
    public synchronized Breakpoint setBreakpoint(String uri, int line) {
        assert (line > 0) : "No line number for breakpoint in file " + uri;
        uri = BreakpointManagerImpl.normalizeUri(uri);
        Map s = (Map)this.myBreakpoints.get(line);
        BreakpointImpl bp = new BreakpointImpl(uri, line);
        if (s == null) {
            HashMap<String, BreakpointImpl> map = new HashMap<String, BreakpointImpl>();
            map.put(uri, bp);
            this.myBreakpoints.put(line, map);
        } else {
            s.put(uri, bp);
        }
        return bp;
    }

    private static String normalizeUri(String uri) {
        try {
            try {
                uri = uri.replaceAll(" ", "%20");
                return new File(new URI(uri)).toURI().toASCIIString();
            }
            catch (IllegalArgumentException e) {
                return new URI(uri).normalize().toASCIIString();
            }
        }
        catch (URISyntaxException e) {
            System.err.println("Failed to parse <" + uri + ">: " + e);
            return uri;
        }
    }

    public synchronized boolean isBreakpoint(String uri, int lineNumber) {
        Breakpoint breakpoint = this.getBreakpoint(uri, lineNumber);
        return breakpoint != null && breakpoint.isEnabled();
    }

    @Override
    public synchronized Breakpoint getBreakpoint(String uri, int lineNumber) {
        Map s = (Map)this.myBreakpoints.get(lineNumber);
        if (s != null) {
            return (Breakpoint)s.get(BreakpointManagerImpl.normalizeUri(uri));
        }
        return null;
    }
}

