/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Nullable;
import org.gradle.api.Transformer;
import org.gradle.internal.Actions;
import org.gradle.internal.BiAction;
import org.gradle.internal.Cast;
import org.gradle.model.ModelMap;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.core.ChildNodeCreatorStrategy;
import org.gradle.model.internal.core.InstanceFactory;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelCreators;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.ModelViewState;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NamedEntityInstantiator;
import org.gradle.model.internal.core.NoInputsModelAction;
import org.gradle.model.internal.core.UnmanagedModelProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.NestedModelRuleDescriptor;
import org.gradle.model.internal.manage.instance.ManagedInstance;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeBackedModelMap<T>
implements ModelMap<T>,
ManagedInstance {
    private final ModelType<T> elementType;
    private final ModelRuleDescriptor sourceDescriptor;
    private final MutableModelNode modelNode;
    private final String description;
    private final boolean eager;
    private final ModelViewState viewState;
    private final ChildNodeCreatorStrategy<? super T> creatorStrategy;

    public NodeBackedModelMap(String description, ModelType<T> elementType, ModelRuleDescriptor sourceDescriptor, MutableModelNode modelNode, boolean eager, ModelViewState viewState, ChildNodeCreatorStrategy<? super T> creatorStrategy) {
        this.description = description;
        this.eager = eager;
        this.viewState = viewState;
        this.creatorStrategy = creatorStrategy;
        this.elementType = elementType;
        this.modelNode = modelNode;
        this.sourceDescriptor = sourceDescriptor;
    }

    public NodeBackedModelMap(ModelType<T> type, ModelRuleDescriptor sourceDescriptor, MutableModelNode modelNode, boolean eager, ModelViewState viewState, ChildNodeCreatorStrategy<? super T> childNodeCreatorStrategy) {
        this(NodeBackedModelMap.derivedDescription(modelNode, type), type, sourceDescriptor, modelNode, eager, viewState, childNodeCreatorStrategy);
    }

    public static <T> ChildNodeCreatorStrategy<T> createUsingParentNode(final ModelType<T> baseItemModelType) {
        return NodeBackedModelMap.createUsingParentNode(new Transformer<NamedEntityInstantiator<T>, MutableModelNode>(){

            public NamedEntityInstantiator<T> transform(MutableModelNode modelNode) {
                return modelNode.getPrivateData(NodeBackedModelMap.instantiatorTypeOf(baseItemModelType));
            }
        });
    }

    public static <T> ChildNodeCreatorStrategy<T> createUsingParentNode(final Transformer<? extends NamedEntityInstantiator<T>, ? super MutableModelNode> instantiatorTransform) {
        return new ChildNodeCreatorStrategy<T>(){

            @Override
            public <S extends T> ModelCreator creator(final MutableModelNode parentNode, ModelRuleDescriptor sourceDescriptor, final ModelType<S> type, final String name) {
                return ModelCreators.of(parentNode.getPath().child(name), new BiAction<MutableModelNode, List<ModelView<?>>>(){

                    public void execute(MutableModelNode modelNode, List<ModelView<?>> modelViews) {
                        NamedEntityInstantiator instantiator = (NamedEntityInstantiator)instantiatorTransform.transform((Object)parentNode);
                        Object item = instantiator.create(name, type.getConcreteClass());
                        modelNode.setPrivateData(type, item);
                    }
                }).withProjection(UnmanagedModelProjection.of(type)).descriptor(NestedModelRuleDescriptor.append(sourceDescriptor, "create(%s)", name)).build();
            }
        };
    }

    public static <T> ChildNodeCreatorStrategy<T> createUsingFactory(final ModelReference<? extends InstanceFactory<? super T, String>> factoryReference) {
        return new ChildNodeCreatorStrategy<T>(){

            @Override
            public <S extends T> ModelCreator creator(MutableModelNode parentNode, ModelRuleDescriptor sourceDescriptor, final ModelType<S> type, final String name) {
                return ModelCreators.of(parentNode.getPath().child(name), new BiAction<MutableModelNode, List<ModelView<?>>>(){

                    public void execute(MutableModelNode modelNode, List<ModelView<?>> modelViews) {
                        InstanceFactory instantiator = (InstanceFactory)Cast.uncheckedCast(modelViews.get(0).getInstance());
                        Object item = instantiator.create(type.getConcreteClass(), modelNode, name);
                        modelNode.setPrivateData(type, item);
                    }
                }).inputs(factoryReference).withProjection(UnmanagedModelProjection.of(type)).descriptor(NestedModelRuleDescriptor.append(sourceDescriptor, "create(%s)", name)).build();
            }
        };
    }

    public static <I> ModelType<NamedEntityInstantiator<I>> instantiatorTypeOf(ModelType<I> type) {
        return new ModelType.Builder<NamedEntityInstantiator<I>>(){}.where(new ModelType.Parameter<I>(){}, type).build();
    }

    @Override
    public MutableModelNode getBackingNode() {
        return this.modelNode;
    }

    @Override
    public <S> void afterEach(Class<S> type, Action<? super S> configAction) {
        this.doFinalizeAll(ModelType.of(type), configAction);
    }

    @Override
    public void afterEach(Action<? super T> configAction) {
        this.doFinalizeAll(this.elementType, configAction);
    }

    @Override
    public void all(Action<? super T> configAction) {
        this.viewState.assertCanMutate();
        ModelRuleDescriptor descriptor = NestedModelRuleDescriptor.append(this.sourceDescriptor, "all()");
        ModelReference<T> subject = ModelReference.of(this.elementType);
        this.modelNode.applyToAllLinks(ModelActionRole.Mutate, NoInputsModelAction.of(subject, descriptor, configAction));
    }

    @Override
    public void beforeEach(Action<? super T> configAction) {
        this.doBeforeEach(this.elementType, configAction);
    }

    @Override
    public <S> void beforeEach(Class<S> type, Action<? super S> configAction) {
        this.doBeforeEach(ModelType.of(type), configAction);
    }

    @Override
    public boolean containsKey(Object name) {
        this.viewState.assertCanReadChildren();
        return name instanceof String && this.modelNode.hasLink((String)name, this.elementType);
    }

    @Override
    public boolean containsValue(Object item) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void create(String name) {
        this.doCreate(name, this.elementType, Actions.doNothing());
    }

    @Override
    public void create(String name, Action<? super T> configAction) {
        this.doCreate(name, this.elementType, configAction);
    }

    @Override
    public <S extends T> void create(String name, Class<S> type) {
        this.doCreate(name, ModelType.of(type), Actions.doNothing());
    }

    @Override
    public <S extends T> void create(String name, Class<S> type, Action<? super S> configAction) {
        this.doCreate(name, ModelType.of(type), configAction);
    }

    private <S> void doBeforeEach(ModelType<S> type, Action<? super S> configAction) {
        this.viewState.assertCanMutate();
        ModelRuleDescriptor descriptor = NestedModelRuleDescriptor.append(this.sourceDescriptor, "beforeEach()");
        ModelReference<S> subject = ModelReference.of(type);
        this.modelNode.applyToAllLinks(ModelActionRole.Defaults, NoInputsModelAction.of(subject, descriptor, configAction));
    }

    private <S extends T> void doCreate(String name, ModelType<S> type, Action<? super S> initAction) {
        this.viewState.assertCanMutate();
        ModelCreator creator = this.creatorStrategy.creator(this.modelNode, this.sourceDescriptor, type, name);
        this.modelNode.addLink(creator);
        ModelRuleDescriptor descriptor = NestedModelRuleDescriptor.append(this.sourceDescriptor, "%s.<init>", name);
        this.modelNode.applyToLink(ModelActionRole.Initialize, NoInputsModelAction.of(ModelReference.of(creator.getPath(), type), descriptor, initAction));
        if (this.eager) {
            this.modelNode.getLink(name).ensureUsable();
        }
    }

    private <S> void doFinalizeAll(ModelType<S> type, Action<? super S> configAction) {
        this.viewState.assertCanMutate();
        ModelRuleDescriptor descriptor = NestedModelRuleDescriptor.append(this.sourceDescriptor, "afterEach()");
        ModelReference<S> subject = ModelReference.of(type);
        this.modelNode.applyToAllLinks(ModelActionRole.Finalize, NoInputsModelAction.of(subject, descriptor, configAction));
    }

    @Override
    @Nullable
    public T get(Object name) {
        return this.get((String)name);
    }

    @Override
    @Nullable
    public T get(String name) {
        this.viewState.assertCanReadChildren();
        MutableModelNode link = this.modelNode.getLink(name);
        if (link == null) {
            return null;
        }
        link.ensureUsable();
        if (this.viewState.isCanMutate()) {
            return link.asWritable(this.elementType, this.sourceDescriptor, null).getInstance();
        }
        return link.asReadOnly(this.elementType, this.sourceDescriptor).getInstance();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<String> keySet() {
        this.viewState.assertCanReadChildren();
        return this.modelNode.getLinkNames(this.elementType);
    }

    @Override
    public void named(String name, Action<? super T> configAction) {
        this.viewState.assertCanMutate();
        ModelRuleDescriptor descriptor = NestedModelRuleDescriptor.append(this.sourceDescriptor, "named(%s)", name);
        ModelReference<T> subject = ModelReference.of(this.modelNode.getPath().child(name), this.elementType);
        this.modelNode.applyToLink(ModelActionRole.Mutate, NoInputsModelAction.of(subject, descriptor, configAction));
    }

    @Override
    public void named(String name, Class<? extends RuleSource> ruleSource) {
        this.viewState.assertCanMutate();
        this.modelNode.applyToLink(name, ruleSource);
    }

    @Override
    public int size() {
        this.viewState.assertCanReadChildren();
        return this.modelNode.getLinkCount(this.elementType);
    }

    public String toString() {
        return this.description;
    }

    private static String derivedDescription(ModelNode modelNode, ModelType<?> elementType) {
        return ModelMap.class.getSimpleName() + '<' + elementType.getSimpleName() + "> '" + modelNode.getPath() + "'";
    }

    public <S extends T> ModelMap<S> toSubType(Class<S> type) {
        ChildNodeCreatorStrategy creatorStrategy = (ChildNodeCreatorStrategy)Cast.uncheckedCast(this.creatorStrategy);
        return new NodeBackedModelMap<S>(ModelType.of(type), this.sourceDescriptor, this.modelNode, this.eager, this.viewState, creatorStrategy);
    }

    @Override
    public Collection<T> values() {
        this.viewState.assertCanReadChildren();
        Iterable values = Iterables.transform(this.keySet(), (Function)new Function<String, T>(){

            public T apply(@Nullable String name) {
                return NodeBackedModelMap.this.get(name);
            }
        });
        return Lists.newArrayList((Iterable)values);
    }

    @Override
    public <S> void withType(Class<S> type, Action<? super S> configAction) {
        ModelRuleDescriptor descriptor = NestedModelRuleDescriptor.append(this.sourceDescriptor, "withType()");
        ModelReference<S> subject = ModelReference.of(type);
        this.viewState.assertCanMutate();
        this.modelNode.applyToAllLinks(ModelActionRole.Mutate, NoInputsModelAction.of(subject, descriptor, configAction));
    }

    @Override
    public <S> void withType(Class<S> type, Class<? extends RuleSource> rules) {
        this.viewState.assertCanMutate();
        this.modelNode.applyToLinks(ModelType.of(type), rules);
    }

    @Override
    public <S> ModelMap<S> withType(Class<S> type) {
        if (type.equals(this.elementType.getConcreteClass())) {
            return (ModelMap)Cast.uncheckedCast((Object)this);
        }
        if (this.elementType.getConcreteClass().isAssignableFrom(type)) {
            Class castType = (Class)Cast.uncheckedCast(type);
            ModelMap<S> subType = this.toSubType(castType);
            return (ModelMap)Cast.uncheckedCast(subType);
        }
        return new NodeBackedModelMap<S>(ModelType.of(type), this.sourceDescriptor, this.modelNode, this.eager, this.viewState, new ChildNodeCreatorStrategy<S>(){

            @Override
            public <D extends S> ModelCreator creator(MutableModelNode parentNode, ModelRuleDescriptor sourceDescriptor, ModelType<D> type, String name) {
                throw new IllegalArgumentException(String.format("Cannot create an item of type %s as this is not a subtype of %s.", type, NodeBackedModelMap.this.elementType.toString()));
            }
        });
    }
}

