/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;

public class TerminalSettingsPanel {
    private JPanel myWholePanel;
    private TextFieldWithBrowseButton myShellPathField;
    private JBCheckBox mySoundBellCheckBox;
    private JBCheckBox myCloseSessionCheckBox;
    private JBCheckBox myMouseReportCheckBox;
    private JTextField myTabNameTextField;
    private JBCheckBox myPasteOnMiddleButtonCheckBox;
    private JBCheckBox myCopyOnSelectionCheckBox;
    private JBCheckBox myOverrideIdeShortcuts;
    private TerminalOptionsProvider myOptionsProvider;

    public TerminalSettingsPanel() {
        this.$$$setupUI$$$();
    }

    public JComponent createPanel(@NotNull TerminalOptionsProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/plugins/terminal/TerminalSettingsPanel", "createPanel"));
        }
        this.myOptionsProvider = provider;
        FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, false, false, false, false, false);
        this.myShellPathField.addBrowseFolderListener("", "Shell Executable Path", null, fileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT, false);
        return this.myWholePanel;
    }

    public boolean isModified() {
        return !Comparing.equal((String)this.myShellPathField.getText(), (String)this.myOptionsProvider.getShellPath()) || !Comparing.equal((String)this.myTabNameTextField.getText(), (String)this.myOptionsProvider.getTabName()) || this.myCloseSessionCheckBox.isSelected() != this.myOptionsProvider.closeSessionOnLogout() || this.myMouseReportCheckBox.isSelected() != this.myOptionsProvider.enableMouseReporting() || this.mySoundBellCheckBox.isSelected() != this.myOptionsProvider.audibleBell() || this.myCopyOnSelectionCheckBox.isSelected() != this.myOptionsProvider.copyOnSelection() || this.myPasteOnMiddleButtonCheckBox.isSelected() != this.myOptionsProvider.pasteOnMiddleMouseButton() || this.myOverrideIdeShortcuts.isSelected() != this.myOptionsProvider.overrideIdeShortcuts();
    }

    public void apply() {
        this.myOptionsProvider.setShellPath(this.myShellPathField.getText());
        this.myOptionsProvider.setTabName(this.myTabNameTextField.getText());
        this.myOptionsProvider.setCloseSessionOnLogout(this.myCloseSessionCheckBox.isSelected());
        this.myOptionsProvider.setReportMouse(this.myMouseReportCheckBox.isSelected());
        this.myOptionsProvider.setSoundBell(this.mySoundBellCheckBox.isSelected());
        this.myOptionsProvider.setCopyOnSelection(this.myCopyOnSelectionCheckBox.isSelected());
        this.myOptionsProvider.setPasteOnMiddleMouseButton(this.myPasteOnMiddleButtonCheckBox.isSelected());
        this.myOptionsProvider.setOverrideIdeShortcuts(this.myOverrideIdeShortcuts.isSelected());
    }

    public void reset() {
        this.myShellPathField.setText(this.myOptionsProvider.getShellPath());
        this.myTabNameTextField.setText(this.myOptionsProvider.getTabName());
        this.myCloseSessionCheckBox.setSelected(this.myOptionsProvider.closeSessionOnLogout());
        this.myMouseReportCheckBox.setSelected(this.myOptionsProvider.enableMouseReporting());
        this.mySoundBellCheckBox.setSelected(this.myOptionsProvider.audibleBell());
        this.myCopyOnSelectionCheckBox.setSelected(this.myOptionsProvider.copyOnSelection());
        this.myPasteOnMiddleButtonCheckBox.setSelected(this.myOptionsProvider.pasteOnMiddleMouseButton());
        this.myOverrideIdeShortcuts.setSelected(this.myOptionsProvider.overrideIdeShortcuts());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JBCheckBox jBCheckBox4;
        JBCheckBox jBCheckBox5;
        JBCheckBox jBCheckBox6;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTextField jTextField;
        JPanel jPanel;
        this.myWholePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(7, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Shell path");
        jLabel.setHorizontalTextPosition(2);
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Tab name");
        jLabel2.setHorizontalTextPosition(2);
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTabNameTextField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(1, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myShellPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(6, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myCloseSessionCheckBox = jBCheckBox6 = new JBCheckBox();
        jBCheckBox6.setText("Close session when it ends");
        jPanel4.add((Component)jBCheckBox6, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.mySoundBellCheckBox = jBCheckBox5 = new JBCheckBox();
        jBCheckBox5.setText("Audible bell");
        jPanel5.add((Component)jBCheckBox5, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel6, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myMouseReportCheckBox = jBCheckBox4 = new JBCheckBox();
        jBCheckBox4.setText("Mouse reporting");
        jPanel6.add((Component)jBCheckBox4, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel6.add((Component)spacer4, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel7, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myCopyOnSelectionCheckBox = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("Copy to clipboard on selection");
        jPanel7.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel7.add((Component)spacer5, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel8, new GridConstraints(4, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myPasteOnMiddleButtonCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Paste on middle mouse button click");
        jPanel8.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel8.add((Component)spacer6, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel9, new GridConstraints(5, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myOverrideIdeShortcuts = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Override IDE shortcuts");
        jPanel9.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel9.add((Component)spacer7, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }
}

