/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.attr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public class StructInnerClassesAttribute
extends StructGeneralAttribute {
    private List<int[]> classEntries;
    private List<String[]> stringEntries;

    @Override
    public void initContent(ConstantPool pool) throws IOException {
        DataInputFullStream data = this.stream();
        int len = data.readUnsignedShort();
        if (len > 0) {
            this.classEntries = new ArrayList<int[]>(len);
            this.stringEntries = new ArrayList<String[]>(len);
            for (int i = 0; i < len; ++i) {
                int[] classEntry = new int[4];
                for (int j = 0; j < 4; ++j) {
                    classEntry[j] = data.readUnsignedShort();
                }
                this.classEntries.add(classEntry);
                String[] stringEntry = new String[3];
                stringEntry[0] = pool.getPrimitiveConstant(classEntry[0]).getString();
                if (classEntry[1] != 0) {
                    stringEntry[1] = pool.getPrimitiveConstant(classEntry[1]).getString();
                }
                if (classEntry[2] != 0) {
                    stringEntry[2] = pool.getPrimitiveConstant(classEntry[2]).getString();
                }
                this.stringEntries.add(stringEntry);
            }
        } else {
            this.classEntries = Collections.emptyList();
            this.stringEntries = Collections.emptyList();
        }
    }

    public List<int[]> getClassEntries() {
        return this.classEntries;
    }

    public List<String[]> getStringEntries() {
        return this.stringEntries;
    }
}

