/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.griffon;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public class GriffonCreateProjectDialog
extends DialogWrapper {
    private JTextField myOptionField;
    private JPanel myComponent;
    private JRadioButton myCreateApp;
    private JRadioButton myCreatePlugin;
    private JRadioButton myCreateAddon;
    private JRadioButton myCreateArchetype;
    private JLabel myCreateLabel;

    public GriffonCreateProjectDialog(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/griffon/GriffonCreateProjectDialog", "<init>"));
        }
        super(module.getProject());
        this.$$$setupUI$$$();
        this.setTitle("Create Griffon Structure");
        this.myCreateLabel.setText("Create Griffon structure in module '" + module.getName() + "':");
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myComponent;
    }

    MvcCommand getCommand() {
        String cmd;
        if (this.myCreateAddon.isSelected()) {
            cmd = "create-addon";
        } else if (this.myCreateApp.isSelected()) {
            cmd = "create-app";
        } else if (this.myCreateArchetype.isSelected()) {
            cmd = "create-archetype";
        } else if (this.myCreatePlugin.isSelected()) {
            cmd = "create-plugin";
        } else {
            throw new AssertionError((Object)"No selection");
        }
        String text = this.myOptionField.getText();
        if (text == null) {
            text = "";
        }
        return new MvcCommand(cmd, ParametersList.parse((String)text));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JTextField jTextField;
        JPanel jPanel;
        this.myComponent = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Additional options:");
        jLabel2.setDisplayedMnemonic('O');
        jLabel2.setDisplayedMnemonicIndex(11);
        jPanel.add((Component)jLabel2, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOptionField = jTextField = new JTextField();
        jTextField.setColumns(100);
        jPanel.add((Component)jTextField, new GridConstraints(5, 1, 1, 2, 8, 1, 6, 0, new Dimension(150, -1), new Dimension(150, -1), null));
        this.myCreateApp = jRadioButton4 = new JRadioButton();
        jRadioButton4.setText("Create an application (create-app)");
        jRadioButton4.setMnemonic('A');
        jRadioButton4.setDisplayedMnemonicIndex(10);
        jRadioButton4.setSelected(true);
        jPanel.add((Component)jRadioButton4, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myCreatePlugin = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Create a plugin (create-plugin)");
        jRadioButton3.setMnemonic('P');
        jRadioButton3.setDisplayedMnemonicIndex(9);
        jPanel.add((Component)jRadioButton3, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myCreateAddon = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Create an addon (create-addon)");
        jRadioButton2.setMnemonic('D');
        jRadioButton2.setDisplayedMnemonicIndex(11);
        jPanel.add((Component)jRadioButton2, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myCreateArchetype = jRadioButton = new JRadioButton();
        jRadioButton.setText("Create an archetype (create-archetype)");
        jRadioButton.setMnemonic('R');
        jRadioButton.setDisplayedMnemonicIndex(11);
        jPanel.add((Component)jRadioButton, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myCreateLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        jLabel2.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myComponent;
    }
}

