/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.griffon;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import icons.JetgroovyIcons;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyLibraryPresentationProviderBase;

public class GriffonLibraryPresentationProvider
extends GroovyLibraryPresentationProviderBase {
    public static final LibraryKind GRIFFON_KIND = LibraryKind.create((String)"griffon");
    @NonNls
    private static final Pattern GRIFFON_JAR_FILE_PATTERN = Pattern.compile("griffon-rt-(\\d.*)\\.jar");

    public GriffonLibraryPresentationProvider() {
        super(GRIFFON_KIND);
    }

    @Override
    protected void fillLibrary(String path, LibraryEditor libraryEditor) {
        String[] jars = new File(path + "/dist").list();
        if (jars != null) {
            for (String fileName : jars) {
                if (!fileName.endsWith(".jar")) continue;
                libraryEditor.addRoot(VfsUtil.getUrlForLibraryRoot((File)new File(path + "/dist/" + fileName)), OrderRootType.CLASSES);
            }
        }
        if ((jars = new File(path + "/lib").list()) != null) {
            for (String fileName : jars) {
                if (!fileName.endsWith(".jar")) continue;
                libraryEditor.addRoot(VfsUtil.getUrlForLibraryRoot((File)new File(path + "/lib/" + fileName)), OrderRootType.CLASSES);
            }
        }
    }

    @Override
    public boolean isSDKHome(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/griffon/GriffonLibraryPresentationProvider", "isSDKHome"));
        }
        VirtualFile dist = file.findChild("dist");
        if (dist == null) {
            return false;
        }
        return GriffonLibraryPresentationProvider.isGriffonSdk(dist.getChildren());
    }

    @Override
    @NotNull
    public String getSDKVersion(String path) {
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        for (VirtualFile virtualFile : file.findChild("dist").getChildren()) {
            String version = GriffonLibraryPresentationProvider.getGriffonCoreJarVersion(virtualFile);
            if (version == null) continue;
            String string = version;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/griffon/GriffonLibraryPresentationProvider", "getSDKVersion"));
            }
            return string;
        }
        throw new AssertionError((Object)path);
    }

    @Override
    public boolean managesLibrary(VirtualFile[] libraryFiles) {
        return GriffonLibraryPresentationProvider.isGriffonSdk(libraryFiles);
    }

    static boolean isGriffonCoreJar(VirtualFile file) {
        return GRIFFON_JAR_FILE_PATTERN.matcher(file.getName()).matches();
    }

    @Override
    @Nls
    public String getLibraryVersion(VirtualFile[] libraryFiles) {
        return GriffonLibraryPresentationProvider.getGriffonVersion(libraryFiles);
    }

    public static boolean isGriffonSdk(VirtualFile[] files) {
        for (VirtualFile file : files) {
            if (!GriffonLibraryPresentationProvider.isGriffonCoreJar(file)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String getGriffonVersion(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/griffon/GriffonLibraryPresentationProvider", "getGriffonVersion"));
        }
        for (OrderEntry orderEntry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            VirtualFile[] files;
            if (!(orderEntry instanceof LibraryOrderEntry) || !GriffonLibraryPresentationProvider.isGriffonSdk(files = ((LibraryOrderEntry)orderEntry).getRootFiles(OrderRootType.CLASSES))) continue;
            return GriffonLibraryPresentationProvider.getGriffonVersion(files);
        }
        return null;
    }

    @Nullable
    private static String getGriffonVersion(VirtualFile[] libraryFiles) {
        for (VirtualFile file : libraryFiles) {
            String version = GriffonLibraryPresentationProvider.getGriffonCoreJarVersion(file);
            if (version == null) continue;
            return version;
        }
        return null;
    }

    @Nullable
    private static String getGriffonCoreJarVersion(VirtualFile file) {
        Matcher matcher = GRIFFON_JAR_FILE_PATTERN.matcher(file.getName());
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = JetgroovyIcons.Griffon.Griffon;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/griffon/GriffonLibraryPresentationProvider", "getIcon"));
        }
        return icon;
    }

    @Override
    @Nls
    @NotNull
    public String getLibraryCategoryName() {
        if ("Griffon" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/griffon/GriffonLibraryPresentationProvider", "getLibraryCategoryName"));
        }
        return "Griffon";
    }
}

