/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.hub.queue;

import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.hub.protocol.ConnectionClosed;
import org.gradle.messaging.remote.internal.hub.protocol.ConnectionEstablished;
import org.gradle.messaging.remote.internal.hub.protocol.EndOfStream;
import org.gradle.messaging.remote.internal.hub.protocol.InterHubMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueInitializer {
    private EndOfStream endOfStream;
    private Map<Connection<?>, ConnectionEstablished> queued = new LinkedHashMap();

    void onStatefulMessage(InterHubMessage message) {
        if (message instanceof ConnectionEstablished) {
            ConnectionEstablished connectionEstablished = (ConnectionEstablished)message;
            this.queued.put(connectionEstablished.getConnection(), connectionEstablished);
        } else if (message instanceof ConnectionClosed) {
            ConnectionClosed connectionClosed = (ConnectionClosed)message;
            this.queued.remove(connectionClosed.getConnection());
        } else if (message instanceof EndOfStream) {
            this.queued.clear();
            this.endOfStream = (EndOfStream)message;
        } else {
            throw new UnsupportedOperationException(String.format("Received unexpected stateful message: %s", message));
        }
    }

    void onQueueAdded(Dispatch<InterHubMessage> queue) {
        for (ConnectionEstablished connectionEstablished : this.queued.values()) {
            queue.dispatch(connectionEstablished);
        }
        if (this.endOfStream != null) {
            queue.dispatch(this.endOfStream);
        }
    }
}

