/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.protocol;

import java.util.UUID;
import org.gradle.messaging.remote.internal.Message;
import org.gradle.messaging.remote.internal.protocol.RoutableMessage;

public abstract class ConsumerMessage
extends Message
implements RoutableMessage {
    protected final UUID consumerId;
    protected final Object producerId;

    public ConsumerMessage(UUID consumerId, Object producerId) {
        this.producerId = producerId;
        this.consumerId = consumerId;
    }

    public UUID getConsumerId() {
        return this.consumerId;
    }

    public Object getProducerId() {
        return this.producerId;
    }

    public Object getDestination() {
        return this.producerId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ConsumerMessage other = (ConsumerMessage)o;
        return this.consumerId.equals(other.consumerId) && this.producerId.equals(other.producerId);
    }

    public int hashCode() {
        return this.consumerId.hashCode() ^ this.producerId.hashCode();
    }

    public String toString() {
        return String.format("[%s, consumerId: %s, producerId: %s]", this.getClass().getSimpleName(), this.consumerId, this.producerId);
    }
}

