/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.SingleAlarm;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.InputStream;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.keychain.CredentialsStore;
import org.jetbrains.keychain.FileCredentialsStore;
import org.jetbrains.keychain.OSXKeychainLibraryKt;
import org.jetbrains.keychain.OsXCredentialsStore;
import org.jetbrains.settingsRepository.AutoSyncManager;
import org.jetbrains.settingsRepository.IcsBundleKt;
import org.jetbrains.settingsRepository.IcsManager;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.IcsSettingsKt;
import org.jetbrains.settingsRepository.IcsUrlBuilderKt;
import org.jetbrains.settingsRepository.ReadOnlySourcesManager;
import org.jetbrains.settingsRepository.RepositoryManager;
import org.jetbrains.settingsRepository.RepositoryService;
import org.jetbrains.settingsRepository.SyncManager;
import org.jetbrains.settingsRepository.SyncType;
import org.jetbrains.settingsRepository.UpdateResult;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.GitRepositoryManager;
import org.jetbrains.settingsRepository.git.GitRepositoryService;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0003\u0004)\u0011\u0001D\u0001\u0006\u0003!\u0001Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!-Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0005!A!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001\u0003\u0004\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\r\u0001e\t\u0001\u0014A\u000f\u0002={\tk!C\u0002\t\u00035\t\u00014A)\u0004\u0003!\u0011Qe\u0002\u0005\u0017\u001b\u0005Aj#G\u0002\t/5\t\u0001tF\u0013\u0005\t\u0005A\u0001$D\u0001\u0019.\u0015R\u0001\u0012G\u0007\u00021[Ib\u0001C\r\u000e\t%\u0011\u0011\"\u0001M\u00171g)C\u0001B\u0001\t55\t\u0001TF\u0013\u0018\u0011ki!\u0001$\u0001\u00197e\u0019\u0001rG\u0007\u00021qIR\u0001B\u0001\t:5\u0011A\u0012\u0001\r\u001e3!!\u0011\u0001c\u000f\u000e\u000b%\u0011\u0011\"\u0001M\u0017\u0019\u0003A\u001a$K\u0005\u0005\u0004rA)!D\u0001\u0019\u0007q\t\u0001%A)\u0004\u0003\u0015\u0001\u0011F\u0003\u0003A\u0011!\u001dQ\"\u0001\r\u0005#\u000e!Q\u0001A\u0007\u0003\t\u0013AQ!K\u0004\u0005\u0003\"AY!D\u0001\u0019\rE\u001b\u0011!\u0002\u0001*\u001b\u0011\u0019\u0005\u0002#\u0004\u000e\t%\u0011\u0011\"\u0001M\b1\u001d\t6\u0001B\u0003\u0001\u001b\t!\u0001\u0002#\u0005*\u0015\u0011\u0019\u0005\u0002C\u0005\u000e\u0003aM\u0011k\u0001\u0003\u0006\u00015\u0011AA\u0003E\u000bS=!9\t\b\u0005\f\u001b\u0005A2\u0001H\u0002!\u0007E\u001bq!\u0002\u0001\u000e\u0005\u0011]\u0001\u0002D\t\u0003\t3AQ\"\u000b\u0006\u0005\u0007\"AY\"D\u0001\u0019\u001dE\u001bA!\u0002\u0001\u000e\u0005\u0011u\u0001bD\u0015\u000b\t\rC\u0001rD\u0007\u00021A\t6\u0001B\u0003\u0001\u001b\t!\t\u0003C\t*\u0015\u0011\u0019\u0005\u0002c\t\u000e\u0003a\u0011\u0012k\u0001\u0003\u0006\u00015\u0011AQ\u0005\u0005\u0014S)!1\t\u0003E\u0014\u001b\u0005A\u001a!U\u0002\u0005\u000b\u0001i!\u0001\u0002\u000b\t*%:A!\u0011\u0005\t+5\t\u00014F)\u0004\u0003\u0015\u0001\u0001"}, strings={"Lorg/jetbrains/settingsRepository/IcsManager;", "", "dir", "Ljava/io/File;", "(Ljava/io/File;)V", "autoCommitEnabled", "", "autoSyncManager", "Lorg/jetbrains/settingsRepository/AutoSyncManager;", "getAutoSyncManager$settings_repository", "()Lorg/jetbrains/settingsRepository/AutoSyncManager;", "commitAlarm", "Lcom/intellij/util/SingleAlarm;", "credentialsStore", "Lcom/intellij/openapi/util/AtomicNotNullLazyValue;", "Lorg/jetbrains/keychain/CredentialsStore;", "getCredentialsStore", "()Lcom/intellij/openapi/util/AtomicNotNullLazyValue;", "readOnlySourcesManager", "Lorg/jetbrains/settingsRepository/ReadOnlySourcesManager;", "getReadOnlySourcesManager", "()Lorg/jetbrains/settingsRepository/ReadOnlySourcesManager;", "repositoryActive", "getRepositoryActive", "()Z", "setRepositoryActive", "(Z)V", "repositoryManager", "Lorg/jetbrains/settingsRepository/RepositoryManager;", "getRepositoryManager", "()Lorg/jetbrains/settingsRepository/RepositoryManager;", "repositoryService", "Lorg/jetbrains/settingsRepository/RepositoryService;", "getRepositoryService", "()Lorg/jetbrains/settingsRepository/RepositoryService;", "settings", "Lorg/jetbrains/settingsRepository/IcsSettings;", "getSettings", "()Lorg/jetbrains/settingsRepository/IcsSettings;", "settingsFile", "getSettingsFile", "()Ljava/io/File;", "syncManager", "Lorg/jetbrains/settingsRepository/SyncManager;", "beforeApplicationLoaded", "", "application", "Lcom/intellij/openapi/application/Application;", "cancelAndDisableAutoCommit", "runInAutoCommitDisabledMode", "task", "Lkotlin/Function0;", "scheduleCommit", "sync", "Lorg/jetbrains/settingsRepository/UpdateResult;", "syncType", "Lorg/jetbrains/settingsRepository/SyncType;", "project", "Lcom/intellij/openapi/project/Project;", "localRepositoryInitializer", "ApplicationLevelProvider", "IcsStreamProvider"}, moduleName="settings-repository")
public final class IcsManager {
    @NotNull
    private final AtomicNotNullLazyValue<CredentialsStore> credentialsStore;
    @NotNull
    private final File settingsFile;
    @NotNull
    private final IcsSettings settings;
    @NotNull
    private final RepositoryManager repositoryManager;
    @NotNull
    private final ReadOnlySourcesManager readOnlySourcesManager;
    @NotNull
    private final RepositoryService repositoryService;
    private final SingleAlarm commitAlarm;
    private volatile boolean autoCommitEnabled;
    private volatile boolean repositoryActive;
    @NotNull
    private final AutoSyncManager autoSyncManager;
    private final SyncManager syncManager;

    @NotNull
    public final AtomicNotNullLazyValue<CredentialsStore> getCredentialsStore() {
        return this.credentialsStore;
    }

    @NotNull
    public final File getSettingsFile() {
        return this.settingsFile;
    }

    @NotNull
    public final IcsSettings getSettings() {
        return this.settings;
    }

    @NotNull
    public final RepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    @NotNull
    public final ReadOnlySourcesManager getReadOnlySourcesManager() {
        return this.readOnlySourcesManager;
    }

    @NotNull
    public final RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public final boolean getRepositoryActive() {
        return this.repositoryActive;
    }

    public final void setRepositoryActive(boolean bl) {
        this.repositoryActive = bl;
    }

    @NotNull
    public final AutoSyncManager getAutoSyncManager$settings_repository() {
        return this.autoSyncManager;
    }

    private final void scheduleCommit() {
        if (this.autoCommitEnabled) {
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                Intrinsics.throwNpe();
            }
            if (!application.isUnitTestMode()) {
                this.commitAlarm.cancelAndRequest();
            }
        }
    }

    @Nullable
    public final UpdateResult sync(@NotNull SyncType syncType, @Nullable Project project, @Nullable Function0<? extends Unit> localRepositoryInitializer) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)syncType), (String)"syncType");
        return this.syncManager.sync(syncType, project, localRepositoryInitializer);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ UpdateResult sync$default(IcsManager icsManager2, SyncType syncType, Project project, Function0 function0, int n) {
        if ((n & 2) != 0) {
            project = null;
        }
        if ((n & 4) != 0) {
            function0 = null;
        }
        return icsManager2.sync(syncType, project, (Function0<? extends Unit>)function0);
    }

    private final void cancelAndDisableAutoCommit() {
        if (this.autoCommitEnabled) {
            this.autoCommitEnabled = false;
            this.commitAlarm.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runInAutoCommitDisabledMode(@NotNull Function0<? extends Unit> task) {
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        this.cancelAndDisableAutoCommit();
        try {
            task.invoke();
        }
        finally {
            this.autoCommitEnabled = true;
            this.repositoryActive = this.repositoryManager.isRepositoryExists();
        }
    }

    public final void beforeApplicationLoaded(@NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        this.repositoryActive = this.repositoryManager.isRepositoryExists();
        StateStorageManager stateStorageManager = ServiceKt.getStateStore((ComponentManager)((ComponentManager)application)).getStateStorageManager();
        if (stateStorageManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.StateStorageManagerImpl");
        }
        ((StateStorageManagerImpl)stateStorageManager).setStreamProvider((StreamProvider)new ApplicationLevelProvider());
        this.autoSyncManager.registerListeners(application);
        application.getMessageBus().connect().subscribe(ProjectLifecycleListener.TOPIC, (Object)new ProjectLifecycleListener.Adapter(this){
            final /* synthetic */ IcsManager this$0;

            public void beforeProjectLoaded(@NotNull Project project) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                if (project.isDefault()) {
                    return;
                }
                this.this$0.getAutoSyncManager$settings_repository().registerListeners(project);
            }

            public void afterProjectClosed(@NotNull Project project) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                AutoSyncManager.autoSync$default(this.this$0.getAutoSyncManager$settings_repository(), false, false, 3);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public IcsManager(@NotNull File dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        this.credentialsStore = (AtomicNotNullLazyValue)new AtomicNotNullLazyValue<CredentialsStore>(dir){
            final /* synthetic */ File $dir;

            @NotNull
            protected CredentialsStore compute() {
                if (OSXKeychainLibraryKt.isOSXCredentialsStoreSupported() && SystemProperties.getBooleanProperty((String)"ics.use.osx.keychain", (boolean)true)) {
                    try {
                        return new OsXCredentialsStore("IntelliJ Platform Settings Repository");
                    }
                    catch (Throwable e) {
                        IcsManagerKt.getLOG().error(e);
                    }
                }
                return new FileCredentialsStore(new File(this.$dir, ".git_auth"));
            }
            {
                this.$dir = $captured_local_variable$0;
            }
        };
        this.settingsFile = new File(dir, "config.json");
        this.repositoryManager = new GitRepositoryManager((NotNullLazyValue<CredentialsStore>)((NotNullLazyValue)this.credentialsStore), new File(dir, "repository"));
        try {
            this.settings = IcsSettingsKt.loadSettings(this.settingsFile);
        }
        catch (Exception e) {
            this.settings = new IcsSettings();
            IcsManagerKt.getLOG().error((Throwable)e);
        }
        this.readOnlySourcesManager = new ReadOnlySourcesManager(this.settings, dir);
        this.repositoryService = new GitRepositoryService();
        this.commitAlarm = new SingleAlarm(new Runnable(this){
            final /* synthetic */ IcsManager this$0;

            public final void run() {
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, null, IcsBundleKt.icsMessage("task.commit.title", new Object[0])){
                    final /* synthetic */ commitAlarm.1 this$0;

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                        try {
                            RepositoryManager.DefaultImpls.commit$default(this.this$0.this$0.getRepositoryManager(), indicator, null, false, 2);
                        }
                        catch (Throwable e) {
                            IcsManagerKt.getLOG().error(e);
                        }
                    }
                    {
                        this.this$0 = $outer;
                        super($super_call_param$1, $super_call_param$2);
                    }
                });
            }
            {
                this.this$0 = icsManager2;
            }
        }, this.settings.getCommitDelay());
        this.autoCommitEnabled = true;
        this.autoSyncManager = new AutoSyncManager(this);
        this.syncManager = new SyncManager(this, this.autoSyncManager);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001d\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0011\u001d)\u0001!B\u0001\r\u0003\u0011\u0019%\u0001\u0004\u0001\u001a\u0003a\u0005\u0011UA)\u0004\u0003!\tQ\u0005\u0004\u0003\f\u0011\u0007i\u0011\u0001\u0007\u0002\u001a\u0007!\u0015Q\"\u0001\r\u00043\rA9!D\u0001\u0019\t\u0001"}, strings={"Lorg/jetbrains/settingsRepository/IcsManager$ApplicationLevelProvider;", "Lorg/jetbrains/settingsRepository/IcsManager$IcsStreamProvider;", "(Lorg/jetbrains/settingsRepository/IcsManager;)V", "delete", "", "fileSpec", "", "roamingType", "Lcom/intellij/openapi/components/RoamingType;"}, moduleName="settings-repository")
    public final class ApplicationLevelProvider
    extends IcsStreamProvider {
        @Override
        public void delete(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            if (IcsManager.this.syncManager.getWriteAndDeleteProhibited()) {
                throw (Throwable)new IllegalStateException("Delete is prohibited now");
            }
            IcsManager.this.getRepositoryManager().delete(IcsUrlBuilderKt.buildPath$default(fileSpec, roamingType, null, 4));
            IcsManager.this.scheduleCommit();
        }

        public ApplicationLevelProvider() {
            super(null);
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"K\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u000f\u0015\tA!A\u0003\u0002\u0011\u0017)\u0011\u0001\"\u0002\u0006\u0003!\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001\"C\u0003\u0001\u000b\u0005AA!B\u0001\u0005\u0005\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tA!\u0001\u0003L\u00051\u0001\u0011$\u0001M\u0001C%IY\u0001C\u0001\u000e\u00051\u0005\u00014\u0001)\u0004\u0002E\u001b\u0011\u0001\u0003\u0002&\u0019\u0011Y\u00012B\u0007\u00021\u0019I2\u0001#\u0004\u000e\u0003a\r\u0011d\u0001\u0005\b\u001b\u0005Az!J\n\t\u00115\t\u0001dA\r\u0004\u0011\u001bi\u0011\u0001g\u0001\u001a\u0007!EQ\"\u0001\r\n3\rA\u0019\"D\u0001\u0019\u0015e\u0019\u0001bB\u0007\u00021\u001f)C\u0002\u0002\u0006\t\u00165\t\u0001dA\r\u0004\u0011\u001bi\u0011\u0001g\u0001\u001a\u0007!9Q\"\u0001M\bK\u0019\"1\u0002C\u0006\u000e\u0003a1\u0011d\u0001E\f\u001b\u0005A\u001a!G\u0002\t\u000f5\t\u0001tB\r\n\u00111iq!\u0003\u0002\n\u0003a\r\u0011BA\u0005\u00021\rAJ\"G\b\t\u001b5i\u0011BA\u0005\u00021\u0007I!!C\u0001\u0019\u001d%\u0011\u0011\"\u0001\r\u0004\u0013\tI\u0011\u0001G\u0002\u0019\u001c\u0015jAa\u0003E\u000f\u001b\ta\t\u0001\u0007\b\u001a\u0007!5Q\"\u0001M\u00023\rAq!D\u0001\u0019\u0010\u0015\"Ba\u0003\u0005\u0010\u001b\u0005Ab!G\u0002\t\u000e5\t\u00014A\r\u0004\u0011#i\u0011\u0001G\u0005\u001a\u0007!MQ\"\u0001\r\u000b3\rAq!D\u0001\u0019\u0010%RAa\u0013\u0005\t\u00065\t\u0001d\u0001\u000f,#\u000e\u0019QB\u0001C\u0004\u0011\u0011I3\u0002\u0002\"\t\u0011\u0005i!\u0001$\u0001\u0019\u0004E\u001bA!\u0002\u0001\u000e\u0005\u0011%\u0001\"\u0002"}, strings={"Lorg/jetbrains/settingsRepository/IcsManager$IcsStreamProvider;", "Lcom/intellij/configurationStore/StreamProvider;", "projectId", "", "(Lorg/jetbrains/settingsRepository/IcsManager;Ljava/lang/String;)V", "enabled", "", "getEnabled", "()Z", "getProjectId", "()Ljava/lang/String;", "delete", "", "fileSpec", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "doSave", "content", "", "size", "", "isAutoCommit", "processChildren", "path", "filter", "Lkotlin/Function1;", "processor", "Lkotlin/Function3;", "Ljava/io/InputStream;", "read", "write"}, moduleName="settings-repository")
    public class IcsStreamProvider
    implements StreamProvider {
        @Nullable
        private final String projectId;

        public boolean getEnabled() {
            return IcsManager.this.getRepositoryActive();
        }

        public void processChildren(@NotNull String path, @NotNull RoamingType roamingType, @NotNull Function1<? super String, ? extends Boolean> filter, @NotNull Function3<? super String, ? super InputStream, ? super Boolean, ? extends Boolean> processor) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
            Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
            String fullPath = IcsUrlBuilderKt.buildPath(path, roamingType, null);
            for (Repository repository2 : IcsManager.this.getReadOnlySourcesManager().getRepositories()) {
                GitExKt.processChildren(repository2, fullPath, filter, (Function2<? super String, ? super InputStream, ? extends Boolean>)((Function2)new Function2<String, InputStream, Boolean>(processor){
                    final /* synthetic */ Function3 $processor;

                    public final boolean invoke(@NotNull String name, @NotNull InputStream input) {
                        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
                        return (Boolean)this.$processor.invoke((Object)name, (Object)input, (Object)true);
                    }
                    {
                        this.$processor = function3;
                        super(2);
                    }
                }));
            }
            IcsManager.this.getRepositoryManager().processChildren(fullPath, filter, (Function2<? super String, ? super InputStream, ? extends Boolean>)((Function2)new Function2<String, InputStream, Boolean>(processor){
                final /* synthetic */ Function3 $processor;

                public final boolean invoke(@NotNull String name, @NotNull InputStream input) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
                    return (Boolean)this.$processor.invoke((Object)name, (Object)input, (Object)false);
                }
                {
                    this.$processor = function3;
                    super(2);
                }
            }));
        }

        public void write(@NotNull String fileSpec, @NotNull byte[] content, int size, @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            if (IcsManager.this.syncManager.getWriteAndDeleteProhibited()) {
                throw (Throwable)new IllegalStateException("Save is prohibited now");
            }
            if (this.doSave(fileSpec, content, size, roamingType) && this.isAutoCommit(fileSpec, roamingType)) {
                IcsManager.this.scheduleCommit();
            }
        }

        public final boolean doSave(@NotNull String fileSpec, @NotNull byte[] content, int size, @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            return IcsManager.this.getRepositoryManager().write(IcsUrlBuilderKt.buildPath(fileSpec, roamingType, this.projectId), content, size);
        }

        protected boolean isAutoCommit(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            return true;
        }

        @Nullable
        public InputStream read(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            return IcsManager.this.getRepositoryManager().read(IcsUrlBuilderKt.buildPath(fileSpec, roamingType, this.projectId));
        }

        public void delete(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        }

        @Nullable
        protected final String getProjectId() {
            return this.projectId;
        }

        public IcsStreamProvider(String projectId) {
            this.projectId = projectId;
        }

        public boolean isApplicable(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            return StreamProvider.DefaultImpls.isApplicable((StreamProvider)this, (String)fileSpec, (RoamingType)roamingType);
        }
    }
}

