/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import kotlin.CharsKt;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.jvm.internal.Ref;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.keychain.CredentialsStore;
import org.jetbrains.settingsRepository.AuthenticationException;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.NoRemoteRepositoryException;
import org.jetbrains.settingsRepository.git.InputStreamWrapper;
import org.jetbrains.settingsRepository.git.JGitCredentialsProvider;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"'\u0004)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\b\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001\u0003\u0003\u0006\u0001\u0015\t\u0001\"C\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001E\u0006\u000b\u0001)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u001bkA\u0001!D\u0001\u0019\u0002e\u0019\u0001\"A\u0007\u00021\u0007I2\u0001\u0003\u0002\u000e\u0003a\u0015\u0011\u0004\u0003\u0003\u0002\u0011\riQ!\u0003\u0002\n\u0003a!A\u0012\u0001M\u00043\u0011!\u0011\u0001#\u0003\u000e\u0003a)Aka\u0003\u000e\u0012!1Q\"\u0001M\u00013\rA!!D\u0001\u0019\u0006Q\u001bY!$\u0005\t\u000e5\t\u0001\u0014A\r\u0004\u0011\ti\u0011\u0001'\u0002U\u0007\u0017i)\u0002B\u0001\t\u000f5\u0011A\u0012\u0001M\b3\rA\u0001\"D\u0001\u0019\u0012Q\u001bY!$\u0005\t\u00135\t\u00014C\r\u0004\u0011)i\u0011\u0001'\u0006U\u0007\u0017iI\u0005C\u0006\u000e\u0003a]Q#\u0001M\u00013\u001b!\u0011\u0001\u0003\u0007\u000e\u00051\u0005\u00014\u0001)\u0004\u0002e5A!\u0001E\r\u001b\ta\t\u0001g\u0001Q\u0007\u0005Ij\u0001B\u0001\t\u001b5\u0011A\u0012\u0001M\u000e!\u000e\r\u0011T\u0002\u0003\u0002\u00119i!\u0001$\u0001\u0019\u001cA\u001b!\u0001VB\u0006\u001b\u001bAi\"D\u0001\u0019\u001fU\t\u0001\u0014\u0001+\u0004\f55\u0001rD\u0007\u00021\u0003)\u0012\u0001'\u0001U\u0007\u0017iA\u0004\u0003\t\u000e\u00051\u0005\u0001\u0014C\u000b\u00021\u0003IJ\u0001#\t\u000e\u0003a\t\u0002k!\u0001\u001a\u000e\u0011\t\u00012E\u0007\u0003\u0019\u0003A\"\u0003U\u0002\u00023\u001b!\u0011\u0001#\u0003\u000e\u00051\u0005\u0001$\u0002)\u0004\u0004Q\u001bY!$\u0004\t&5\t\u0001dE\u000b\u00021\u0003!61B\u0007\u0011\u0011OiQ\u0001%\u000b\u0016\u00051\u0005\u0001\u0004\u0006\r\u0015+\u0005AR#'\u0003\t,5\t\u0001D\u0006)\u0004\u0002Q\u001bY!$\u0004\t.5\t\u00014A\u000b\u00021]!61B\u0007)\u0011_i\u0011\u0001g\u0005\u0016\u0003a\u0005\u0011\u0014\u0002\u0005\u0019\u001b\u0005A\u001a\u0001UB\u000133!\u0011\u0001#\r\u000e\u0011%\u0011\u0011\"\u0001M\u0002\u0013\tI\u0011\u0001g\r\r\u0002aI\u0002kA\u0001\u001a\u001c!QRBC\u0005\u0003\u0013\u0005A\u001a!\u0003\u0002\n\u0003aY\u0012BA\u0005\u00021gA*\u0004UB\u0002)\u000e-Q\"\u0004E\u001c\u001b\ta\t\u0001G\u000e\u0016\u0003a\u0005\u0011\u0014\u0002\u0005\u0019\u001b\u0005A\u001a\u0001UB\u0001)\u000e-QR\u0002\u0005\u001d\u001b\u0005AJ$F\u0001\u0019\u0002Q\u001bY!d\n\t;5\t\u00014H\u000b\u00021\u0003IZ\u0001\u0003\u0010\u000e\u00051\u0005\u00014\u0001)\u0004\u0002e-A!\u0001E\u001f\u001b\u0005A\u001a\u0001U\u0002\u0002)\u000e-\u0001"}, strings={"cloneBare", "Lorg/eclipse/jgit/lib/Repository;", "uri", "", "dir", "Ljava/io/File;", "credentialsStore", "Lcom/intellij/openapi/util/NotNullLazyValue;", "Lorg/jetbrains/keychain/CredentialsStore;", "progressMonitor", "Lorg/eclipse/jgit/lib/ProgressMonitor;", "GitExKt", "createBareRepository", "createRepository", "findBranchToCheckout", "Lorg/eclipse/jgit/lib/Ref;", "result", "Lorg/eclipse/jgit/transport/FetchResult;", "wrapIfNeedAndReThrow", "", "e", "Lorg/eclipse/jgit/errors/TransportException;", "commit", "Lorg/eclipse/jgit/revwalk/RevCommit;", "message", "reflogComment", "author", "Lorg/eclipse/jgit/lib/PersonIdent;", "committer", "computeIndexDiff", "Lorg/eclipse/jgit/lib/IndexDiff;", "disableAutoCrLf", "fetch", "remoteConfig", "Lorg/eclipse/jgit/transport/RemoteConfig;", "credentialsProvider", "Lorg/eclipse/jgit/transport/CredentialsProvider;", "getAheadCommitsCount", "", "getCachedBytes", "", "kotlin.jvm.PlatformType", "Lorg/eclipse/jgit/lib/ObjectReader;", "dirCacheEntry", "Lorg/eclipse/jgit/dircache/DirCacheEntry;", "getRemoteBranchFullName", "Lorg/eclipse/jgit/lib/Config;", "processChildren", "path", "filter", "Lkotlin/Function1;", "", "processor", "Lkotlin/Function2;", "Ljava/io/InputStream;", "read", "resetHard", "Lorg/eclipse/jgit/dircache/DirCacheCheckout;", "setUpstream", "Lorg/eclipse/jgit/lib/StoredConfig;", "url", "branchName"}, moduleName="settings-repository")
public final class GitExKt {
    public static final void wrapIfNeedAndReThrow(@NotNull TransportException e) {
        String message;
        block7: {
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                if (e instanceof org.eclipse.jgit.errors.NoRemoteRepositoryException || Intrinsics.areEqual((Object)e.getStatus(), (Object)TransportException.Status.CANNOT_RESOLVE_REPO)) {
                    throw (Throwable)new NoRemoteRepositoryException(e);
                }
                Throwable $receiver = e;
                String string = $receiver.getMessage();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                message = string;
                if (Intrinsics.areEqual((Object)e.getStatus(), (Object)TransportException.Status.NOT_AUTHORIZED) || Intrinsics.areEqual((Object)e.getStatus(), (Object)TransportException.Status.NOT_PERMITTED)) break block6;
                CharSequence charSequence = message;
                CharSequence charSequence2 = JGitText.get().notAuthorized;
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence2, (String)"JGitText.get().notAuthorized");
                if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)charSequence2, (boolean)false, (int)2) && !StringsKt.contains$default((CharSequence)message, (CharSequence)"Auth cancel", (boolean)false, (int)2) && !StringsKt.contains$default((CharSequence)message, (CharSequence)"Auth fail", (boolean)false, (int)2) && !StringsKt.contains$default((CharSequence)message, (CharSequence)": reject HostKey:", (boolean)false, (int)2)) break block7;
            }
            throw (Throwable)new AuthenticationException(e);
        }
        if (Intrinsics.areEqual((Object)e.getStatus(), (Object)TransportException.Status.CANCELLED) || Intrinsics.areEqual((Object)message, (Object)"Download cancelled")) {
            throw (Throwable)new ProcessCanceledException();
        }
        throw (Throwable)e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public static final FetchResult fetch(Repository $receiver, @NotNull RemoteConfig remoteConfig, @Nullable CredentialsProvider credentialsProvider2, @Nullable ProgressMonitor progressMonitor) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)remoteConfig, (String)"remoteConfig");
        try {
            Transport transport = Transport.open((Repository)$receiver, (RemoteConfig)remoteConfig);
            try {
                transport.setCredentialsProvider(credentialsProvider2);
                ProgressMonitor progressMonitor2 = progressMonitor;
                if (progressMonitor2 == null) {
                    progressMonitor2 = (ProgressMonitor)NullProgressMonitor.INSTANCE;
                }
                FetchResult fetchResult = transport.fetch(progressMonitor2, (Collection)null);
                return fetchResult;
            }
            finally {
                transport.close();
            }
        }
        catch (TransportException e) {
            String message;
            void $receiver2;
            Throwable throwable = e;
            String string = $receiver2.getMessage();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if (StringsKt.startsWith$default((String)(message = string), (String)"Remote does not have ", (boolean)false, (int)2)) {
                IcsManagerKt.getLOG().info(message);
                return null;
            }
            GitExKt.wrapIfNeedAndReThrow(e);
            return null;
        }
    }

    @Nullable
    public static /* bridge */ /* synthetic */ FetchResult fetch$default(Repository repository2, RemoteConfig remoteConfig, CredentialsProvider credentialsProvider2, ProgressMonitor progressMonitor, int n) {
        if ((n & 2) != 0) {
            credentialsProvider2 = null;
        }
        if ((n & 4) != 0) {
            progressMonitor = null;
        }
        return GitExKt.fetch(repository2, remoteConfig, credentialsProvider2, progressMonitor);
    }

    @NotNull
    public static final Repository disableAutoCrLf(Repository $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        StoredConfig config = $receiver.getConfig();
        config.setString("core", (String)null, "autocrlf", "false");
        config.save();
        return $receiver;
    }

    @NotNull
    public static final Repository createBareRepository(@NotNull File dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Repository repository2 = ((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setBare()).setGitDir(dir)).build();
        repository2.create(true);
        Repository repository3 = repository2;
        Intrinsics.checkExpressionValueIsNotNull((Object)repository3, (String)"repository");
        return repository3;
    }

    @NotNull
    public static final Repository createRepository(@NotNull File dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Repository repository2 = ((FileRepositoryBuilder)new FileRepositoryBuilder().setWorkTree(dir)).build();
        repository2.create();
        Repository repository3 = repository2;
        Intrinsics.checkExpressionValueIsNotNull((Object)repository3, (String)"repository");
        return repository3;
    }

    @NotNull
    public static final RevCommit commit(Repository $receiver, @Nullable String message, @Nullable String reflogComment, @Nullable PersonIdent author, @Nullable PersonIdent committer) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        CommitCommand commitCommand = new CommitCommand($receiver).setAuthor(author).setCommitter(committer);
        if (message != null) {
            commitCommand.setMessage(message);
        }
        if (reflogComment != null) {
            commitCommand.setReflogComment(reflogComment);
        }
        RevCommit revCommit = commitCommand.call();
        Intrinsics.checkExpressionValueIsNotNull((Object)revCommit, (String)"commitCommand.call()");
        return revCommit;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ RevCommit commit$default(Repository repository2, String string, String string2, PersonIdent personIdent, PersonIdent personIdent2, int n) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            personIdent = null;
        }
        if ((n & 8) != 0) {
            personIdent2 = null;
        }
        return GitExKt.commit(repository2, string, string2, personIdent, personIdent2);
    }

    @NotNull
    public static final DirCacheCheckout resetHard(Repository $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ResetCommand resetCommand = new ResetCommand($receiver).setMode(ResetCommand.ResetType.HARD);
        resetCommand.call();
        DirCacheCheckout dirCacheCheckout = resetCommand.getDirCacheCheckout();
        if (dirCacheCheckout == null) {
            Intrinsics.throwNpe();
        }
        return dirCacheCheckout;
    }

    @NotNull
    public static final String getRemoteBranchFullName(Config $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String name = $receiver.getString("branch", "master", "merge");
        if (StringUtil.isEmpty((String)name)) {
            throw (Throwable)new IllegalStateException("branch.master.merge refspec must be specified");
        }
        String string = name;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @NotNull
    public static final StoredConfig setUpstream(Repository $receiver, @Nullable String url, @NotNull String branchName) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)branchName, (String)"branchName");
        String localBranchName = "master";
        StoredConfig config = $receiver.getConfig();
        String remoteName = "origin";
        if (StringUtil.isEmptyOrSpaces((String)url)) {
            IcsManagerKt.getLOG().debug("Unset remote");
            config.unsetSection("remote", remoteName);
            config.unsetSection("branch", localBranchName);
        } else {
            IcsManagerKt.getLOG().debug("Set remote " + url);
            config.setString("remote", remoteName, "url", url);
            config.setString("remote", remoteName, "fetch", CharsKt.plus((char)'+', (String)"refs/heads/") + branchName + ':' + "refs/remotes/" + remoteName + '/' + branchName);
            config.setString("branch", localBranchName, "remote", remoteName);
            config.setString("branch", localBranchName, "merge", "refs/heads/" + branchName);
        }
        config.save();
        StoredConfig storedConfig = config;
        Intrinsics.checkExpressionValueIsNotNull((Object)storedConfig, (String)"config");
        return storedConfig;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ StoredConfig setUpstream$default(Repository repository2, String string, String string2, int n) {
        if ((n & 2) != 0) {
            string2 = "master";
        }
        return GitExKt.setUpstream(repository2, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final IndexDiff computeIndexDiff(Repository $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        FileTreeIterator workingTreeIterator = new FileTreeIterator($receiver);
        try {
            IndexDiff indexDiff = new IndexDiff($receiver, "HEAD", (WorkingTreeIterator)workingTreeIterator);
            return indexDiff;
        }
        finally {
            workingTreeIterator.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final Repository cloneBare(@NotNull String uri, @NotNull File dir, @Nullable NotNullLazyValue<CredentialsStore> credentialsStore2, @NotNull ProgressMonitor progressMonitor) {
        RevWalk it;
        void $receiver;
        Object branchName;
        void head;
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull((Object)progressMonitor, (String)"progressMonitor");
        Repository repository2 = GitExKt.createBareRepository(dir);
        StoredConfig config = GitExKt.setUpstream$default(repository2, uri, null, 2);
        RemoteConfig remoteConfig = new RemoteConfig((Config)config, "origin");
        FetchResult fetchResult = GitExKt.fetch(repository2, remoteConfig, credentialsStore2 == null ? (JGitCredentialsProvider)null : new JGitCredentialsProvider(credentialsStore2, repository2), progressMonitor);
        if (fetchResult == null) {
            return repository2;
        }
        FetchResult result = fetchResult;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = GitExKt.findBranchToCheckout(result);
        if ((Ref)head.element == null) {
            Object object;
            String branch = "HEAD";
            Ref ref = result.getAdvertisedRef(branch);
            if (ref == null) {
                ref = object = result.getAdvertisedRef("refs/heads/" + branch);
            }
            if (ref == null) {
                object = head.element = result.getAdvertisedRef("refs/tags/" + branch);
            }
        }
        if ((Ref)head.element == null || ((Ref)head.element).getObjectId() == null) {
            return repository2;
        }
        if (StringsKt.startsWith$default((String)((Ref)head.element).getName(), (String)"refs/heads/", (boolean)false, (int)2)) {
            RefUpdate newHead = repository2.updateRef("HEAD");
            newHead.disableRefLog();
            newHead.link(((Ref)head.element).getName());
            branchName = Repository.shortenRefName((String)((Ref)head.element).getName());
            config.setString("branch", (String)branchName, "remote", "origin");
            config.setString("branch", (String)branchName, "merge", ((Ref)head.element).getName());
            String autoSetupRebase = config.getString("branch", (String)null, "autosetuprebase");
            if (Intrinsics.areEqual((Object)"always", (Object)autoSetupRebase) || Intrinsics.areEqual((Object)"remote", (Object)autoSetupRebase)) {
                config.setBoolean("branch", (String)branchName, "rebase", true);
            }
            config.save();
        }
        branchName = (Closeable)new RevWalk(repository2);
        boolean closed = false;
        try {
            it = (RevWalk)$receiver;
            Ref ref = (Ref)head.element;
            if (ref == null) {
                Intrinsics.throwNpe();
            }
            it = it.parseCommit((AnyObjectId)ref.getObjectId());
        }
        catch (Exception e) {
            closed = true;
            try {
                $receiver.close();
            }
            catch (Exception closeException) {
                // empty catch block
            }
            throw (Throwable)e;
        }
        finally {
            if (!closed) {
                $receiver.close();
            }
        }
        RevCommit commit = (RevCommit)it;
        Ref ref = (Ref)head.element;
        if (ref == null) {
            Intrinsics.throwNpe();
        }
        RefUpdate u = repository2.updateRef("HEAD", !StringsKt.startsWith$default((String)ref.getName(), (String)"refs/heads/", (boolean)false, (int)2));
        u.setNewObjectId((AnyObjectId)commit.getId());
        u.forceUpdate();
        return repository2;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Repository cloneBare$default(String string, File file, NotNullLazyValue notNullLazyValue, ProgressMonitor progressMonitor, int n) {
        if ((n & 4) != 0) {
            notNullLazyValue = null;
        }
        if ((n & 8) != 0) {
            NullProgressMonitor nullProgressMonitor = NullProgressMonitor.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)nullProgressMonitor, (String)"NullProgressMonitor.INSTANCE");
            progressMonitor = (ProgressMonitor)nullProgressMonitor;
        }
        return GitExKt.cloneBare(string, file, (NotNullLazyValue<CredentialsStore>)notNullLazyValue, progressMonitor);
    }

    private static final Ref findBranchToCheckout(FetchResult result) {
        Ref ref = result.getAdvertisedRef("HEAD");
        if (ref == null) {
            return null;
        }
        Ref idHead = ref;
        Ref master = result.getAdvertisedRef("refs/heads/" + "master");
        if (master != null && master.getObjectId().equals((AnyObjectId)idHead.getObjectId())) {
            return master;
        }
        for (Ref r : result.getAdvertisedRefs()) {
            if (!StringsKt.startsWith$default((String)r.getName(), (String)"refs/heads/", (boolean)false, (int)2) || !r.getObjectId().equals((AnyObjectId)idHead.getObjectId())) continue;
            return r;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void processChildren(Repository $receiver, @NotNull String path, @Nullable Function1<? super String, ? extends Boolean> filter, @NotNull Function2<? super String, ? super InputStream, ? extends Boolean> processor) {
        void $receiver2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        ObjectId objectId = $receiver.resolve("HEAD");
        if (objectId == null) {
            return;
        }
        ObjectId lastCommitId = objectId;
        ObjectReader reader = $receiver.newObjectReader();
        Closeable closeable = (Closeable)reader;
        boolean closed = false;
        try {
            TreeWalk treeWalk;
            ObjectReader it = (ObjectReader)$receiver2;
            if (TreeWalk.forPath((ObjectReader)reader, (String)path, (AnyObjectId[])new AnyObjectId[]{(AnyObjectId)new RevWalk(reader).parseCommit((AnyObjectId)lastCommitId).getTree()}) == null) {
                return;
            }
            TreeWalk treeWalk2 = treeWalk;
            if (!treeWalk2.isSubtree()) {
                IcsManagerKt.getLOG().warn("File " + path + " is not a directory");
                return;
            }
            treeWalk2.setFilter(TreeFilter.ALL);
            treeWalk2.enterSubtree();
            while (treeWalk2.next()) {
                ObjectLoader objectLoader;
                FileMode fileMode = treeWalk2.getFileMode(0);
                if (!Intrinsics.areEqual((Object)fileMode, (Object)FileMode.REGULAR_FILE) && !Intrinsics.areEqual((Object)fileMode, (Object)FileMode.SYMLINK) && !Intrinsics.areEqual((Object)fileMode, (Object)FileMode.EXECUTABLE_FILE)) continue;
                String fileName = treeWalk2.getNameString();
                if (filter != null) {
                    String string = fileName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileName");
                    if (!((Boolean)filter.invoke((Object)string)).booleanValue()) continue;
                }
                if ((objectLoader = reader.open((AnyObjectId)treeWalk2.getObjectId(0), 3)).getSize() == 0L) {
                    IcsManagerKt.getLOG().warn("File " + path + " skipped because empty (length 0)");
                    continue;
                }
                String string = fileName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileName");
                ObjectStream objectStream = objectLoader.openStream();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectStream, (String)"objectLoader.openStream()");
                if (((Boolean)processor.invoke((Object)string, (Object)objectStream)).booleanValue()) continue;
                break;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception e) {
            closed = true;
            try {
                $receiver2.close();
            }
            catch (Exception closeException) {
                // empty catch block
            }
            throw (Throwable)e;
        }
        finally {
            if (!closed) {
                $receiver2.close();
            }
        }
    }

    public static /* bridge */ /* synthetic */ void processChildren$default(Repository repository2, String string, Function1 function1, Function2 function2, int n) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        GitExKt.processChildren(repository2, string, (Function1<? super String, ? extends Boolean>)function1, (Function2<? super String, ? super InputStream, ? extends Boolean>)function2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final InputStream read(Repository $receiver, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        ObjectId lastCommitId = $receiver.resolve("HEAD");
        if (lastCommitId == null) {
            IcsManagerKt.getLOG().warn("Repository " + $receiver.getDirectory().getName() + " doesn't have HEAD");
            return null;
        }
        ObjectReader reader = $receiver.newObjectReader();
        boolean releaseReader = true;
        try {
            TreeWalk treeWalk;
            if (TreeWalk.forPath((ObjectReader)reader, (String)path, (AnyObjectId[])new AnyObjectId[]{(AnyObjectId)new RevWalk(reader).parseCommit((AnyObjectId)lastCommitId).getTree()}) == null) {
                InputStream inputStream = null;
                return inputStream;
            }
            TreeWalk treeWalk2 = treeWalk;
            ObjectLoader objectLoader = reader.open((AnyObjectId)treeWalk2.getObjectId(0), 3);
            ObjectStream input = objectLoader.openStream();
            if (objectLoader.isLarge()) {
                releaseReader = false;
                InputStream inputStream = (InputStream)input;
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"input");
                ObjectReader objectReader = reader;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectReader, (String)"reader");
                InputStream inputStream2 = new InputStreamWrapper(inputStream, objectReader);
                return inputStream2;
            }
            InputStream inputStream = (InputStream)input;
            return inputStream;
        }
        finally {
            if (releaseReader) {
                reader.close();
            }
        }
    }

    public static final byte[] getCachedBytes(ObjectReader $receiver, @NotNull DirCacheEntry dirCacheEntry) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)dirCacheEntry, (String)"dirCacheEntry");
        return $receiver.open((AnyObjectId)dirCacheEntry.getObjectId(), 3).getCachedBytes();
    }

    /*
     * WARNING - void declaration
     */
    public static final int getAheadCommitsCount(Repository $receiver) {
        RevCommit revCommit;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        StoredConfig config = $receiver.getConfig();
        String shortBranchName = Repository.shortenRefName((String)GitExKt.getRemoteBranchFullName((Config)config));
        String string = new BranchConfig((Config)config, shortBranchName).getTrackingBranch();
        if (string == null) {
            return -1;
        }
        String trackingBranch = string;
        Ref ref = $receiver.getRef("refs/heads/" + shortBranchName);
        if (ref == null) {
            return -1;
        }
        Ref local = ref;
        RevWalk walk = new RevWalk($receiver);
        RevCommit localCommit = walk.parseCommit((AnyObjectId)local.getObjectId());
        Ref ref2 = $receiver.getRef(trackingBranch);
        if (ref2 != null) {
            void $receiver2;
            Ref ref3 = ref2;
            Ref it = (Ref)$receiver2;
            revCommit = walk.parseCommit((AnyObjectId)it.getObjectId());
        } else {
            revCommit = null;
        }
        RevCommit trackingCommit = revCommit;
        walk.setRevFilter(RevFilter.MERGE_BASE);
        if (trackingCommit == null) {
            walk.markStart(localCommit);
            walk.sort(RevSort.REVERSE);
        } else {
            walk.markStart(localCommit);
            walk.markStart(trackingCommit);
            RevCommit mergeBase = walk.next();
            walk.reset();
            walk.markStart(localCommit);
            walk.markUninteresting(mergeBase);
        }
        walk.setRevFilter(RevFilter.ALL);
        int num = 0;
        for (RevCommit c : walk) {
            ++num;
        }
        return num;
    }
}

