/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang;

import com.intellij.lang.Language;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.FileContentUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionConfigBean;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.InjectionPlace;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Configuration
extends SimpleModificationTracker
implements PersistentStateComponent<Element>,
ModificationTracker {
    static final Logger LOG = Logger.getInstance((String)Configuration.class.getName());
    private static final Condition<BaseInjection> LANGUAGE_INJECTION_CONDITION = new Condition<BaseInjection>(){

        public boolean value(BaseInjection o) {
            return Language.findLanguageByID((String)o.getInjectedLanguageId()) != null;
        }
    };
    @NonNls
    public static final String COMPONENT_NAME = "LanguageInjectionConfiguration";
    @NonNls
    private static final String INSTRUMENTATION_TYPE_NAME = "INSTRUMENTATION";
    @NonNls
    private static final String LANGUAGE_ANNOTATION_NAME = "LANGUAGE_ANNOTATION";
    @NonNls
    private static final String PATTERN_ANNOTATION_NAME = "PATTERN_ANNOTATION";
    @NonNls
    private static final String SUBST_ANNOTATION_NAME = "SUBST_ANNOTATION";
    @NonNls
    private static final String RESOLVE_REFERENCES = "RESOLVE_REFERENCES";
    @NonNls
    private static final String LOOK_FOR_VAR_ASSIGNMENTS = "LOOK_FOR_VAR_ASSIGNMENTS";
    @NonNls
    private static final String USE_DFA_IF_AVAILABLE = "USE_DFA_IF_AVAILABLE";
    @NonNls
    private static final String INCLUDE_UNCOMPUTABLES_AS_LITERALS = "INCLUDE_UNCOMPUTABLES_AS_LITERALS";
    @NonNls
    private static final String SOURCE_MODIFICATION_ALLOWED = "SOURCE_MODIFICATION_ALLOWED";
    private final Map<String, List<BaseInjection>> myInjections = new ConcurrentFactoryMap<String, List<BaseInjection>>(){

        protected List<BaseInjection> create(String key) {
            return ContainerUtil.createLockFreeCopyOnWriteList();
        }
    };
    private final CachedValue<MultiMap<String, BaseInjection>> myInjectionsById = new CachedValueImpl((CachedValueProvider)new CachedValueProvider<MultiMap<String, BaseInjection>>(){

        @Nullable
        public CachedValueProvider.Result<MultiMap<String, BaseInjection>> compute() {
            MultiMap map = new MultiMap();
            for (BaseInjection injection : Configuration.this.getAllInjections()) {
                map.putValue((Object)injection.getInjectedLanguageId(), (Object)injection);
            }
            return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{Configuration.this});
        }
    });

    protected Collection<BaseInjection> getAllInjections() {
        ArrayList<BaseInjection> injections = new ArrayList<BaseInjection>();
        for (List<BaseInjection> list : this.myInjections.values()) {
            injections.addAll(list);
        }
        return injections;
    }

    public AdvancedConfiguration getAdvancedConfiguration() {
        throw new UnsupportedOperationException("getAdvancedConfiguration should not be called");
    }

    public void loadState(Element element) {
        this.myInjections.clear();
        THashMap supports = new THashMap();
        for (LanguageInjectionSupport support : InjectorUtils.getActiveInjectionSupports()) {
            supports.put(support.getId(), support);
        }
        for (Element child : element.getChildren("injection")) {
            String key = child.getAttributeValue("injector-id");
            LanguageInjectionSupport support = (LanguageInjectionSupport)supports.get(key);
            BaseInjection injection = support == null ? new BaseInjection(key) : support.createInjection(child);
            injection.loadState(child);
            InjectionPlace[] places = Configuration.dropKnownInvalidPlaces(injection.getInjectionPlaces());
            if (places == null) continue;
            injection.setInjectionPlaces(places);
            this.myInjections.get(key).add(injection);
        }
        this.importPlaces(this.getDefaultInjections());
    }

    @Nullable
    private static InjectionPlace[] dropKnownInvalidPlaces(InjectionPlace[] places) {
        Object[] result = places;
        for (InjectionPlace place : places) {
            if (!place.getText().contains("matches(\"[^${}/\\\\]+\")")) continue;
            result = (InjectionPlace[])ArrayUtil.remove((Object[])result, (Object)place);
        }
        return places.length != 0 && result.length == 0 ? null : result;
    }

    private static boolean readBoolean(Element element, String key, boolean defValue) {
        String value = JDOMExternalizerUtil.readField((Element)element, (String)key);
        if (value == null) {
            return defValue;
        }
        return Boolean.parseBoolean(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<BaseInjection> loadDefaultInjections() {
        ArrayList<Configuration> cfgList = new ArrayList<Configuration>();
        THashSet visited = new THashSet();
        for (LanguageInjectionConfigBean configBean : (LanguageInjectionConfigBean[])Extensions.getExtensions(LanguageInjectionSupport.CONFIG_EP_NAME)) {
            PluginDescriptor descriptor = configBean.getPluginDescriptor();
            ClassLoader loader = descriptor.getPluginClassLoader();
            try {
                Enumeration<URL> enumeration = loader.getResources(configBean.getConfigUrl());
                if (enumeration == null || !enumeration.hasMoreElements()) {
                    LOG.warn(descriptor.getPluginId() + ": " + configBean.getConfigUrl() + " was not found");
                    continue;
                }
                while (enumeration.hasMoreElements()) {
                    URL url = enumeration.nextElement();
                    if (!visited.add(url.getFile())) continue;
                    InputStream stream = null;
                    try {
                        stream = url.openStream();
                        cfgList.add(Configuration.load(stream));
                    }
                    catch (Exception e) {
                        LOG.warn((Throwable)e);
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
        ArrayList<BaseInjection> defaultInjections = new ArrayList<BaseInjection>();
        for (String supportId : InjectorUtils.getActiveInjectionSupportIds()) {
            for (Configuration cfg : cfgList) {
                List<BaseInjection> imported = cfg.getInjections(supportId);
                defaultInjections.addAll(imported);
            }
        }
        return defaultInjections;
    }

    public Element getState() {
        return this.getState(new Element(COMPONENT_NAME));
    }

    protected Element getState(Element element) {
        Comparator<BaseInjection> comparator = new Comparator<BaseInjection>(){

            @Override
            public int compare(BaseInjection o1, BaseInjection o2) {
                return Comparing.compare((Comparable)((Object)o1.getDisplayName()), (Comparable)((Object)o2.getDisplayName()));
            }
        };
        ArrayList<String> injectorIds = new ArrayList<String>(this.myInjections.keySet());
        Collections.sort(injectorIds);
        for (String key : injectorIds) {
            TreeSet<BaseInjection> injections = new TreeSet<BaseInjection>(comparator);
            injections.addAll((Collection<BaseInjection>)this.myInjections.get(key));
            injections.removeAll(this.getDefaultInjections());
            for (BaseInjection injection : injections) {
                element.addContent(injection.getState());
            }
        }
        return element;
    }

    public static Configuration getInstance() {
        return (Configuration)((Object)ServiceManager.getService(Configuration.class));
    }

    public static Configuration getProjectInstance(Project project) {
        return (Configuration)((Object)ServiceManager.getService((Project)project, Configuration.class));
    }

    public List<BaseInjection> getDefaultInjections() {
        return Collections.emptyList();
    }

    public Collection<BaseInjection> getInjectionsByLanguageId(String languageId) {
        return ((MultiMap)this.myInjectionsById.getValue()).get((Object)languageId);
    }

    @Nullable
    public static Configuration load(InputStream is) throws IOException, JDOMException {
        Element state;
        ArrayList<Element> elements = new ArrayList<Element>();
        Element rootElement = JDOMUtil.load((InputStream)is);
        if (rootElement.getName().equals(COMPONENT_NAME)) {
            state = rootElement;
        } else {
            elements.add(rootElement);
            elements.addAll(rootElement.getChildren("component"));
            state = (Element)ContainerUtil.find(elements, (Condition)new Condition<Element>(){

                public boolean value(Element element) {
                    return "component".equals(element.getName()) && Configuration.COMPONENT_NAME.equals(element.getAttributeValue("name"));
                }
            });
        }
        if (state != null) {
            Configuration cfg = new Configuration();
            cfg.loadState(state);
            return cfg;
        }
        return null;
    }

    private int importPlaces(List<BaseInjection> injections) {
        Map map = ContainerUtil.classify(injections.iterator(), (Convertor)new Convertor<BaseInjection, String>(){

            public String convert(BaseInjection o) {
                return o.getSupportId();
            }
        });
        ArrayList<BaseInjection> originalInjections = new ArrayList<BaseInjection>();
        ArrayList<BaseInjection> newInjections = new ArrayList<BaseInjection>();
        for (String supportId : InjectorUtils.getActiveInjectionSupportIds()) {
            Set importingInjections = (Set)map.get(supportId);
            if (importingInjections == null) continue;
            Configuration.importInjections(this.getInjections(supportId), importingInjections, originalInjections, newInjections);
        }
        if (!newInjections.isEmpty()) {
            this.configurationModified();
        }
        this.replaceInjections(newInjections, originalInjections, true);
        return newInjections.size();
    }

    static void importInjections(Collection<BaseInjection> existingInjections, Collection<BaseInjection> importingInjections, Collection<BaseInjection> originalInjections, Collection<BaseInjection> newInjections) {
        final MultiValuesMap placeMap = new MultiValuesMap();
        for (BaseInjection exising : existingInjections) {
            for (InjectionPlace place : exising.getInjectionPlaces()) {
                placeMap.put((Object)place, (Object)exising);
            }
        }
        block2: for (BaseInjection other : importingInjections) {
            List matchingInjections = ContainerUtil.concat((Object[])other.getInjectionPlaces(), (Function)new Function<InjectionPlace, Collection<? extends BaseInjection>>(){

                public Collection<? extends BaseInjection> fun(InjectionPlace o) {
                    Collection collection = placeMap.get((Object)o);
                    return collection == null ? Collections.emptyList() : collection;
                }
            });
            if (matchingInjections.isEmpty()) {
                newInjections.add(other);
                continue;
            }
            BaseInjection existing = null;
            for (BaseInjection injection : matchingInjections) {
                if (injection.equals(other)) continue block2;
                if (existing != null || !injection.sameLanguageParameters(other)) continue;
                existing = injection;
            }
            if (existing == null) continue;
            BaseInjection newInjection = existing.copy();
            newInjection.mergeOriginalPlacesFrom(other, true);
            if (newInjection.equals(existing)) continue;
            originalInjections.add(existing);
            newInjections.add(newInjection);
        }
    }

    private void configurationModified() {
        this.incModificationCount();
    }

    @Nullable
    public BaseInjection findExistingInjection(@NotNull BaseInjection injection) {
        if (injection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injection", "org/intellij/plugins/intelliLang/Configuration", "findExistingInjection"));
        }
        List<BaseInjection> list = this.getInjections(injection.getSupportId());
        for (BaseInjection cur : list) {
            if (!cur.intersectsWith(injection)) continue;
            return cur;
        }
        return null;
    }

    public boolean setHostInjectionEnabled(PsiLanguageInjectionHost host, Collection<String> languages, boolean enabled) {
        ArrayList<BaseInjection> originalInjections = new ArrayList<BaseInjection>();
        ArrayList<BaseInjection> newInjections = new ArrayList<BaseInjection>();
        for (LanguageInjectionSupport support : InjectorUtils.getActiveInjectionSupports()) {
            for (BaseInjection injection : this.getInjections(support.getId())) {
                if (!languages.contains(injection.getInjectedLanguageId())) continue;
                boolean replace = false;
                ArrayList<InjectionPlace> newPlaces = new ArrayList<InjectionPlace>();
                for (InjectionPlace place : injection.getInjectionPlaces()) {
                    if (place.isEnabled() != enabled && place.getElementPattern() != null && (place.getElementPattern().accepts((Object)host) || place.getElementPattern().accepts((Object)host.getParent()))) {
                        newPlaces.add(place.enabled(enabled));
                        replace = true;
                        continue;
                    }
                    newPlaces.add(place);
                }
                if (!replace) continue;
                originalInjections.add(injection);
                BaseInjection newInjection = injection.copy();
                newInjection.setInjectionPlaces(newPlaces.toArray(new InjectionPlace[newPlaces.size()]));
                newInjections.add(newInjection);
            }
        }
        if (!originalInjections.isEmpty()) {
            this.replaceInjectionsWithUndo(host.getProject(), newInjections, originalInjections, Collections.emptyList());
            return true;
        }
        return false;
    }

    protected void setInjections(Collection<BaseInjection> injections) {
        for (BaseInjection injection : injections) {
            this.myInjections.get(injection.getSupportId()).add(injection);
        }
    }

    @NotNull
    public List<BaseInjection> getInjections(String injectorId) {
        List<BaseInjection> list = Collections.unmodifiableList(this.myInjections.get(injectorId));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/Configuration", "getInjections"));
        }
        return list;
    }

    public void replaceInjectionsWithUndo(Project project, List<? extends BaseInjection> newInjections, List<? extends BaseInjection> originalInjections, List<? extends PsiElement> psiElementsToRemove) {
        Configuration.replaceInjectionsWithUndo(project, newInjections, originalInjections, psiElementsToRemove, new PairProcessor<List<? extends BaseInjection>, List<? extends BaseInjection>>(){

            public boolean process(List<? extends BaseInjection> add, List<? extends BaseInjection> remove) {
                Configuration.this.replaceInjectionsWithUndoInner(add, remove);
                if (ContainerUtil.find(add, (Condition)LANGUAGE_INJECTION_CONDITION) != null || ContainerUtil.find(remove, (Condition)LANGUAGE_INJECTION_CONDITION) != null) {
                    FileContentUtil.reparseOpenedFiles();
                }
                return true;
            }
        });
    }

    protected void replaceInjectionsWithUndoInner(List<? extends BaseInjection> add, List<? extends BaseInjection> remove) {
        this.replaceInjections(add, remove, false);
    }

    public static <T> void replaceInjectionsWithUndo(final Project project, final T add, final T remove, final List<? extends PsiElement> psiElementsToRemove, final PairProcessor<T, T> actualProcessor) {
        GlobalUndoableAction action = new GlobalUndoableAction(){

            public void undo() {
                actualProcessor.process(remove, add);
            }

            public void redo() {
                actualProcessor.process(add, remove);
            }
        };
        List psiFiles = ContainerUtil.mapNotNull(psiElementsToRemove, (Function)new NullableFunction<PsiElement, PsiFile>(){

            public PsiFile fun(PsiElement psiAnnotation) {
                return psiAnnotation instanceof PsiCompiledElement ? null : psiAnnotation.getContainingFile();
            }
        });
        new WriteCommandAction.Simple(project, "Language Injection Configuration Update", PsiUtilCore.toPsiFileArray((Collection)psiFiles), (UndoableAction)action){
            final /* synthetic */ UndoableAction val$action;
            {
                this.val$action = undoableAction;
                super(x0, x1, x2);
            }

            public void run() {
                for (PsiElement annotation : psiElementsToRemove) {
                    annotation.delete();
                }
                actualProcessor.process(add, remove);
                UndoManager.getInstance((Project)project).undoableActionPerformed(this.val$action);
            }

            protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
            }
        }.execute();
    }

    public boolean replaceInjections(List<? extends BaseInjection> newInjections, List<? extends BaseInjection> originalInjections, boolean forceLevel) {
        boolean changed = false;
        for (BaseInjection baseInjection : originalInjections) {
            changed |= this.myInjections.get(baseInjection.getSupportId()).remove(baseInjection);
        }
        for (BaseInjection baseInjection : newInjections) {
            changed |= this.myInjections.get(baseInjection.getSupportId()).add(baseInjection);
        }
        if (changed) {
            this.configurationModified();
        }
        return changed;
    }

    static /* synthetic */ List access$000() {
        return Configuration.loadDefaultInjections();
    }

    public static class AdvancedConfiguration {
        @NotNull
        private InstrumentationType myInstrumentationType = InstrumentationType.ASSERT;
        @NotNull
        private String myLanguageAnnotation;
        @NotNull
        private String myPatternAnnotation;
        @NotNull
        private String mySubstAnnotation;
        private boolean myIncludeUncomputablesAsLiterals;
        private DfaOption myDfaOption = DfaOption.RESOLVE;
        private boolean mySourceModificationAllowed;
        private Pair<String, ? extends Set<String>> myLanguageAnnotationPair;
        private Pair<String, ? extends Set<String>> myPatternAnnotationPair;
        private Pair<String, ? extends Set<String>> mySubstAnnotationPair;

        public AdvancedConfiguration() {
            this.setLanguageAnnotation("org.intellij.lang.annotations.Language");
            this.setPatternAnnotation("org.intellij.lang.annotations.Pattern");
            this.setSubstAnnotation("org.intellij.lang.annotations.Subst");
        }

        public String getLanguageAnnotationClass() {
            return this.myLanguageAnnotation;
        }

        public String getPatternAnnotationClass() {
            return this.myPatternAnnotation;
        }

        public String getSubstAnnotationClass() {
            return this.mySubstAnnotation;
        }

        public void setInstrumentationType(@Nullable String type) {
            if (type != null) {
                this.setInstrumentationType(InstrumentationType.valueOf(type));
            }
        }

        public void setInstrumentationType(@NotNull InstrumentationType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/intellij/plugins/intelliLang/Configuration$AdvancedConfiguration", "setInstrumentationType"));
            }
            this.myInstrumentationType = type;
        }

        public void setLanguageAnnotation(@Nullable String languageAnnotation) {
            if (languageAnnotation == null) {
                return;
            }
            this.myLanguageAnnotation = languageAnnotation;
            this.myLanguageAnnotationPair = Pair.create((Object)languageAnnotation, Collections.singleton(languageAnnotation));
        }

        public Pair<String, ? extends Set<String>> getLanguageAnnotationPair() {
            return this.myLanguageAnnotationPair;
        }

        public void setPatternAnnotation(@Nullable String patternAnnotation) {
            if (patternAnnotation == null) {
                return;
            }
            this.myPatternAnnotation = patternAnnotation;
            this.myPatternAnnotationPair = Pair.create((Object)patternAnnotation, Collections.singleton(patternAnnotation));
        }

        public Pair<String, ? extends Set<String>> getPatternAnnotationPair() {
            return this.myPatternAnnotationPair;
        }

        public void setSubstAnnotation(@Nullable String substAnnotation) {
            if (substAnnotation == null) {
                return;
            }
            this.mySubstAnnotation = substAnnotation;
            this.mySubstAnnotationPair = Pair.create((Object)substAnnotation, Collections.singleton(substAnnotation));
        }

        public Pair<String, ? extends Set<String>> getSubstAnnotationPair() {
            return this.mySubstAnnotationPair;
        }

        public boolean isIncludeUncomputablesAsLiterals() {
            return this.myIncludeUncomputablesAsLiterals;
        }

        public void setIncludeUncomputablesAsLiterals(boolean flag) {
            this.myIncludeUncomputablesAsLiterals = flag;
        }

        @NotNull
        public DfaOption getDfaOption() {
            DfaOption dfaOption = this.myDfaOption;
            if (dfaOption == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/Configuration$AdvancedConfiguration", "getDfaOption"));
            }
            return dfaOption;
        }

        public void setDfaOption(@NotNull DfaOption dfaOption) {
            if (dfaOption == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaOption", "org/intellij/plugins/intelliLang/Configuration$AdvancedConfiguration", "setDfaOption"));
            }
            this.myDfaOption = dfaOption;
        }

        public boolean isSourceModificationAllowed() {
            return this.mySourceModificationAllowed;
        }

        public void setSourceModificationAllowed(boolean sourceModificationAllowed) {
            this.mySourceModificationAllowed = sourceModificationAllowed;
        }

        public InstrumentationType getInstrumentation() {
            return this.myInstrumentationType;
        }

        private void writeState(Element element) {
            JDOMExternalizerUtil.writeField((Element)element, (String)Configuration.INSTRUMENTATION_TYPE_NAME, (String)this.myInstrumentationType.toString());
            JDOMExternalizerUtil.writeField((Element)element, (String)Configuration.LANGUAGE_ANNOTATION_NAME, (String)this.myLanguageAnnotation);
            JDOMExternalizerUtil.writeField((Element)element, (String)Configuration.PATTERN_ANNOTATION_NAME, (String)this.myPatternAnnotation);
            JDOMExternalizerUtil.writeField((Element)element, (String)Configuration.SUBST_ANNOTATION_NAME, (String)this.mySubstAnnotation);
            if (this.myIncludeUncomputablesAsLiterals) {
                JDOMExternalizerUtil.writeField((Element)element, (String)Configuration.INCLUDE_UNCOMPUTABLES_AS_LITERALS, (String)"true");
            }
            if (this.mySourceModificationAllowed) {
                JDOMExternalizerUtil.writeField((Element)element, (String)Configuration.SOURCE_MODIFICATION_ALLOWED, (String)"true");
            }
            switch (this.myDfaOption) {
                case OFF: {
                    break;
                }
                case RESOLVE: {
                    JDOMExternalizerUtil.writeField((Element)element, (String)Configuration.RESOLVE_REFERENCES, (String)Boolean.TRUE.toString());
                    break;
                }
                case ASSIGNMENTS: {
                    JDOMExternalizerUtil.writeField((Element)element, (String)Configuration.LOOK_FOR_VAR_ASSIGNMENTS, (String)Boolean.TRUE.toString());
                    break;
                }
                case DFA: {
                    JDOMExternalizerUtil.writeField((Element)element, (String)Configuration.USE_DFA_IF_AVAILABLE, (String)Boolean.TRUE.toString());
                }
            }
        }

        private void loadState(Element element) {
            this.setInstrumentationType(JDOMExternalizerUtil.readField((Element)element, (String)Configuration.INSTRUMENTATION_TYPE_NAME));
            this.setLanguageAnnotation(JDOMExternalizerUtil.readField((Element)element, (String)Configuration.LANGUAGE_ANNOTATION_NAME));
            this.setPatternAnnotation(JDOMExternalizerUtil.readField((Element)element, (String)Configuration.PATTERN_ANNOTATION_NAME));
            this.setSubstAnnotation(JDOMExternalizerUtil.readField((Element)element, (String)Configuration.SUBST_ANNOTATION_NAME));
            if (Configuration.readBoolean(element, Configuration.RESOLVE_REFERENCES, true)) {
                this.setDfaOption(DfaOption.RESOLVE);
            }
            if (Configuration.readBoolean(element, Configuration.LOOK_FOR_VAR_ASSIGNMENTS, false)) {
                this.setDfaOption(DfaOption.ASSIGNMENTS);
            }
            if (Configuration.readBoolean(element, Configuration.USE_DFA_IF_AVAILABLE, false)) {
                this.setDfaOption(DfaOption.DFA);
            }
            this.setIncludeUncomputablesAsLiterals(Configuration.readBoolean(element, Configuration.INCLUDE_UNCOMPUTABLES_AS_LITERALS, false));
            this.setSourceModificationAllowed(Configuration.readBoolean(element, Configuration.SOURCE_MODIFICATION_ALLOWED, false));
        }
    }

    public static enum DfaOption {
        OFF,
        RESOLVE,
        ASSIGNMENTS,
        DFA;

    }

    public static enum InstrumentationType {
        NONE,
        ASSERT,
        EXCEPTION;

    }

    @State(name="LanguageInjectionConfiguration", defaultStateAsResource=true, storages={@Storage(file="$PROJECT_FILE$"), @Storage(file="$PROJECT_CONFIG_DIR$/IntelliLang.xml", scheme=StorageScheme.DIRECTORY_BASED)})
    public static class Prj
    extends Configuration {
        private final Configuration myParentConfiguration;

        Prj(Configuration configuration) {
            this.myParentConfiguration = configuration;
        }

        @Override
        public AdvancedConfiguration getAdvancedConfiguration() {
            return this.myParentConfiguration.getAdvancedConfiguration();
        }

        @Override
        public List<BaseInjection> getDefaultInjections() {
            return this.myParentConfiguration.getDefaultInjections();
        }

        @Override
        protected Collection<BaseInjection> getAllInjections() {
            Collection<BaseInjection> injections = super.getAllInjections();
            injections.addAll(this.myParentConfiguration.getAllInjections());
            return injections;
        }

        @Override
        @NotNull
        public List<BaseInjection> getInjections(String injectorId) {
            List list = ContainerUtil.concat(this.myParentConfiguration.getInjections(injectorId), this.getOwnInjections(injectorId));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/Configuration$Prj", "getInjections"));
            }
            return list;
        }

        public Configuration getParentConfiguration() {
            return this.myParentConfiguration;
        }

        public List<BaseInjection> getOwnInjections(String injectorId) {
            return super.getInjections(injectorId);
        }

        public long getModificationCount() {
            return super.getModificationCount() + this.myParentConfiguration.getModificationCount();
        }

        @Override
        public boolean replaceInjections(List<? extends BaseInjection> newInjections, List<? extends BaseInjection> originalInjections, boolean forceLevel) {
            if (!forceLevel && !originalInjections.isEmpty() && this.myParentConfiguration.replaceInjections(Collections.emptyList(), originalInjections, false)) {
                this.myParentConfiguration.replaceInjections(newInjections, Collections.emptyList(), false);
                return true;
            }
            return super.replaceInjections(newInjections, originalInjections, forceLevel);
        }
    }

    @State(name="LanguageInjectionConfiguration", defaultStateAsResource=true, storages={@Storage(file="$APP_CONFIG$/IntelliLang.xml", scheme=StorageScheme.DIRECTORY_BASED)})
    public static class App
    extends Configuration {
        private final List<BaseInjection> myDefaultInjections = Configuration.access$000();
        private final AdvancedConfiguration myAdvancedConfiguration = new AdvancedConfiguration();

        App() {
        }

        @Override
        public List<BaseInjection> getDefaultInjections() {
            return this.myDefaultInjections;
        }

        @Override
        public AdvancedConfiguration getAdvancedConfiguration() {
            return this.myAdvancedConfiguration;
        }

        @Override
        public void loadState(Element element) {
            this.myAdvancedConfiguration.loadState(element);
            super.loadState(element);
        }

        @Override
        public Element getState() {
            Element element = new Element(Configuration.COMPONENT_NAME);
            this.myAdvancedConfiguration.writeState(element);
            return this.getState(element);
        }
    }
}

