/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class FileReferenceInjector
extends ReferenceInjector {
    @NotNull
    public String getId() {
        if ("file-reference" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/references/FileReferenceInjector", "getId"));
        }
        return "file-reference";
    }

    @NotNull
    public String getDisplayName() {
        if ("File Reference" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/references/FileReferenceInjector", "getDisplayName"));
        }
        return "File Reference";
    }

    @NotNull
    public PsiReference[] getReferences(@NotNull PsiElement element, @NotNull ProcessingContext context, @NotNull TextRange range) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/intelliLang/references/FileReferenceInjector", "getReferences"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/intellij/plugins/intelliLang/references/FileReferenceInjector", "getReferences"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/intellij/plugins/intelliLang/references/FileReferenceInjector", "getReferences"));
        }
        String text = range.substring(element.getText());
        FileReference[] fileReferenceArray = new FileReferenceSet(text, element, range.getStartOffset(), null, true){

            protected boolean isSoft() {
                return true;
            }
        }.getAllReferences();
        if (fileReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/references/FileReferenceInjector", "getReferences"));
        }
        return fileReferenceArray;
    }
}

