/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.Nullable;

public class ThreadDumper {
    public static String dumpThreadsToString() {
        StringWriter writer = new StringWriter();
        ThreadDumper.dumpThreadsToFile(ManagementFactory.getThreadMXBean(), writer);
        return writer.toString();
    }

    @Nullable
    static StackTraceElement[] dumpThreadsToFile(ThreadMXBean threadMXBean, Writer f) {
        StackTraceElement[] edtStack = null;
        boolean dumpSuccessful = false;
        try {
            ThreadInfo[] threads;
            for (ThreadInfo info : threads = ThreadDumper.sort(threadMXBean.dumpAllThreads(false, false))) {
                if (info == null) continue;
                if (info.getThreadName().equals("AWT-EventQueue-1")) {
                    edtStack = info.getStackTrace();
                }
                ThreadDumper.dumpThreadInfo(info, f);
            }
            dumpSuccessful = true;
        }
        catch (Exception threads) {
            // empty catch block
        }
        if (!dumpSuccessful) {
            ThreadInfo[] threadInfo;
            long[] threadIds = threadMXBean.getAllThreadIds();
            for (ThreadInfo info : threadInfo = ThreadDumper.sort(threadMXBean.getThreadInfo(threadIds, Integer.MAX_VALUE))) {
                if (info == null) continue;
                if (info.getThreadName().equals("AWT-EventQueue-1")) {
                    edtStack = info.getStackTrace();
                }
                ThreadDumper.dumpThreadInfo(info, f);
            }
        }
        return edtStack;
    }

    private static ThreadInfo[] sort(ThreadInfo[] threads) {
        Arrays.sort(threads, new Comparator<ThreadInfo>(){

            @Override
            public int compare(ThreadInfo o1, ThreadInfo o2) {
                boolean r2;
                String t1 = o1.getThreadName();
                String t2 = o2.getThreadName();
                if (t1.startsWith("AWT-EventQueue")) {
                    return -1;
                }
                if (t2.startsWith("AWT-EventQueue")) {
                    return 1;
                }
                boolean r1 = o1.getThreadState() == Thread.State.RUNNABLE;
                boolean bl = r2 = o2.getThreadState() == Thread.State.RUNNABLE;
                if (r1 && !r2) {
                    return -1;
                }
                if (r2 && !r1) {
                    return 1;
                }
                return 0;
            }
        });
        return threads;
    }

    private static void dumpThreadInfo(ThreadInfo info, Writer f) {
        ThreadDumper.dumpCallStack(info, f, info.getStackTrace());
    }

    private static void dumpCallStack(ThreadInfo info, Writer f, StackTraceElement[] stackTraceElements) {
        try {
            StringBuilder sb = new StringBuilder("\"").append(info.getThreadName()).append("\"");
            sb.append(" prio=0 tid=0x0 nid=0x0 ").append(ThreadDumper.getReadableState(info.getThreadState())).append("\n");
            sb.append("     java.lang.Thread.State: ").append((Object)info.getThreadState()).append("\n");
            if (info.getLockName() != null) {
                sb.append(" on ").append(info.getLockName());
            }
            if (info.getLockOwnerName() != null) {
                sb.append(" owned by \"").append(info.getLockOwnerName()).append("\" Id=").append(info.getLockOwnerId());
            }
            if (info.isSuspended()) {
                sb.append(" (suspended)");
            }
            if (info.isInNative()) {
                sb.append(" (in native)");
            }
            f.write(sb + "\n");
            for (StackTraceElement element : stackTraceElements) {
                f.write("\tat " + element.toString() + "\n");
            }
            f.write("\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getReadableState(Thread.State state) {
        switch (state) {
            case BLOCKED: {
                return "blocked";
            }
            case TIMED_WAITING: 
            case WAITING: {
                return "waiting on condition";
            }
            case RUNNABLE: {
                return "runnable";
            }
            case NEW: {
                return "new";
            }
            case TERMINATED: {
                return "terminated";
            }
        }
        return null;
    }
}

