/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class LightElement
extends PsiElementBase {
    protected final PsiManager myManager;
    private final Language myLanguage;
    private volatile PsiElement myNavigationElement;

    protected LightElement(@NotNull PsiManager manager, @NotNull Language language) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/light/LightElement", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/impl/light/LightElement", "<init>"));
        }
        this.myNavigationElement = this;
        this.myManager = manager;
        this.myLanguage = language;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.myLanguage;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightElement", "getLanguage"));
        }
        return language;
    }

    @Override
    public PsiManager getManager() {
        return this.myManager;
    }

    @Override
    public PsiElement getParent() {
        return null;
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightElement", "getChildren"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    public PsiFile getContainingFile() {
        return null;
    }

    @Override
    public TextRange getTextRange() {
        return null;
    }

    @Override
    public int getStartOffsetInParent() {
        return -1;
    }

    @Override
    public final int getTextLength() {
        String text = this.getText();
        return text != null ? text.length() : 0;
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        char[] cArray = this.getText().toCharArray();
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightElement", "textToCharArray"));
        }
        return cArray;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/light/LightElement", "textMatches"));
        }
        return this.getText().equals(text.toString());
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/light/LightElement", "textMatches"));
        }
        return this.getText().equals(element.getText());
    }

    @Override
    public PsiElement findElementAt(int offset) {
        return null;
    }

    @Override
    public int getTextOffset() {
        return -1;
    }

    @Override
    public boolean isValid() {
        PsiElement navElement = this.getNavigationElement();
        if (navElement != this) {
            return navElement.isValid();
        }
        return true;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isPhysical() {
        return false;
    }

    @Override
    public abstract String toString();

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/light/LightElement", "checkAdd"));
        }
        throw new IncorrectOperationException(this.getClass().getName());
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/light/LightElement", "add"));
        }
        throw new IncorrectOperationException(this.getClass().getName());
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor2) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/light/LightElement", "addBefore"));
        }
        throw new IncorrectOperationException(this.getClass().getName());
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor2) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/light/LightElement", "addAfter"));
        }
        throw new IncorrectOperationException(this.getClass().getName());
    }

    @Override
    public void delete() throws IncorrectOperationException {
        throw new IncorrectOperationException(this.getClass().getName());
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        throw new IncorrectOperationException(this.getClass().getName());
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/psi/impl/light/LightElement", "replace"));
        }
        throw new IncorrectOperationException(this.getClass().getName());
    }

    @Override
    public ASTNode getNode() {
        return null;
    }

    @Override
    public String getText() {
        return null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/light/LightElement", "accept"));
        }
    }

    @Override
    public PsiElement copy() {
        return null;
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement2 = this.myNavigationElement;
        if (psiElement2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightElement", "getNavigationElement"));
        }
        return psiElement2;
    }

    public void setNavigationElement(@NotNull PsiElement navigationElement) {
        if (navigationElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationElement", "com/intellij/psi/impl/light/LightElement", "setNavigationElement"));
        }
        PsiElement nnElement = navigationElement.getNavigationElement();
        if (nnElement != navigationElement && nnElement != null) {
            navigationElement = nnElement;
        }
        this.myNavigationElement = navigationElement;
    }

    @Override
    public PsiElement getPrevSibling() {
        return null;
    }

    @Override
    public PsiElement getNextSibling() {
        return null;
    }
}

