/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

public class BitUtil {
    public static boolean isSet(byte value2, byte mask) {
        BitUtil.assertOneBitMask(mask);
        return (value2 & mask) == mask;
    }

    public static boolean isSet(int value2, int mask) {
        BitUtil.assertOneBitMask(mask);
        return (value2 & mask) == mask;
    }

    private static void assertOneBitMask(long mask) {
        assert ((mask & mask - 1L) == 0L) : "Mask must have only one bit set, but got: " + Long.toBinaryString(mask);
    }

    public static boolean notSet(int value2, int mask) {
        return (value2 & mask) != mask;
    }

    public static byte set(byte value2, byte mask, boolean setBit) {
        BitUtil.assertOneBitMask(mask);
        return (byte)(setBit ? value2 | mask : value2 & ~mask);
    }

    public static int set(int value2, int mask, boolean setBit) {
        BitUtil.assertOneBitMask(mask);
        return setBit ? value2 | mask : value2 & ~mask;
    }
}

