/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ConcurrentRefValueIntObjectHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;

class ConcurrentWeakValueIntObjectHashMap<V>
extends ConcurrentRefValueIntObjectHashMap<V> {
    ConcurrentWeakValueIntObjectHashMap() {
    }

    @Override
    protected ConcurrentRefValueIntObjectHashMap.IntReference<V> createReference(int key, @NotNull V value2, ReferenceQueue<V> queue) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentWeakValueIntObjectHashMap", "createReference"));
        }
        return new MyRef<V>(key, value2, queue);
    }

    private static class MyRef<V>
    extends WeakReference<V>
    implements ConcurrentRefValueIntObjectHashMap.IntReference<V> {
        private final int hash;
        private final int key;

        MyRef(int key, @NotNull V referent, ReferenceQueue<V> queue) {
            if (referent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referent", "com/intellij/util/containers/ConcurrentWeakValueIntObjectHashMap$MyRef", "<init>"));
            }
            super(referent, queue);
            this.key = key;
            this.hash = referent.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            Object v = this.get();
            if (!(obj instanceof MyRef)) {
                return false;
            }
            MyRef other = (MyRef)obj;
            return other.hash == this.hash && this.key == other.getKey() && Comparing.equal(v, other.get());
        }

        @Override
        public int getKey() {
            return this.key;
        }
    }
}

