/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FactoryMap<K, V>
implements Map<K, V> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard("factoryMap");
    protected Map<K, V> myMap;

    protected Map<K, V> createMap() {
        return new THashMap();
    }

    @Nullable
    protected abstract V create(K var1);

    private Map<K, V> getMap() {
        if (this.myMap == null) {
            this.myMap = this.createMap();
        }
        return this.myMap;
    }

    @Override
    public V get(Object key) {
        Map<Object, Object> map2 = this.getMap();
        V value2 = map2.get(FactoryMap.getKey(key));
        if (value2 == null) {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            value2 = this.create(key);
            if (stamp.mayCacheNow()) {
                map2.put(FactoryMap.getKey(key), value2 == null ? ObjectUtils.NULL : value2);
            }
        }
        return value2 == ObjectUtils.NULL ? null : (V)value2;
    }

    private static <K> K getKey(K key) {
        return (K)(key == null ? ObjectUtils.NULL : key);
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.myMap != null && this.myMap.containsKey(FactoryMap.getKey(key));
    }

    @Override
    public V put(K key, V value2) {
        Object v = this.getMap().put(FactoryMap.getKey(key), value2 == null ? ObjectUtils.NULL : value2);
        return (V)(v == ObjectUtils.NULL ? null : v);
    }

    @Override
    public V remove(Object key) {
        if (this.myMap == null) {
            return null;
        }
        V v = this.myMap.remove(key);
        return v == ObjectUtils.NULL ? null : (V)v;
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        if (this.myMap == null) {
            Set set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FactoryMap", "keySet"));
            }
            return set;
        }
        Set<K> ts = this.myMap.keySet();
        if (ts.contains(ObjectUtils.NULL)) {
            HashSet<K> hashSet = new HashSet<K>(ts);
            hashSet.remove(ObjectUtils.NULL);
            hashSet.add(null);
            HashSet<K> hashSet2 = hashSet;
            if (hashSet2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FactoryMap", "keySet"));
            }
            return hashSet2;
        }
        Set<K> set = ts;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FactoryMap", "keySet"));
        }
        return set;
    }

    public Collection<V> notNullValues() {
        if (this.myMap == null) {
            return Collections.emptyList();
        }
        ArrayList<V> values = ContainerUtil.newArrayList(this.myMap.values());
        Iterator iterator2 = values.iterator();
        while (iterator2.hasNext()) {
            if (iterator2.next() != ObjectUtils.NULL) continue;
            iterator2.remove();
        }
        return values;
    }

    public boolean removeValue(Object value2) {
        if (this.myMap == null) {
            return false;
        }
        Object t = ObjectUtils.notNull(value2, ObjectUtils.NULL);
        return this.myMap.values().remove(t);
    }

    @Override
    public void clear() {
        if (this.myMap != null) {
            this.myMap.clear();
        }
    }

    @Override
    public int size() {
        if (this.myMap == null) {
            return 0;
        }
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap == null || this.myMap.isEmpty();
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.myMap != null && this.myMap.containsValue(value2);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        if (m == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m", "com/intellij/util/containers/FactoryMap", "putAll"));
        }
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @NotNull
    public Collection<V> values() {
        if (this.myMap == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FactoryMap", "values"));
            }
            return list;
        }
        Collection<V> collection = this.myMap.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FactoryMap", "values"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.myMap == null) {
            Set<Map.Entry<K, V>> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FactoryMap", "entrySet"));
            }
            return set;
        }
        Set<Map.Entry<K, V>> set = this.myMap.entrySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FactoryMap", "entrySet"));
        }
        return set;
    }
}

