/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.SLRUMap;
import com.intellij.util.containers.hash.EqualityPolicy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SLRUCache<K, V>
extends SLRUMap<K, V> {
    protected SLRUCache(int protectedQueueSize, int probationalQueueSize) {
        super(protectedQueueSize, probationalQueueSize);
    }

    protected SLRUCache(int protectedQueueSize, int probationalQueueSize, EqualityPolicy<K> hashingStrategy) {
        super(protectedQueueSize, probationalQueueSize, hashingStrategy);
    }

    @NotNull
    public abstract V createValue(K var1);

    @Override
    @NotNull
    public V get(K key) {
        Object value2 = super.get(key);
        if (value2 != null) {
            Object v = value2;
            if (v == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/SLRUCache", "get"));
            }
            return v;
        }
        value2 = this.createValue(key);
        this.put(key, value2);
        Object v = value2;
        if (v == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/SLRUCache", "get"));
        }
        return v;
    }

    @Nullable
    public V getIfCached(K key) {
        return super.get(key);
    }
}

