/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.FromNativeContext;
import com.sun.jna.NativeMapped;

public abstract class IntegerType
extends Number
implements NativeMapped {
    private int size;
    private Number number;
    private boolean unsigned;
    private long value;

    public IntegerType(int size, long value2) {
        this(size, value2, false);
    }

    public IntegerType(int size, long value2, boolean unsigned) {
        this.size = size;
        this.unsigned = unsigned;
        this.setValue(value2);
    }

    public void setValue(long value2) {
        long truncated = value2;
        this.value = value2;
        switch (this.size) {
            case 1: {
                if (this.unsigned) {
                    this.value = value2 & 0xFFL;
                }
                truncated = (byte)value2;
                this.number = new Byte((byte)value2);
                break;
            }
            case 2: {
                if (this.unsigned) {
                    this.value = value2 & 0xFFFFL;
                }
                truncated = (short)value2;
                this.number = new Short((short)value2);
                break;
            }
            case 4: {
                if (this.unsigned) {
                    this.value = value2 & 0xFFFFFFFFL;
                }
                truncated = (int)value2;
                this.number = new Integer((int)value2);
                break;
            }
            case 8: {
                this.number = new Long(value2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported size: " + this.size);
            }
        }
        if (this.size < 8) {
            long mask = (1L << this.size * 8) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
            if (value2 < 0L && truncated != value2 || value2 >= 0L && (mask & value2) != 0L) {
                throw new IllegalArgumentException("Argument value 0x" + Long.toHexString(value2) + " exceeds native capacity (" + this.size + " bytes) mask=0x" + Long.toHexString(mask));
            }
        }
    }

    @Override
    public Object toNative() {
        return this.number;
    }

    @Override
    public Object fromNative(Object nativeValue, FromNativeContext context) {
        long value2 = nativeValue == null ? 0L : ((Number)nativeValue).longValue();
        try {
            IntegerType number = (IntegerType)this.getClass().newInstance();
            number.setValue(value2);
            return number;
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Can't instantiate " + this.getClass());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Not allowed to instantiate " + this.getClass());
        }
    }

    @Override
    public Class nativeType() {
        return this.number.getClass();
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.number.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.number.doubleValue();
    }

    public boolean equals(Object rhs) {
        return rhs instanceof IntegerType && this.number.equals(((IntegerType)rhs).number);
    }

    public String toString() {
        return this.number.toString();
    }

    public int hashCode() {
        return this.number.hashCode();
    }
}

