/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.CallbackReference;
import com.sun.jna.FromNativeContext;
import com.sun.jna.Function;
import com.sun.jna.Native;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeContext;
import com.sun.jna.WString;
import java.lang.reflect.Array;
import java.nio.Buffer;
import java.util.ArrayList;

public class Pointer {
    public static final int SIZE = Native.POINTER_SIZE;
    public static final Pointer NULL;
    protected long peer;

    Pointer() {
    }

    public Pointer(long peer) {
        this.peer = peer;
    }

    public Pointer share(long offset) {
        return this.share(offset, 0L);
    }

    public Pointer share(long offset, long sz) {
        if (offset == 0L) {
            return this;
        }
        return new Pointer(this.peer + offset);
    }

    public void clear(long size) {
        this.setMemory(0L, size, (byte)0);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        return o instanceof Pointer && ((Pointer)o).peer == this.peer;
    }

    public int hashCode() {
        return (int)((this.peer >>> 32) + (this.peer & 0xFFFFFFFFFFFFFFFFL));
    }

    public void read(long offset, byte[] buf, int index2, int length) {
        Native.read(this.peer + offset, buf, index2, length);
    }

    public void read(long offset, short[] buf, int index2, int length) {
        Native.read(this.peer + offset, buf, index2, length);
    }

    public void read(long offset, char[] buf, int index2, int length) {
        Native.read(this.peer + offset, buf, index2, length);
    }

    public void read(long offset, int[] buf, int index2, int length) {
        Native.read(this.peer + offset, buf, index2, length);
    }

    public void read(long offset, long[] buf, int index2, int length) {
        Native.read(this.peer + offset, buf, index2, length);
    }

    public void read(long offset, float[] buf, int index2, int length) {
        Native.read(this.peer + offset, buf, index2, length);
    }

    public void read(long offset, double[] buf, int index2, int length) {
        Native.read(this.peer + offset, buf, index2, length);
    }

    public void read(long offset, Pointer[] buf, int index2, int length) {
        for (int i = 0; i < length; ++i) {
            Pointer p = this.getPointer(offset + (long)(i * SIZE));
            Pointer oldp = buf[i + index2];
            if (oldp != null && p != null && p.peer == oldp.peer) continue;
            buf[i + index2] = p;
        }
    }

    public void write(long offset, byte[] buf, int index2, int length) {
        Native.write(this.peer + offset, buf, index2, length);
    }

    public void write(long offset, short[] buf, int index2, int length) {
        Native.write(this.peer + offset, buf, index2, length);
    }

    public void write(long offset, char[] buf, int index2, int length) {
        Native.write(this.peer + offset, buf, index2, length);
    }

    public void write(long offset, int[] buf, int index2, int length) {
        Native.write(this.peer + offset, buf, index2, length);
    }

    public void write(long offset, long[] buf, int index2, int length) {
        Native.write(this.peer + offset, buf, index2, length);
    }

    public void write(long offset, float[] buf, int index2, int length) {
        Native.write(this.peer + offset, buf, index2, length);
    }

    public void write(long offset, double[] buf, int index2, int length) {
        Native.write(this.peer + offset, buf, index2, length);
    }

    public void write(long bOff, Pointer[] buf, int index2, int length) {
        for (int i = 0; i < length; ++i) {
            this.setPointer(bOff + (long)(i * SIZE), buf[index2 + i]);
        }
    }

    Object getValue(long offset, Class type2, Object currentValue) {
        Object result2 = null;
        if (Structure.class.isAssignableFrom(type2)) {
            Structure s = (Structure)currentValue;
            if (Structure.ByReference.class.isAssignableFrom(type2)) {
                s = Structure.updateStructureByReference(type2, s, this.getPointer(offset));
            } else {
                s.useMemory(this, (int)offset, true);
                s.read();
            }
            result2 = s;
        } else if (type2 == Boolean.TYPE || type2 == Boolean.class) {
            result2 = Function.valueOf(this.getInt(offset) != 0);
        } else if (type2 == Byte.TYPE || type2 == Byte.class) {
            result2 = new Byte(this.getByte(offset));
        } else if (type2 == Short.TYPE || type2 == Short.class) {
            result2 = new Short(this.getShort(offset));
        } else if (type2 == Character.TYPE || type2 == Character.class) {
            result2 = new Character(this.getChar(offset));
        } else if (type2 == Integer.TYPE || type2 == Integer.class) {
            result2 = new Integer(this.getInt(offset));
        } else if (type2 == Long.TYPE || type2 == Long.class) {
            result2 = new Long(this.getLong(offset));
        } else if (type2 == Float.TYPE || type2 == Float.class) {
            result2 = new Float(this.getFloat(offset));
        } else if (type2 == Double.TYPE || type2 == Double.class) {
            result2 = new Double(this.getDouble(offset));
        } else if (Pointer.class.isAssignableFrom(type2)) {
            Pointer p = this.getPointer(offset);
            if (p != null) {
                Pointer oldp;
                Pointer pointer = oldp = currentValue instanceof Pointer ? (Pointer)currentValue : null;
                result2 = oldp == null || p.peer != oldp.peer ? p : oldp;
            }
        } else if (type2 == String.class) {
            Pointer p = this.getPointer(offset);
            result2 = p != null ? p.getString(0L) : null;
        } else if (type2 == WString.class) {
            Pointer p = this.getPointer(offset);
            result2 = p != null ? new WString(p.getWideString(0L)) : null;
        } else if (Callback.class.isAssignableFrom(type2)) {
            Pointer fp = this.getPointer(offset);
            if (fp == null) {
                result2 = null;
            } else {
                Callback cb = (Callback)currentValue;
                Pointer oldfp = CallbackReference.getFunctionPointer(cb);
                if (!fp.equals(oldfp)) {
                    cb = CallbackReference.getCallback(type2, fp);
                }
                result2 = cb;
            }
        } else if (Platform.HAS_BUFFERS && Buffer.class.isAssignableFrom(type2)) {
            Pointer bp = this.getPointer(offset);
            if (bp == null) {
                result2 = null;
            } else {
                Pointer oldbp;
                Pointer pointer = oldbp = currentValue == null ? null : Native.getDirectBufferPointer((Buffer)currentValue);
                if (oldbp == null || !oldbp.equals(bp)) {
                    throw new IllegalStateException("Can't autogenerate a direct buffer on memory read");
                }
                result2 = currentValue;
            }
        } else if (NativeMapped.class.isAssignableFrom(type2)) {
            NativeMapped nm = (NativeMapped)currentValue;
            if (nm != null) {
                Object value2 = this.getValue(offset, nm.nativeType(), null);
                result2 = nm.fromNative(value2, new FromNativeContext(type2));
                if (nm.equals(result2)) {
                    result2 = nm;
                }
            } else {
                NativeMappedConverter tc = NativeMappedConverter.getInstance(type2);
                Object value3 = this.getValue(offset, tc.nativeType(), null);
                result2 = tc.fromNative(value3, new FromNativeContext(type2));
            }
        } else if (type2.isArray()) {
            result2 = currentValue;
            if (result2 == null) {
                throw new IllegalStateException("Need an initialized array");
            }
            this.readArray(offset, result2, type2.getComponentType());
        } else {
            throw new IllegalArgumentException("Reading \"" + type2 + "\" from memory is not supported");
        }
        return result2;
    }

    private void readArray(long offset, Object o, Class cls) {
        int length = 0;
        length = Array.getLength(o);
        Object result2 = o;
        if (cls == Byte.TYPE) {
            this.read(offset, (byte[])result2, 0, length);
        } else if (cls == Short.TYPE) {
            this.read(offset, (short[])result2, 0, length);
        } else if (cls == Character.TYPE) {
            this.read(offset, (char[])result2, 0, length);
        } else if (cls == Integer.TYPE) {
            this.read(offset, (int[])result2, 0, length);
        } else if (cls == Long.TYPE) {
            this.read(offset, (long[])result2, 0, length);
        } else if (cls == Float.TYPE) {
            this.read(offset, (float[])result2, 0, length);
        } else if (cls == Double.TYPE) {
            this.read(offset, (double[])result2, 0, length);
        } else if (Pointer.class.isAssignableFrom(cls)) {
            this.read(offset, (Pointer[])result2, 0, length);
        } else if (Structure.class.isAssignableFrom(cls)) {
            Structure[] sarray = (Structure[])result2;
            if (Structure.ByReference.class.isAssignableFrom(cls)) {
                Pointer[] parray = this.getPointerArray(offset, sarray.length);
                for (int i = 0; i < sarray.length; ++i) {
                    sarray[i] = Structure.updateStructureByReference(cls, sarray[i], parray[i]);
                }
            } else {
                Structure first = sarray[0];
                if (first == null) {
                    first = Structure.newInstance(cls, this.share(offset));
                    first.conditionalAutoRead();
                    sarray[0] = first;
                } else {
                    first.useMemory(this, (int)offset, true);
                    first.read();
                }
                Structure[] tmp = first.toArray(sarray.length);
                for (int i = 1; i < sarray.length; ++i) {
                    if (sarray[i] == null) {
                        sarray[i] = tmp[i];
                        continue;
                    }
                    sarray[i].useMemory(this, (int)(offset + (long)(i * sarray[i].size())), true);
                    sarray[i].read();
                }
            }
        } else if (NativeMapped.class.isAssignableFrom(cls)) {
            NativeMapped[] array = (NativeMapped[])result2;
            NativeMappedConverter tc = NativeMappedConverter.getInstance(cls);
            int size = Native.getNativeSize(result2.getClass(), result2) / array.length;
            for (int i = 0; i < array.length; ++i) {
                Object value2 = this.getValue(offset + (long)(size * i), tc.nativeType(), array[i]);
                array[i] = (NativeMapped)tc.fromNative(value2, new FromNativeContext(cls));
            }
        } else {
            throw new IllegalArgumentException("Reading array of " + cls + " from memory not supported");
        }
    }

    public byte getByte(long offset) {
        return Native.getByte(this.peer + offset);
    }

    public char getChar(long offset) {
        return Native.getChar(this.peer + offset);
    }

    public short getShort(long offset) {
        return Native.getShort(this.peer + offset);
    }

    public int getInt(long offset) {
        return Native.getInt(this.peer + offset);
    }

    public long getLong(long offset) {
        return Native.getLong(this.peer + offset);
    }

    public float getFloat(long offset) {
        return Native.getFloat(this.peer + offset);
    }

    public double getDouble(long offset) {
        return Native.getDouble(this.peer + offset);
    }

    public Pointer getPointer(long offset) {
        return Native.getPointer(this.peer + offset);
    }

    public String getWideString(long offset) {
        return Native.getWideString(this.peer + offset);
    }

    public String getString(long offset) {
        return this.getString(offset, Native.getDefaultStringEncoding());
    }

    public String getString(long offset, String encoding) {
        return Native.getString(this.peer + offset, encoding);
    }

    public byte[] getByteArray(long offset, int arraySize) {
        byte[] buf = new byte[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public Pointer[] getPointerArray(long offset) {
        ArrayList<Pointer> array = new ArrayList<Pointer>();
        int addOffset = 0;
        Pointer p = this.getPointer(offset);
        while (p != null) {
            array.add(p);
            p = this.getPointer(offset + (long)(addOffset += SIZE));
        }
        return array.toArray(new Pointer[array.size()]);
    }

    public Pointer[] getPointerArray(long offset, int arraySize) {
        Pointer[] buf = new Pointer[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public String[] getStringArray(long offset, String encoding) {
        return this.getStringArray(offset, -1, encoding);
    }

    public String[] getWideStringArray(long offset) {
        return this.getWideStringArray(offset, -1);
    }

    public String[] getWideStringArray(long offset, int length) {
        return this.getStringArray(offset, -1, "--WIDE-STRING--");
    }

    public String[] getStringArray(long offset, int length, String encoding) {
        ArrayList<String> strings = new ArrayList<String>();
        int addOffset = 0;
        if (length != -1) {
            Pointer p = this.getPointer(offset + (long)addOffset);
            int count = 0;
            while (count++ < length) {
                String s = p == null ? null : (encoding == "--WIDE-STRING--" ? p.getWideString(0L) : p.getString(0L, encoding));
                strings.add(s);
                if (count >= length) continue;
                p = this.getPointer(offset + (long)(addOffset += SIZE));
            }
        } else {
            Pointer p;
            while ((p = this.getPointer(offset + (long)addOffset)) != null) {
                String s = p == null ? null : (encoding == "--WIDE-STRING--" ? p.getWideString(0L) : p.getString(0L, encoding));
                strings.add(s);
                addOffset += SIZE;
            }
        }
        return strings.toArray(new String[strings.size()]);
    }

    void setValue(long offset, Object value2, Class type2) {
        if (type2 == Boolean.TYPE || type2 == Boolean.class) {
            this.setInt(offset, Boolean.TRUE.equals(value2) ? -1 : 0);
        } else if (type2 == Byte.TYPE || type2 == Byte.class) {
            this.setByte(offset, value2 == null ? (byte)0 : (Byte)value2);
        } else if (type2 == Short.TYPE || type2 == Short.class) {
            this.setShort(offset, value2 == null ? (short)0 : (Short)value2);
        } else if (type2 == Character.TYPE || type2 == Character.class) {
            this.setChar(offset, value2 == null ? (char)'\u0000' : ((Character)value2).charValue());
        } else if (type2 == Integer.TYPE || type2 == Integer.class) {
            this.setInt(offset, value2 == null ? 0 : (Integer)value2);
        } else if (type2 == Long.TYPE || type2 == Long.class) {
            this.setLong(offset, value2 == null ? 0L : (Long)value2);
        } else if (type2 == Float.TYPE || type2 == Float.class) {
            this.setFloat(offset, value2 == null ? 0.0f : ((Float)value2).floatValue());
        } else if (type2 == Double.TYPE || type2 == Double.class) {
            this.setDouble(offset, value2 == null ? 0.0 : (Double)value2);
        } else if (type2 == Pointer.class) {
            this.setPointer(offset, (Pointer)value2);
        } else if (type2 == String.class) {
            this.setPointer(offset, (Pointer)value2);
        } else if (type2 == WString.class) {
            this.setPointer(offset, (Pointer)value2);
        } else if (Structure.class.isAssignableFrom(type2)) {
            Structure s = (Structure)value2;
            if (Structure.ByReference.class.isAssignableFrom(type2)) {
                this.setPointer(offset, s == null ? null : s.getPointer());
                if (s != null) {
                    s.autoWrite();
                }
            } else {
                s.useMemory(this, (int)offset, true);
                s.write();
            }
        } else if (Callback.class.isAssignableFrom(type2)) {
            this.setPointer(offset, CallbackReference.getFunctionPointer((Callback)value2));
        } else if (Platform.HAS_BUFFERS && Buffer.class.isAssignableFrom(type2)) {
            Pointer p = value2 == null ? null : Native.getDirectBufferPointer((Buffer)value2);
            this.setPointer(offset, p);
        } else if (NativeMapped.class.isAssignableFrom(type2)) {
            NativeMappedConverter tc = NativeMappedConverter.getInstance(type2);
            Class nativeType = tc.nativeType();
            this.setValue(offset, tc.toNative(value2, new ToNativeContext()), nativeType);
        } else if (type2.isArray()) {
            this.writeArray(offset, value2, type2.getComponentType());
        } else {
            throw new IllegalArgumentException("Writing " + type2 + " to memory is not supported");
        }
    }

    private void writeArray(long offset, Object value2, Class cls) {
        if (cls == Byte.TYPE) {
            byte[] buf = (byte[])value2;
            this.write(offset, buf, 0, buf.length);
        } else if (cls == Short.TYPE) {
            short[] buf = (short[])value2;
            this.write(offset, buf, 0, buf.length);
        } else if (cls == Character.TYPE) {
            char[] buf = (char[])value2;
            this.write(offset, buf, 0, buf.length);
        } else if (cls == Integer.TYPE) {
            int[] buf = (int[])value2;
            this.write(offset, buf, 0, buf.length);
        } else if (cls == Long.TYPE) {
            long[] buf = (long[])value2;
            this.write(offset, buf, 0, buf.length);
        } else if (cls == Float.TYPE) {
            float[] buf = (float[])value2;
            this.write(offset, buf, 0, buf.length);
        } else if (cls == Double.TYPE) {
            double[] buf = (double[])value2;
            this.write(offset, buf, 0, buf.length);
        } else if (Pointer.class.isAssignableFrom(cls)) {
            Pointer[] buf = (Pointer[])value2;
            this.write(offset, buf, 0, buf.length);
        } else if (Structure.class.isAssignableFrom(cls)) {
            Structure[] sbuf = (Structure[])value2;
            if (Structure.ByReference.class.isAssignableFrom(cls)) {
                Pointer[] buf = new Pointer[sbuf.length];
                for (int i = 0; i < sbuf.length; ++i) {
                    if (sbuf[i] == null) {
                        buf[i] = null;
                        continue;
                    }
                    buf[i] = sbuf[i].getPointer();
                    sbuf[i].write();
                }
                this.write(offset, buf, 0, buf.length);
            } else {
                Structure first = sbuf[0];
                if (first == null) {
                    sbuf[0] = first = Structure.newInstance(cls, this.share(offset));
                } else {
                    first.useMemory(this, (int)offset, true);
                }
                first.write();
                Structure[] tmp = first.toArray(sbuf.length);
                for (int i = 1; i < sbuf.length; ++i) {
                    if (sbuf[i] == null) {
                        sbuf[i] = tmp[i];
                    } else {
                        sbuf[i].useMemory(this, (int)(offset + (long)(i * sbuf[i].size())), true);
                    }
                    sbuf[i].write();
                }
            }
        } else if (NativeMapped.class.isAssignableFrom(cls)) {
            NativeMapped[] buf = (NativeMapped[])value2;
            NativeMappedConverter tc = NativeMappedConverter.getInstance(cls);
            Class nativeType = tc.nativeType();
            int size = Native.getNativeSize(value2.getClass(), value2) / buf.length;
            for (int i = 0; i < buf.length; ++i) {
                Object element = tc.toNative(buf[i], new ToNativeContext());
                this.setValue(offset + (long)(i * size), element, nativeType);
            }
        } else {
            throw new IllegalArgumentException("Writing array of " + cls + " to memory not supported");
        }
    }

    public void setMemory(long offset, long length, byte value2) {
        Native.setMemory(this.peer + offset, length, value2);
    }

    public void setByte(long offset, byte value2) {
        Native.setByte(this.peer + offset, value2);
    }

    public void setShort(long offset, short value2) {
        Native.setShort(this.peer + offset, value2);
    }

    public void setChar(long offset, char value2) {
        Native.setChar(this.peer + offset, value2);
    }

    public void setInt(long offset, int value2) {
        Native.setInt(this.peer + offset, value2);
    }

    public void setLong(long offset, long value2) {
        Native.setLong(this.peer + offset, value2);
    }

    public void setFloat(long offset, float value2) {
        Native.setFloat(this.peer + offset, value2);
    }

    public void setDouble(long offset, double value2) {
        Native.setDouble(this.peer + offset, value2);
    }

    public void setPointer(long offset, Pointer value2) {
        Native.setPointer(this.peer + offset, value2 != null ? value2.peer : 0L);
    }

    public void setWideString(long offset, String value2) {
        Native.setWideString(this.peer + offset, value2);
    }

    public String toString() {
        return "native@0x" + Long.toHexString(this.peer);
    }

    static {
        if (SIZE == 0) {
            throw new Error("Native library not initialized");
        }
        NULL = null;
    }
}

