/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.PackagePartCodegen;
import org.jetbrains.kotlin.codegen.ScriptCodegen;
import org.jetbrains.kotlin.codegen.context.PackageContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.load.kotlin.PackageParts;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.org.objectweb.asm.Type;

public class PackageCodegen {
    private final GenerationState state;
    private final Collection<KtFile> files;
    private final PackageFragmentDescriptor packageFragment;
    private final PackageParts packageParts;

    public PackageCodegen(@NotNull GenerationState state, @NotNull Collection<KtFile> files, @NotNull FqName packageFqName) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/PackageCodegen", "<init>"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/codegen/PackageCodegen", "<init>"));
        }
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/codegen/PackageCodegen", "<init>"));
        }
        this.state = state;
        this.files = files;
        this.packageFragment = this.getOnlyPackageFragment(packageFqName);
        this.packageParts = new PackageParts(packageFqName.asString());
    }

    public void generate(@NotNull CompilationErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "org/jetbrains/kotlin/codegen/PackageCodegen", "generate"));
        }
        for (KtFile file : this.files) {
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            try {
                this.generateFile(file);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                VirtualFile vFile = file.getVirtualFile();
                errorHandler.reportException(e, vFile == null ? "no file" : vFile.getUrl());
                DiagnosticUtils.throwIfRunningOnServer(e);
                if (!ApplicationManager.getApplication().isInternal()) continue;
                e.printStackTrace();
            }
        }
    }

    @Nullable
    private ClassBuilder generateFile(@NotNull KtFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/codegen/PackageCodegen", "generateFile"));
        }
        JvmFileClassInfo fileClassInfo = this.state.getFileClassesProvider().getFileClassInfo(file);
        if (fileClassInfo.getWithJvmMultifileClass()) {
            return null;
        }
        Type fileClassType = AsmUtil.asmTypeByFqNameWithoutInnerClasses(fileClassInfo.getFileClassFqName());
        PackageContext packagePartContext = this.state.getRootContext().intoPackagePart(this.packageFragment, fileClassType, file);
        boolean generatePackagePart = false;
        for (KtDeclaration declaration : file.getDeclarations()) {
            if (declaration instanceof KtProperty || declaration instanceof KtNamedFunction) {
                generatePackagePart = true;
                continue;
            }
            if (declaration instanceof KtClassOrObject) {
                KtClassOrObject classOrObject = (KtClassOrObject)declaration;
                if (!this.state.getGenerateDeclaredClassFilter().shouldGenerateClass(classOrObject)) continue;
                this.generateClassOrObject(classOrObject, packagePartContext);
                continue;
            }
            if (!(declaration instanceof KtScript)) continue;
            KtScript script = (KtScript)declaration;
            if (!this.state.getGenerateDeclaredClassFilter().shouldGenerateScript(script)) continue;
            ScriptCodegen.createScriptCodegen(script, this.state, packagePartContext).generate();
        }
        if (!generatePackagePart || !this.state.getGenerateDeclaredClassFilter().shouldGeneratePackagePart(file)) {
            return null;
        }
        String name = fileClassType.getInternalName();
        this.packageParts.getParts().add(name.substring(name.lastIndexOf(47) + 1));
        ClassBuilder builder = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.PackagePart(file, this.packageFragment), fileClassType, file);
        new PackagePartCodegen(builder, file, fileClassType, packagePartContext, this.state).generate();
        return builder;
    }

    @Nullable
    private PackageFragmentDescriptor getOnlyPackageFragment(@NotNull FqName expectedPackageFqName) {
        if (expectedPackageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedPackageFqName", "org/jetbrains/kotlin/codegen/PackageCodegen", "getOnlyPackageFragment"));
        }
        SmartList<PackageFragmentDescriptor> fragments2 = new SmartList<PackageFragmentDescriptor>();
        for (KtFile file : this.files) {
            PackageFragmentDescriptor fragment = this.state.getBindingContext().get(BindingContext.FILE_TO_PACKAGE_FRAGMENT, file);
            assert (fragment != null) : "package fragment is null for " + file + "\n" + file.getText();
            assert (expectedPackageFqName.equals(fragment.getFqName())) : "expected package fq name: " + expectedPackageFqName + ", actual: " + fragment.getFqName();
            if (fragments2.contains(fragment)) continue;
            fragments2.add(fragment);
        }
        if (fragments2.size() > 1) {
            throw new IllegalStateException("More than one package fragment, files: " + this.files + " | fragments: " + fragments2);
        }
        if (fragments2.isEmpty()) {
            return null;
        }
        return (PackageFragmentDescriptor)fragments2.get(0);
    }

    public void generateClassOrObject(@NotNull KtClassOrObject classOrObject, @NotNull PackageContext packagePartContext) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/codegen/PackageCodegen", "generateClassOrObject"));
        }
        if (packagePartContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagePartContext", "org/jetbrains/kotlin/codegen/PackageCodegen", "generateClassOrObject"));
        }
        MemberCodegen.genClassOrObject(packagePartContext, classOrObject, this.state, null);
    }

    public PackageParts getPackageParts() {
        return this.packageParts;
    }

    public Collection<KtFile> getFiles() {
        return this.files;
    }

    public PackageFragmentDescriptor getPackageFragment() {
        return this.packageFragment;
    }
}

