/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ClassDescriptorBase;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.StaticScopeForKotlinClass;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorImpl;

public class ClassDescriptorImpl
extends ClassDescriptorBase {
    private final Modality modality;
    private final TypeConstructor typeConstructor;
    private final MemberScope staticScope;
    private MemberScope unsubstitutedMemberScope;
    private Set<ConstructorDescriptor> constructors;
    private ConstructorDescriptor primaryConstructor;

    public ClassDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Name name, @NotNull Modality modality, @NotNull Collection<KotlinType> supertypes2, @NotNull SourceElement source) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/descriptors/impl/ClassDescriptorImpl", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/descriptors/impl/ClassDescriptorImpl", "<init>"));
        }
        if (modality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modality", "org/jetbrains/kotlin/descriptors/impl/ClassDescriptorImpl", "<init>"));
        }
        if (supertypes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "org/jetbrains/kotlin/descriptors/impl/ClassDescriptorImpl", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/kotlin/descriptors/impl/ClassDescriptorImpl", "<init>"));
        }
        super(LockBasedStorageManager.NO_LOCKS, containingDeclaration, name, source);
        this.staticScope = new StaticScopeForKotlinClass(this);
        this.modality = modality;
        this.typeConstructor = TypeConstructorImpl.createForClass(this, Annotations.Companion.getEMPTY(), false, this.getName().asString(), Collections.emptyList(), supertypes2);
    }

    public final void initialize(@NotNull MemberScope unsubstitutedMemberScope, @NotNull Set<ConstructorDescriptor> constructors2, @Nullable ConstructorDescriptor primaryConstructor2) {
        if (unsubstitutedMemberScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unsubstitutedMemberScope", "org/jetbrains/kotlin/descriptors/impl/ClassDescriptorImpl", "initialize"));
        }
        if (constructors2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructors", "org/jetbrains/kotlin/descriptors/impl/ClassDescriptorImpl", "initialize"));
        }
        this.unsubstitutedMemberScope = unsubstitutedMemberScope;
        this.constructors = constructors2;
        this.primaryConstructor = primaryConstructor2;
    }

    public void setPrimaryConstructor(@NotNull ConstructorDescriptor primaryConstructor2) {
        if (primaryConstructor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryConstructor", "org/jetbrains/kotlin/descriptors/impl/ClassDescriptorImpl", "setPrimaryConstructor"));
        }
        this.primaryConstructor = primaryConstructor2;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        Annotations annotations2 = Annotations.Companion.getEMPTY();
        if (annotations2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/ClassDescriptorImpl", "getAnnotations"));
        }
        return annotations2;
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        TypeConstructor typeConstructor2 = this.typeConstructor;
        if (typeConstructor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/ClassDescriptorImpl", "getTypeConstructor"));
        }
        return typeConstructor2;
    }

    @Override
    @NotNull
    public Collection<ConstructorDescriptor> getConstructors() {
        Set<ConstructorDescriptor> set = this.constructors;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/ClassDescriptorImpl", "getConstructors"));
        }
        return set;
    }

    @Override
    @NotNull
    public MemberScope getUnsubstitutedMemberScope() {
        MemberScope memberScope2 = this.unsubstitutedMemberScope;
        if (memberScope2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/ClassDescriptorImpl", "getUnsubstitutedMemberScope"));
        }
        return memberScope2;
    }

    @Override
    @NotNull
    public MemberScope getStaticScope() {
        MemberScope memberScope2 = this.staticScope;
        if (memberScope2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/ClassDescriptorImpl", "getStaticScope"));
        }
        return memberScope2;
    }

    @Override
    @Nullable
    public ClassDescriptor getCompanionObjectDescriptor() {
        return null;
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        ClassKind classKind = ClassKind.CLASS;
        if (classKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/ClassDescriptorImpl", "getKind"));
        }
        return classKind;
    }

    @Override
    public boolean isCompanionObject() {
        return false;
    }

    @Override
    public ConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return this.primaryConstructor;
    }

    @Override
    @NotNull
    public Modality getModality() {
        Modality modality = this.modality;
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/ClassDescriptorImpl", "getModality"));
        }
        return modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = Visibilities.PUBLIC;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/ClassDescriptorImpl", "getVisibility"));
        }
        return visibility;
    }

    @Override
    public boolean isData() {
        return false;
    }

    @Override
    public boolean isInner() {
        return false;
    }

    public String toString() {
        return "class " + this.getName();
    }
}

