/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.PositioningStrategyKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"+\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\t\u0001\u0015\tA!A\u0003\u0002\u0011\u0017)\u0011\u0001b\u0001\u0006\u0003!\u0001R!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0011YA\u0002A\u000b\u0005\t\u0001A\t!F\u0001\u0019\u0003e\t\u00014AQ\u0003#\u000e\t\u0001BAS\u000b\t-A)!D\u0001\u0019\u0007e\u0019\u0001rA\u0007\u00029\u0001\t6!\u0001\u0005\u0005K7!!\u0002#\u0003\u000e\t%\u0011\u0011\"\u0001M\u00061\u0015I2\u0001c\u0002\u000e\u0003q\u0001\u0011kA\u0001\t\r\u0015zAa\u0003E\u0007\u001b\u0011I!!C\u0001\u0019\fa)\u0011d\u0002\u0005\b\u001b\u0015I1\u0001\"\u0001\n\u0003q\u0001\u0001t\u0002"}, strings={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "E", "Lcom/intellij/psi/PsiElement;", "", "()V", "isValid", "", "element", "(Lcom/intellij/psi/PsiElement;)Z", "mark", "", "Lcom/intellij/openapi/util/TextRange;", "(Lcom/intellij/psi/PsiElement;)Ljava/util/List;", "markDiagnostic", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/ParametrizedDiagnostic;"}, moduleName="kotlin-compiler")
public class PositioningStrategy<E extends PsiElement> {
    @NotNull
    public List<TextRange> markDiagnostic(@NotNull ParametrizedDiagnostic<? extends E> diagnostic) {
        Intrinsics.checkParameterIsNotNull(diagnostic, "diagnostic");
        E e = diagnostic.getPsiElement();
        Intrinsics.checkExpressionValueIsNotNull(e, "diagnostic.getPsiElement()");
        return this.mark(e);
    }

    @NotNull
    protected List<TextRange> mark(@NotNull E element) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        return PositioningStrategyKt.markElement(element);
    }

    public boolean isValid(@NotNull E element) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        return !PositioningStrategyKt.hasSyntaxErrors(element);
    }
}

