/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.facade;

import com.google.dart.compiler.backend.js.ast.JsProgram;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.js.analyze.TopDownAnalyzerFacadeForJS;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.config.Config;
import org.jetbrains.kotlin.js.facade.MainCallParameters;
import org.jetbrains.kotlin.js.facade.TranslationResult;
import org.jetbrains.kotlin.js.facade.exceptions.TranslationException;
import org.jetbrains.kotlin.js.inline.JsInliner;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.ExpandIsCallsKt;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

public final class K2JSTranslator {
    public static final String FLUSH_SYSTEM_OUT = "Kotlin.out.flush();\n";
    public static final String GET_SYSTEM_OUT = "Kotlin.out.buffer;\n";
    @NotNull
    private final Config config;

    public K2JSTranslator(@NotNull Config config) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "<init>"));
        }
        this.config = config;
    }

    @NotNull
    public TranslationResult translate(@NotNull List<KtFile> files, @NotNull MainCallParameters mainCallParameters) throws TranslationException {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translate"));
        }
        if (mainCallParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainCallParameters", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translate"));
        }
        TranslationResult translationResult = this.translate(files, mainCallParameters, null);
        if (translationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translate"));
        }
        return translationResult;
    }

    @NotNull
    public TranslationResult translate(@NotNull List<KtFile> files, @NotNull MainCallParameters mainCallParameters, @Nullable JsAnalysisResult analysisResult) throws TranslationException {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translate"));
        }
        if (mainCallParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainCallParameters", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translate"));
        }
        if (analysisResult == null) {
            analysisResult = TopDownAnalyzerFacadeForJS.analyzeFiles(files, this.config);
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        }
        BindingTrace bindingTrace = analysisResult.getBindingTrace();
        TopDownAnalyzerFacadeForJS.checkForErrors(Config.withJsLibAdded(files, this.config), bindingTrace.getBindingContext());
        ModuleDescriptor moduleDescriptor = analysisResult.getModuleDescriptor();
        Diagnostics diagnostics = bindingTrace.getBindingContext().getDiagnostics();
        TranslationContext context = Translation.generateAst(bindingTrace, files, mainCallParameters, moduleDescriptor, this.config);
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        if (DiagnosticUtils.hasError(diagnostics)) {
            TranslationResult.Fail fail = new TranslationResult.Fail(diagnostics);
            if (fail == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translate"));
            }
            return fail;
        }
        JsProgram program = JsInliner.process(context);
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        if (DiagnosticUtils.hasError(diagnostics)) {
            TranslationResult.Fail fail = new TranslationResult.Fail(diagnostics);
            if (fail == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translate"));
            }
            return fail;
        }
        ExpandIsCallsKt.expandIsCalls(program, context);
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        TranslationResult.Success success = new TranslationResult.Success(this.config, files, program, diagnostics, moduleDescriptor);
        if (success == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translate"));
        }
        return success;
    }
}

