/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.callTranslator;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfoKt;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.callTranslator.ExplicitReceivers;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallCasesKt;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"+\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005AY!B\u0001\r\u00035%\u0002\u0002A\u0007\u00021\u0003I2\u0001C\u0001\u000e\u0003a\r\u0011d\u0002\u0005\u0003\u001b\u0015I1\u0001\"\u0001\n\u0003a\u0019\u0001TA\r\u0004\u0011\u000fi\u0011\u0001'\u0001U\u0007\u0011iY\u0003B\u0001\t\n5\t\u0001$B\r\u0004\u0011\u0005i\u0011\u0001g\u0001\u001a\u000f!\u0011Q\"B\u0005\u0004\t\u0003I\u0011\u0001G\u0002\u0019\u0006e\u0019\u0001rA\u0007\u00021\u0003!6\u0001BG\u0016\t\u0005AY!D\u0001\u0019\u000be\u0019\u0001\"A\u0007\u00021\u0007Ir\u0001\u0003\u0002\u000e\u000b%\u0019A\u0011A\u0005\u00021\rA*!G\u0002\t\b5\t\u0001\u0014\u0001+\u0004\t5]A!\u0001\u0005\u0007\u001b\u0005Aj!F\u0003\n\u0007\u0011\u0005\u0011\"\u0001\r\b1\u000b!6\u0001\u0002"}, strings={"computeExplicitReceiversForInvoke", "Lorg/jetbrains/kotlin/js/translate/callTranslator/ExplicitReceivers;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "explicitReceivers", "CallTranslatorKt", "translateCall", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "translateFunctionCall", "expectedReceivers", "", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;"}, moduleName="kotlin-compiler")
public final class CallTranslatorKt {
    private static final boolean expectedReceivers(ResolvedCall<? extends CallableDescriptor> $receiver) {
        return Intrinsics.areEqual((Object)$receiver.getExplicitReceiverKind(), (Object)ExplicitReceiverKind.NO_EXPLICIT_RECEIVER) ^ true;
    }

    private static final JsExpression translateCall(TranslationContext context, ResolvedCall<? extends FunctionDescriptor> resolvedCall, ExplicitReceivers explicitReceivers) {
        if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
            Unit unit;
            boolean value2 = explicitReceivers.getExtensionReceiver() == null;
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                if (!value2) {
                    String message = "VariableAsFunctionResolvedCall must have one receiver";
                    throw (Throwable)((Object)new AssertionError((Object)message));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            ResolvedCall<VariableDescriptor> variableCall = ((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getVariableCall();
            if (CallTranslatorKt.expectedReceivers(variableCall)) {
                JsExpression newReceiver = CallTranslator.INSTANCE.translateGet(context, variableCall, explicitReceivers.getExtensionOrDispatchReceiver());
                return CallTranslatorKt.translateFunctionCall(context, ((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getFunctionCall(), new ExplicitReceivers(newReceiver, null, 2, null));
            }
            JsExpression dispatchReceiver = CallTranslator.INSTANCE.translateGet(context, variableCall, null);
            if (explicitReceivers.getExtensionOrDispatchReceiver() == null) {
                return CallTranslatorKt.translateFunctionCall(context, ((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getFunctionCall(), new ExplicitReceivers(dispatchReceiver, null, 2, null));
            }
            return CallTranslatorKt.translateFunctionCall(context, ((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getFunctionCall(), new ExplicitReceivers(dispatchReceiver, explicitReceivers.getExtensionOrDispatchReceiver()));
        }
        Call call = resolvedCall.getCall();
        if (Intrinsics.areEqual((Object)call.getCallType(), (Object)Call.CallType.INVOKE)) {
            Call call2 = call;
            Intrinsics.checkExpressionValueIsNotNull(call2, "call");
            if (!CallResolverUtilKt.isInvokeCallOnVariable(call2)) {
                ExplicitReceivers explicitReceiversForInvoke = CallTranslatorKt.computeExplicitReceiversForInvoke(context, resolvedCall, explicitReceivers);
                return CallTranslatorKt.translateFunctionCall(context, resolvedCall, explicitReceiversForInvoke);
            }
        }
        return CallTranslatorKt.translateFunctionCall(context, resolvedCall, explicitReceivers);
    }

    private static final JsExpression translateFunctionCall(TranslationContext context, ResolvedCall<? extends FunctionDescriptor> resolvedCall, ExplicitReceivers explicitReceivers) {
        return FunctionCallCasesKt.translateFunctionCall(CallInfoKt.getCallInfo(context, resolvedCall, explicitReceivers));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ExplicitReceivers computeExplicitReceiversForInvoke(@NotNull TranslationContext context, @NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall, @NotNull ExplicitReceivers explicitReceivers) {
        ExplicitReceivers explicitReceivers2;
        boolean value2;
        Unit unit;
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(explicitReceivers, "explicitReceivers");
        KtElement callElement = resolvedCall.getCall().getCallElement();
        boolean bl = explicitReceivers.getExtensionReceiver() == null;
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            void value3;
            if (value3 == false) {
                String message = "'Invoke' call must have one receiver: " + callElement;
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        Function1<ReceiverValue, JsExpression> translateReceiverAsExpression$ = new Function1<ReceiverValue, JsExpression>(context){
            final /* synthetic */ TranslationContext $context;

            @Nullable
            public final JsExpression invoke(@NotNull ReceiverValue receiver) {
                JsExpression jsExpression;
                Intrinsics.checkParameterIsNotNull(receiver, "receiver");
                ReceiverValue receiverValue = receiver;
                if (!(receiverValue instanceof ExpressionReceiver)) {
                    receiverValue = null;
                }
                ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue;
                if (expressionReceiver != null) {
                    ExpressionReceiver $receiver = expressionReceiver;
                    ExpressionReceiver it = $receiver;
                    jsExpression = Translation.translateAsExpression(it.getExpression(), this.$context);
                } else {
                    jsExpression = null;
                }
                return jsExpression;
            }
            {
                this.$context = translationContext;
                super(1);
            }
        };
        ReceiverValue dispatchReceiver = resolvedCall.getDispatchReceiver();
        ReceiverValue extensionReceiver2 = resolvedCall.getExtensionReceiver();
        if (dispatchReceiver.exists() && extensionReceiver2.exists() && Intrinsics.areEqual((Object)resolvedCall.getExplicitReceiverKind(), (Object)ExplicitReceiverKind.BOTH_RECEIVERS)) {
            Unit unit2;
            boolean $i$f$assert = explicitReceivers.getExtensionOrDispatchReceiver() != null;
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                if (!value2) {
                    String message = "No explicit receiver for 'invoke' resolved call with both receivers: " + callElement + ", text: " + callElement.getText() + ("Dispatch receiver: " + dispatchReceiver + " Extension receiver: " + extensionReceiver2);
                    throw (Throwable)((Object)new AssertionError((Object)message));
                }
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = Unit.INSTANCE;
            }
        } else {
            Unit unit3;
            value2 = explicitReceivers.getExtensionOrDispatchReceiver() == null;
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                if (!value2) {
                    String message = "Non trivial explicit receiver " + explicitReceivers.getExtensionOrDispatchReceiver() + "\n" + ("for 'invoke' resolved call: " + callElement + ", text: " + callElement.getText() + "\n") + ("Dispatch receiver: " + dispatchReceiver + " Extension receiver: " + extensionReceiver2);
                    throw (Throwable)((Object)new AssertionError((Object)message));
                }
                unit3 = Unit.INSTANCE;
            } else {
                unit3 = Unit.INSTANCE;
            }
        }
        ReceiverValue receiverValue = dispatchReceiver;
        Intrinsics.checkExpressionValueIsNotNull(receiverValue, "dispatchReceiver");
        JsExpression dispatchReceiverExpression = translateReceiverAsExpression$.invoke(receiverValue);
        Pair<Boolean, Boolean> pair = new Pair<Boolean, Boolean>(dispatchReceiver.exists(), extensionReceiver2.exists());
        if (Intrinsics.areEqual(pair, new Pair<Boolean, Boolean>(true, true))) {
            explicitReceivers2 = new ExplicitReceivers(dispatchReceiverExpression, explicitReceivers.getExtensionOrDispatchReceiver());
        } else if (Intrinsics.areEqual(pair, new Pair<Boolean, Boolean>(true, false))) {
            explicitReceivers2 = new ExplicitReceivers(dispatchReceiverExpression, null, 2, null);
        } else if (Intrinsics.areEqual(pair, new Pair<Boolean, Boolean>(false, true))) {
            ReceiverValue receiverValue2 = extensionReceiver2;
            Intrinsics.checkExpressionValueIsNotNull(receiverValue2, "extensionReceiver");
            explicitReceivers2 = new ExplicitReceivers(translateReceiverAsExpression$.invoke(receiverValue2), null, 2, null);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("'Invoke' resolved call without receivers: " + callElement)));
        }
        return explicitReceivers2;
    }

    @NotNull
    public static final /* synthetic */ JsExpression access$translateCall(@NotNull TranslationContext context, @NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall, @NotNull ExplicitReceivers explicitReceivers) {
        return CallTranslatorKt.translateCall(context, resolvedCall, explicitReceivers);
    }
}

