/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsFunctionScope;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.MapsKt;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.FunctionReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.backend.common.CodegenUtilKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.DelegationTranslator;
import org.jetbrains.kotlin.js.translate.declaration.propertyTranslator.PropertyTranslatorKt;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.ManglingUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDelegationSpecifier;
import org.jetbrains.kotlin.psi.KtDelegatorByExpressionSpecifier;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"g\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0011\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\u0001\u0006\u0001\u0015\t\u0001\u0012E\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005Aq!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0002\u0006\u00031\tQ\u0001\u0001\u0007\u00013\u0005A\n!(A\u0013C+I1\u0001C\u0001\u000e\u0003a\r\u0011b\u0001\u0005\u0003\u001b\u0005A*!U\u0002\u0002\u0011\r)#\u0002c\u0004\u000e\u0003aA\u0011D\u0002E\t\u001b\u0011I!!C\u0001\u0019\u0014aIQe\u0006\u0003\u0002\u0011)i\u0011\u0001\u0007\u0005\u001a\u0007!UQ\"\u0001\r\f3\rA9\"D\u0001\u0019\u0017e\u0019\u0001\u0002D\u0007\u000213Ib\u0001C\u0007\u000e\t%\u0011\u0011\"\u0001M\u000e1%)3\u0003B\u0001\t\u001d5\t\u0001\u0004C\r\u0004\u0011+i\u0011\u0001'\b\u001a\u0007!aQ\"\u0001M\r3\u0019AQ\"\u0004\u0003\n\u0005%\t\u00014\u0004\r\nK)Aq\"D\u0001\u0019\u0011e1\u0001\"D\u0007\u0005\u0013\tI\u0011\u0001g\u0007\u0019\u0013\u0015\u001aB!\u0001E\u0010\u001b\u0005A\u0002\"G\u0002\t!5\t\u0001\u0004B\r\u0004\u0011Ci\u0011\u0001G\u0004\u001a\r!iQ\u0002B\u0005\u0003\u0013\u0005AZ\u0002G\u0005&\u0011\u0011\t\u0001\"E\u0007\u00021\u0011I2\u0001c\t\u000e\u0003a\u0011\u0012f\u0002\u0003B\u0011!\tQ\"\u0001M\u0002#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001rA\u0007\u00021\u0011\t6!A\u0003\u0001S)!\u0011\t\u0003E\u0005\u001b\u0011I!!C\u0001\u0019\fa)\u0011kA\u0001\u0006\u0001%jA!\u0011\u0005\t\r59\u0011BA\u0005\u00021\u0017I!!C\u0001\u0019\u000fa5\u0011kA\u0001\u0006\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/js/translate/declaration/DelegationTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "classDeclaration", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "delegationBySpecifiers", "", "Lorg/jetbrains/kotlin/psi/KtDelegatorByExpressionSpecifier;", "fields", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/js/translate/declaration/DelegationTranslator$Field;", "addInitCode", "", "statements", "", "Lcom/google/dart/compiler/backend/js/ast/JsStatement;", "generateDelegateCallForFunctionMember", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "overriddenDescriptor", "delegateName", "", "properties", "Lcom/google/dart/compiler/backend/js/ast/JsPropertyInitializer;", "generateDelegateCallForPropertyMember", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "generateDelegated", "generateDelegates", "toClass", "field", "getSuperClass", "specifier", "Lorg/jetbrains/kotlin/psi/KtDelegationSpecifier;", "Field"}, moduleName="kotlin-compiler")
public final class DelegationTranslator
extends AbstractTranslator {
    private final ClassDescriptor classDescriptor;
    private final List<? extends KtDelegatorByExpressionSpecifier> delegationBySpecifiers;
    private final HashMap<KtDelegatorByExpressionSpecifier, Field> fields;
    private final KtClassOrObject classDeclaration;

    public final void addInitCode(@NotNull List<JsStatement> statements) {
        Intrinsics.checkParameterIsNotNull(statements, "statements");
        for (KtDelegatorByExpressionSpecifier ktDelegatorByExpressionSpecifier : this.delegationBySpecifiers) {
            KtExpression expression;
            Field field;
            if (this.fields.get(ktDelegatorByExpressionSpecifier) == null) {
                Intrinsics.throwNpe();
            }
            if (!field.getGenerateField()) continue;
            if (ktDelegatorByExpressionSpecifier.getDelegateExpression() == null) {
                Intrinsics.throwNpe();
            }
            JsExpression delegateInitExpr = Translation.translateAsExpression(expression, this.context());
            JsStatement jsStatement = JsAstUtils.defineSimpleProperty(field.getName(), delegateInitExpr);
            Intrinsics.checkExpressionValueIsNotNull(jsStatement, "JsAstUtils.defineSimpleP\u2026d.name, delegateInitExpr)");
            statements.add(jsStatement);
        }
    }

    public final void generateDelegated(@NotNull List<JsPropertyInitializer> properties2) {
        Intrinsics.checkParameterIsNotNull(properties2, "properties");
        for (KtDelegatorByExpressionSpecifier ktDelegatorByExpressionSpecifier : this.delegationBySpecifiers) {
            ClassDescriptor classDescriptor = this.getSuperClass(ktDelegatorByExpressionSpecifier);
            Field field = this.fields.get(ktDelegatorByExpressionSpecifier);
            if (field == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(field, "fields.get(specifier)!!");
            this.generateDelegates(classDescriptor, field, properties2);
        }
    }

    private final ClassDescriptor getSuperClass(KtDelegationSpecifier specifier) {
        ClassDescriptor classDescriptor = CodegenUtil.getSuperClassByDelegationSpecifier(specifier, this.bindingContext());
        Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "CodegenUtil.getSuperClas\u2026cifier, bindingContext())");
        return classDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    private final void generateDelegates(ClassDescriptor toClass, Field field, List<JsPropertyInitializer> properties2) {
        Iterator iterator2 = MapsKt.iterator(CodegenUtilKt.getDelegates$default(this.classDescriptor, toClass, null, 4));
        while (iterator2.hasNext()) {
            void $receiver;
            void $receiver2;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator2.next();
            CallableMemberDescriptor descriptor2 = (CallableMemberDescriptor)$receiver2.getKey();
            Map.Entry $i$f$component1 = entry;
            CallableDescriptor overriddenDescriptor = (CallableDescriptor)$receiver.getValue();
            CallableMemberDescriptor callableMemberDescriptor = descriptor2;
            if (callableMemberDescriptor instanceof PropertyDescriptor) {
                this.generateDelegateCallForPropertyMember((PropertyDescriptor)descriptor2, field.getName(), properties2);
                continue;
            }
            if (callableMemberDescriptor instanceof FunctionDescriptor) {
                CallableDescriptor callableDescriptor = overriddenDescriptor;
                if (callableDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
                }
                this.generateDelegateCallForFunctionMember((FunctionDescriptor)descriptor2, (FunctionDescriptor)callableDescriptor, field.getName(), properties2);
                continue;
            }
            throw (Throwable)new IllegalArgumentException("Expected property or function " + descriptor2);
        }
    }

    private final void generateDelegateCallForPropertyMember(PropertyDescriptor descriptor2, String delegateName, List<JsPropertyInitializer> properties2) {
        String string = descriptor2.getName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "descriptor.getName().asString()");
        String propertyName = string;
        Function1<PropertyGetterDescriptor, JsFunction> generateDelegateGetterFunction$ = new Function1<PropertyGetterDescriptor, JsFunction>(this, delegateName, descriptor2, propertyName){
            final /* synthetic */ DelegationTranslator this$0;
            final /* synthetic */ String $delegateName;
            final /* synthetic */ PropertyDescriptor $descriptor;
            final /* synthetic */ String $propertyName;

            @NotNull
            public final JsFunction invoke(@NotNull PropertyGetterDescriptor getterDescriptor) {
                JsExpression jsExpression;
                Intrinsics.checkParameterIsNotNull(getterDescriptor, "getterDescriptor");
                JsName delegateRefName = DelegationTranslator.access$context(this.this$0).getScopeForDescriptor(getterDescriptor).declareName(this.$delegateName);
                JsNameRef delegateRef = new JsNameRef(delegateRefName, (JsExpression)JsLiteral.THIS);
                if (DescriptorUtils.isExtension(this.$descriptor)) {
                    JsName getterName = DelegationTranslator.access$context(this.this$0).getNameForDescriptor(getterDescriptor);
                    String receiver = Namer.getReceiverParameterName();
                    jsExpression = new JsInvocation((JsExpression)new JsNameRef(getterName, (JsExpression)delegateRef), new JsNameRef(receiver));
                } else {
                    jsExpression = new JsNameRef(this.$propertyName, (JsExpression)delegateRef);
                }
                JsExpression returnExpression = jsExpression;
                JsFunction jsFunction = TranslationUtils.simpleReturnFunction(DelegationTranslator.access$context(this.this$0).getScopeForDescriptor(getterDescriptor.getContainingDeclaration()), returnExpression);
                if (DescriptorUtils.isExtension(this.$descriptor)) {
                    JsFunctionScope jsFunctionScope = jsFunction.getScope();
                    String string = Namer.getReceiverParameterName();
                    Intrinsics.checkExpressionValueIsNotNull(string, "Namer.getReceiverParameterName()");
                    JsName receiverName = jsFunctionScope.declareName(string);
                    jsFunction.getParameters().add(new JsParameter(receiverName));
                }
                JsFunction jsFunction2 = jsFunction;
                Intrinsics.checkExpressionValueIsNotNull(jsFunction2, "jsFunction");
                return jsFunction2;
            }
            {
                this.this$0 = delegationTranslator;
                this.$delegateName = string;
                this.$descriptor = propertyDescriptor;
                this.$propertyName = string2;
                super(1);
            }
        };
        Function1<PropertySetterDescriptor, JsFunction> generateDelegateSetterFunction$ = new Function1<PropertySetterDescriptor, JsFunction>(this, delegateName, descriptor2, propertyName){
            final /* synthetic */ DelegationTranslator this$0;
            final /* synthetic */ String $delegateName;
            final /* synthetic */ PropertyDescriptor $descriptor;
            final /* synthetic */ String $propertyName;

            @NotNull
            public final JsFunction invoke(@NotNull PropertySetterDescriptor setterDescriptor) {
                JsExpression jsExpression;
                Unit unit;
                Intrinsics.checkParameterIsNotNull(setterDescriptor, "setterDescriptor");
                JsFunction jsFunction = new JsFunction(DelegationTranslator.access$context(this.this$0).getScopeForDescriptor(setterDescriptor.getContainingDeclaration()), "setter for " + setterDescriptor.getName().asString());
                Collection $receiver = setterDescriptor.getValueParameters();
                boolean value2 = $receiver.size() == 1;
                if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                    if (!value2) {
                        String message = "Setter must have 1 parameter";
                        throw (Throwable)((Object)new AssertionError((Object)message));
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = Unit.INSTANCE;
                }
                JsParameter defaultParameter = new JsParameter(jsFunction.getScope().declareTemporary());
                JsNameRef defaultParameterRef = defaultParameter.getName().makeRef();
                JsName delegateRefName = DelegationTranslator.access$context(this.this$0).getScopeForDescriptor(setterDescriptor).declareName(this.$delegateName);
                JsNameRef delegateRef = new JsNameRef(delegateRefName, (JsExpression)JsLiteral.THIS);
                if (DescriptorUtils.isExtension(this.$descriptor)) {
                    JsName setterName = DelegationTranslator.access$context(this.this$0).getNameForDescriptor(setterDescriptor);
                    JsNameRef setterNameRef = new JsNameRef(setterName, (JsExpression)delegateRef);
                    JsFunctionScope jsFunctionScope = jsFunction.getScope();
                    String string = Namer.getReceiverParameterName();
                    Intrinsics.checkExpressionValueIsNotNull(string, "Namer.getReceiverParameterName()");
                    JsName extensionFunctionReceiverName = jsFunctionScope.declareName(string);
                    jsFunction.getParameters().add(new JsParameter(extensionFunctionReceiverName));
                    jsExpression = new JsInvocation((JsExpression)setterNameRef, new JsNameRef(extensionFunctionReceiverName), defaultParameterRef);
                } else {
                    JsNameRef propertyNameRef = new JsNameRef(this.$propertyName, (JsExpression)delegateRef);
                    jsExpression = JsAstUtils.assignment(propertyNameRef, defaultParameterRef);
                }
                JsExpression setExpression = jsExpression;
                jsFunction.getParameters().add(defaultParameter);
                jsFunction.setBody(new JsBlock(setExpression.makeStmt()));
                return jsFunction;
            }
            {
                this.this$0 = delegationTranslator;
                this.$delegateName = string;
                this.$descriptor = propertyDescriptor;
                this.$propertyName = string2;
                super(1);
            }
        };
        Function2<PropertyAccessorDescriptor, JsFunction, JsPropertyInitializer> generateDelegateAccessor$ = new Function2<PropertyAccessorDescriptor, JsFunction, JsPropertyInitializer>(this){
            final /* synthetic */ DelegationTranslator this$0;

            @NotNull
            public final JsPropertyInitializer invoke(@NotNull PropertyAccessorDescriptor accessorDescriptor, @NotNull JsFunction function) {
                Intrinsics.checkParameterIsNotNull(accessorDescriptor, "accessorDescriptor");
                Intrinsics.checkParameterIsNotNull(function, "function");
                JsPropertyInitializer jsPropertyInitializer = TranslationUtils.translateFunctionAsEcma5PropertyDescriptor(function, accessorDescriptor, DelegationTranslator.access$context(this.this$0));
                Intrinsics.checkExpressionValueIsNotNull(jsPropertyInitializer, "translateFunctionAsEcma5\u2026sorDescriptor, context())");
                return jsPropertyInitializer;
            }
            {
                this.this$0 = delegationTranslator;
                super(2);
            }
        };
        Function0<JsPropertyInitializer> generateDelegateGetter$ = new Function0<JsPropertyInitializer>(descriptor2, generateDelegateAccessor$, generateDelegateGetterFunction$){
            final /* synthetic */ PropertyDescriptor $descriptor;
            final /* synthetic */ generateDelegateCallForPropertyMember.3 $generateDelegateAccessor;
            final /* synthetic */ generateDelegateCallForPropertyMember.1 $generateDelegateGetterFunction;

            @NotNull
            public final JsPropertyInitializer invoke() {
                PropertyGetterDescriptor propertyGetterDescriptor = this.$descriptor.getGetter();
                if (propertyGetterDescriptor == null) {
                    throw (Throwable)new IllegalStateException("Getter descriptor should not be null");
                }
                PropertyGetterDescriptor getterDescriptor = propertyGetterDescriptor;
                PropertyAccessorDescriptor propertyAccessorDescriptor = getterDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(propertyAccessorDescriptor, "getterDescriptor");
                PropertyGetterDescriptor propertyGetterDescriptor2 = getterDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(propertyGetterDescriptor2, "getterDescriptor");
                return this.$generateDelegateAccessor.invoke(propertyAccessorDescriptor, this.$generateDelegateGetterFunction.invoke(propertyGetterDescriptor2));
            }
            {
                this.$descriptor = propertyDescriptor;
                this.$generateDelegateAccessor = var2_2;
                this.$generateDelegateGetterFunction = var3_3;
                super(0);
            }
        };
        Function0<JsPropertyInitializer> generateDelegateSetter$ = new Function0<JsPropertyInitializer>(descriptor2, generateDelegateAccessor$, generateDelegateSetterFunction$){
            final /* synthetic */ PropertyDescriptor $descriptor;
            final /* synthetic */ generateDelegateCallForPropertyMember.3 $generateDelegateAccessor;
            final /* synthetic */ generateDelegateCallForPropertyMember.2 $generateDelegateSetterFunction;

            @NotNull
            public final JsPropertyInitializer invoke() {
                PropertySetterDescriptor propertySetterDescriptor = this.$descriptor.getSetter();
                if (propertySetterDescriptor == null) {
                    throw (Throwable)new IllegalStateException("Setter descriptor should not be null");
                }
                PropertySetterDescriptor setterDescriptor = propertySetterDescriptor;
                PropertyAccessorDescriptor propertyAccessorDescriptor = setterDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(propertyAccessorDescriptor, "setterDescriptor");
                PropertySetterDescriptor propertySetterDescriptor2 = setterDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(propertySetterDescriptor2, "setterDescriptor");
                return this.$generateDelegateAccessor.invoke(propertyAccessorDescriptor, this.$generateDelegateSetterFunction.invoke(propertySetterDescriptor2));
            }
            {
                this.$descriptor = propertyDescriptor;
                this.$generateDelegateAccessor = var2_2;
                this.$generateDelegateSetterFunction = var3_3;
                super(0);
            }
        };
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "context()");
        PropertyTranslatorKt.addGetterAndSetter(properties2, descriptor2, translationContext, (Function0)((Object)Reflection.function((FunctionReference)new Function0<JsPropertyInitializer>(generateDelegateGetter$){
            final /* synthetic */ generateDelegateCallForPropertyMember.4 $generateDelegateGetter;

            @NotNull
            public final JsPropertyInitializer invoke() {
                return this.$generateDelegateGetter.invoke();
            }

            public final KDeclarationContainer getOwner() {
                return null;
            }

            public final String getName() {
                return "generateDelegateGetter";
            }

            public final String getSignature() {
                return "invoke()Lcom/google/dart/compiler/backend/js/ast/JsPropertyInitializer;";
            }
            {
                this.$generateDelegateGetter = var1_1;
                super(0);
            }
        })), (Function0)((Object)Reflection.function((FunctionReference)new Function0<JsPropertyInitializer>(generateDelegateSetter$){
            final /* synthetic */ generateDelegateCallForPropertyMember.5 $generateDelegateSetter;

            @NotNull
            public final JsPropertyInitializer invoke() {
                return this.$generateDelegateSetter.invoke();
            }

            public final KDeclarationContainer getOwner() {
                return null;
            }

            public final String getName() {
                return "generateDelegateSetter";
            }

            public final String getSignature() {
                return "invoke()Lcom/google/dart/compiler/backend/js/ast/JsPropertyInitializer;";
            }
            {
                this.$generateDelegateSetter = var1_1;
                super(0);
            }
        })));
    }

    private final void generateDelegateCallForFunctionMember(FunctionDescriptor descriptor2, FunctionDescriptor overriddenDescriptor, String delegateName, List<JsPropertyInitializer> properties2) {
        JsName delegateRefName = this.context().getScopeForDescriptor(descriptor2).declareName(delegateName);
        JsNameRef delegateRef = new JsNameRef(delegateRefName, (JsExpression)JsLiteral.THIS);
        JsExpression jsExpression = delegateRef;
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "context()");
        properties2.add(UtilsKt.generateDelegateCall(descriptor2, overriddenDescriptor, jsExpression, translationContext));
    }

    /*
     * WARNING - void declaration
     */
    public DelegationTranslator(@NotNull KtClassOrObject classDeclaration, @NotNull TranslationContext context) {
        List list;
        void destination;
        void $receiver;
        Intrinsics.checkParameterIsNotNull(classDeclaration, "classDeclaration");
        Intrinsics.checkParameterIsNotNull(context, "context");
        super(context);
        this.classDeclaration = classDeclaration;
        ClassDescriptor classDescriptor = BindingUtils.getClassDescriptor(context.bindingContext(), this.classDeclaration);
        Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "BindingUtils.getClassDes\u2026text(), classDeclaration)");
        this.classDescriptor = classDescriptor;
        Iterable iterable = this.classDeclaration.getDelegationSpecifiers();
        DelegationTranslator delegationTranslator = this;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        for (Object element : $receiver) {
            if (!(element instanceof KtDelegatorByExpressionSpecifier)) continue;
            destination.add(element);
        }
        delegationTranslator.delegationBySpecifiers = list = (List)destination;
        this.fields = new HashMap();
        for (KtDelegatorByExpressionSpecifier ktDelegatorByExpressionSpecifier : this.delegationBySpecifiers) {
            String delegateName;
            KtExpression expression;
            if (ktDelegatorByExpressionSpecifier.getDelegateExpression() == null) {
                throw (Throwable)new IllegalArgumentException("delegate expression should not be null: " + ktDelegatorByExpressionSpecifier.getText());
            }
            ClassDescriptor descriptor2 = this.getSuperClass(ktDelegatorByExpressionSpecifier);
            PropertyDescriptor propertyDescriptor = CodegenUtil.getDelegatePropertyIfAny(expression, this.classDescriptor, this.bindingContext());
            if (CodegenUtil.isFinalPropertyWithBackingField(propertyDescriptor, this.bindingContext())) {
                PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
                if (propertyDescriptor2 == null) {
                    Intrinsics.throwNpe();
                }
                String string = propertyDescriptor2.getName().asString();
                Intrinsics.checkExpressionValueIsNotNull(string, "propertyDescriptor!!.getName().asString()");
                this.fields.put(ktDelegatorByExpressionSpecifier, new Field(string, false));
                continue;
            }
            FqNameUnsafe classFqName = DescriptorUtils.getFqName(this.classDescriptor);
            FqNameUnsafe typeFqName = DescriptorUtils.getFqName(descriptor2);
            String string = delegateName = ManglingUtils.getMangledMemberNameForExplicitDelegation(Namer.getDelegatePrefix(), classFqName, typeFqName);
            Intrinsics.checkExpressionValueIsNotNull(string, "delegateName");
            this.fields.put(ktDelegatorByExpressionSpecifier, new Field(string, true));
        }
    }

    @NotNull
    public static final /* synthetic */ TranslationContext access$context(DelegationTranslator $this) {
        return $this.context();
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0019\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\u000f\u0015\u0001Q!\u0001E\u0006\u000b\u0005!)\u0001B\u0001\r\u0001e\t\u0001\u0014AQ\u000b\u0013\rA\u0011!D\u0001\u0019\u0004%\u0019\u0001BA\u0007\u00021\u000b\t6!\u0001\u0005\u0004S)!1\t\u0003\u0005\u0003\u001b\u0005A*!U\u0002\u0005\u000b\u0001i!\u0001b\u0002\t\t%RAa\u0011\u0005\t\u00035\t\u00014A)\u0004\t\u0015\u0001QB\u0001C\u0005\u0011\u0015\u0001"}, strings={"Lorg/jetbrains/kotlin/js/translate/declaration/DelegationTranslator$Field;", "", "name", "", "generateField", "", "(Ljava/lang/String;Z)V", "getGenerateField", "()Z", "getName", "()Ljava/lang/String;"}, moduleName="kotlin-compiler")
    private static final class Field {
        @NotNull
        private final String name;
        private final boolean generateField;

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final boolean getGenerateField() {
            return this.generateField;
        }

        public Field(@NotNull String name, boolean generateField) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            this.name = name;
            this.generateField = generateField;
        }
    }
}

