/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.context.UsageTracker;
import org.jetbrains.kotlin.js.translate.context.UsageTrackerKt;
import org.jetbrains.kotlin.js.translate.expression.FunctionTranslator;
import org.jetbrains.kotlin.js.translate.expression.LiteralFunctionTranslatorKt;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001d\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u00031\u0001\u0011$\u0001M\u0001C\u001bI1\u0001C\u0001\u000e\u0003a\r\u0011kA\u0001\t\u0005\u0015:\u0001RA\u0007\u00021\rI2\u0001c\u0002\u000e\u0003a!\u0001"}, strings={"Lorg/jetbrains/kotlin/js/translate/expression/LiteralFunctionTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "translate", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;"}, moduleName="kotlin-compiler")
public final class LiteralFunctionTranslator
extends AbstractTranslator {
    @NotNull
    public final JsExpression translate(@NotNull KtDeclarationWithBody declaration) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        TranslationContext invokingContext = this.context();
        FunctionDescriptor descriptor2 = BindingUtils.getFunctionDescriptor(invokingContext.bindingContext(), declaration);
        JsFunction lambda2 = invokingContext.getFunctionObject(descriptor2);
        TranslationContext functionContext = invokingContext.newFunctionBodyWithUsageTracker(lambda2, descriptor2);
        FunctionTranslator.addParameters(lambda2.getParameters(), descriptor2, functionContext);
        JsBlock functionBody = FunctionBodyTranslator.translateFunctionBody(descriptor2, declaration, functionContext);
        List<JsStatement> list = lambda2.getBody().getStatements();
        Collection collection = functionBody.getStatements();
        Intrinsics.checkExpressionValueIsNotNull(collection, "functionBody.getStatements()");
        list.addAll(collection);
        UsageTracker usageTracker = functionContext.usageTracker();
        if (usageTracker == null) {
            Intrinsics.throwNpe();
        }
        UsageTracker tracker = usageTracker;
        DeclarationDescriptor declarationDescriptor = descriptor2;
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "descriptor");
        boolean isRecursive = UsageTrackerKt.isCaptured(tracker, declarationDescriptor);
        if (isRecursive) {
            DeclarationDescriptor declarationDescriptor2 = descriptor2;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor2, "descriptor");
            lambda2.setName(UsageTrackerKt.getNameForCapturedDescriptor(tracker, declarationDescriptor2));
        }
        if (UsageTrackerKt.hasCapturedExceptContaining(tracker)) {
            JsFunction lambdaCreator = TranslationUtils.simpleReturnFunction(invokingContext.scope(), lambda2);
            MetadataProperties.setLocal(lambdaCreator, true);
            TranslationContext translationContext = functionContext;
            Intrinsics.checkExpressionValueIsNotNull(translationContext, "functionContext");
            TranslationContext translationContext2 = invokingContext;
            Intrinsics.checkExpressionValueIsNotNull(translationContext2, "invokingContext");
            MemberDescriptor memberDescriptor = descriptor2;
            Intrinsics.checkExpressionValueIsNotNull(memberDescriptor, "descriptor");
            return LiteralFunctionTranslatorKt.withCapturedParameters(lambdaCreator, translationContext, translationContext2, memberDescriptor);
        }
        MetadataProperties.setLocal(lambda2, true);
        JsExpression jsExpression = invokingContext.define(descriptor2, lambda2);
        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "invokingContext.define(descriptor, lambda)");
        return jsExpression;
    }

    public LiteralFunctionTranslator(@NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        super(context);
    }
}

