/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.components;

import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.load.java.components.JavaResolverCache;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaElement;
import org.jetbrains.kotlin.load.java.structure.JavaField;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaFieldImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaMethodImpl;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.resolve.lazy.ResolveSessionUtils;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyPackageDescriptor;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"W\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u00031\tA\u0002A\r\u00021\u0003\tk!C\u0002\t\u00035\t\u00014A)\u0004\u0003!\u0011Q%\u0003\u0003\u0002\u0011\u0013i!\u0001$\u0001\u0019\u000be\u0019\u00012B\u0007\u00021\u0019)\u0013\u0002B\u0006\t\u000e5\u0011A\u0012\u0001\r\u00063\rAq!D\u0001\u0019\r\u0015bAa\u0003E\b\u001b\u0005A\u0002\"G\u0002\t\u00125\t\u0001$C\r\u0004\u0011'i\u0011\u0001G\u0003&\u0019\u0011Y\u0001BC\u0007\u00021!I2\u0001#\u0006\u000e\u0003aY\u0011d\u0001E\n\u001b\u0005A:\"\n\u0007\u0005\u0017!aQ\"\u0001\r\t3\rAI\"D\u0001\u0019\u001be\u0019\u00012C\u0007\u000217)C\u0002B\u0006\t\u001d5\t\u0001\u0004C\r\u0004\u0011;i\u0011\u0001G\b\u001a\u0007!MQ\"\u0001M\u0010S\u001d!\u0011\t\u0003\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0002\u000b\u0001I#\u0002B!\t\u0011\u000bi\u0011\u0001G\u0002\u001dCE\u001b1!\u0004\u0002\u0005\b!!\u0001"}, strings={"Lorg/jetbrains/kotlin/load/java/components/LazyResolveBasedCache;", "Lorg/jetbrains/kotlin/load/java/components/JavaResolverCache;", "resolveSession", "Lorg/jetbrains/kotlin/resolve/lazy/ResolveSession;", "(Lorg/jetbrains/kotlin/resolve/lazy/ResolveSession;)V", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "getTrace", "()Lorg/jetbrains/kotlin/resolve/BindingTrace;", "findInPackageFragments", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "fullFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getClassResolvedFromSource", "fqName", "recordClass", "", "javaClass", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "descriptor", "recordConstructor", "element", "Lorg/jetbrains/kotlin/load/java/structure/JavaElement;", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "recordField", "field", "Lorg/jetbrains/kotlin/load/java/structure/JavaField;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "recordMethod", "method", "Lorg/jetbrains/kotlin/load/java/structure/JavaMethod;", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;"}, moduleName="kotlin-compiler")
public final class LazyResolveBasedCache
implements JavaResolverCache {
    private final ResolveSession resolveSession;

    private final BindingTrace getTrace() {
        BindingTrace bindingTrace = this.resolveSession.getTrace();
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "resolveSession.trace");
        return bindingTrace;
    }

    @Override
    @Nullable
    public ClassDescriptor getClassResolvedFromSource(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        ClassDescriptor classDescriptor = (ClassDescriptor)this.getTrace().get(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, fqName2.toUnsafe());
        if (classDescriptor == null) {
            classDescriptor = this.findInPackageFragments(fqName2);
        }
        return classDescriptor;
    }

    @Override
    public void recordMethod(@NotNull JavaMethod method, @NotNull SimpleFunctionDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(method, "method");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        JavaMethod javaMethod = method;
        if (javaMethod == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.load.java.structure.impl.JavaMethodImpl");
        }
        BindingContextUtils.recordFunctionDeclarationToDescriptor(this.getTrace(), ((JavaMethodImpl)javaMethod).getPsi(), descriptor2);
    }

    @Override
    public void recordConstructor(@NotNull JavaElement element, @NotNull ConstructorDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        JavaElement javaElement = element;
        if (javaElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.load.java.structure.impl.JavaElementImpl<*>");
        }
        this.getTrace().record(BindingContext.CONSTRUCTOR, ((JavaElementImpl)javaElement).getPsi(), descriptor2);
    }

    @Override
    public void recordField(@NotNull JavaField field, @NotNull PropertyDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(field, "field");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        JavaField javaField = field;
        if (javaField == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.load.java.structure.impl.JavaFieldImpl");
        }
        this.getTrace().record(BindingContext.VARIABLE, ((JavaFieldImpl)javaField).getPsi(), descriptor2);
    }

    @Override
    public void recordClass(@NotNull JavaClass javaClass, @NotNull ClassDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(javaClass, "javaClass");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        JavaClass javaClass2 = javaClass;
        if (javaClass2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl");
        }
        this.getTrace().record(BindingContext.CLASS, ((JavaClassImpl)javaClass2).getPsi(), descriptor2);
    }

    private final ClassDescriptor findInPackageFragments(FqName fullFqName) {
        LazyPackageDescriptor packageDescriptor;
        FqName fqName2;
        if (fullFqName.isRoot()) {
            fqName2 = fullFqName;
        } else {
            FqName fqName3 = fullFqName.parent();
            fqName2 = fqName3;
            Intrinsics.checkExpressionValueIsNotNull(fqName3, "fullFqName.parent()");
        }
        FqName fqName4 = fqName2;
        while ((packageDescriptor = this.resolveSession.getPackageFragment(fqName4)) != null) {
            ClassDescriptor result2 = ResolveSessionUtils.findClassByRelativePath(packageDescriptor.getMemberScope(), FqNamesUtilKt.tail(fullFqName, fqName4));
            if (result2 != null) {
                return result2;
            }
            if (fqName4.isRoot()) break;
            Intrinsics.checkExpressionValueIsNotNull(fqName4.parent(), "fqName.parent()");
        }
        return null;
    }

    public LazyResolveBasedCache(@NotNull ResolveSession resolveSession2) {
        Intrinsics.checkParameterIsNotNull(resolveSession2, "resolveSession");
        this.resolveSession = resolveSession2;
    }
}

