/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.components;

import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.load.java.JavaBindingContext;
import org.jetbrains.kotlin.load.java.components.ExternalSignatureResolver;
import org.jetbrains.kotlin.load.java.structure.JavaConstructor;
import org.jetbrains.kotlin.load.java.structure.JavaField;
import org.jetbrains.kotlin.load.java.structure.JavaMember;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.jvm.JavaDescriptorResolverKt;
import org.jetbrains.kotlin.resolve.jvm.kotlinSignature.AlternativeFieldSignatureData;
import org.jetbrains.kotlin.resolve.jvm.kotlinSignature.AlternativeMethodSignatureData;
import org.jetbrains.kotlin.resolve.jvm.kotlinSignature.SignaturesPropagationData;
import org.jetbrains.kotlin.types.KotlinType;

public class TraceBasedExternalSignatureResolver
implements ExternalSignatureResolver {
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final Project project;

    public TraceBasedExternalSignatureResolver(@NotNull Project project, @NotNull BindingTrace trace) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "<init>"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "<init>"));
        }
        this.project = project;
        this.trace = trace;
    }

    @Override
    @NotNull
    public ExternalSignatureResolver.PropagatedMethodSignature resolvePropagatedSignature(@NotNull JavaMethod method, @NotNull ClassDescriptor owner, @NotNull KotlinType returnType2, @Nullable KotlinType receiverType, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<TypeParameterDescriptor> typeParameters) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolvePropagatedSignature"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolvePropagatedSignature"));
        }
        if (returnType2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolvePropagatedSignature"));
        }
        if (valueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolvePropagatedSignature"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolvePropagatedSignature"));
        }
        SignaturesPropagationData data = new SignaturesPropagationData(owner, returnType2, receiverType, valueParameters, typeParameters, method);
        ExternalSignatureResolver.PropagatedMethodSignature propagatedMethodSignature = new ExternalSignatureResolver.PropagatedMethodSignature(data.getModifiedReturnType(), data.getModifiedReceiverType(), data.getModifiedValueParameters(), data.getModifiedTypeParameters(), data.getSignatureErrors(), data.getModifiedHasStableParameterNames(), data.getSuperFunctions());
        if (propagatedMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolvePropagatedSignature"));
        }
        return propagatedMethodSignature;
    }

    @Override
    @NotNull
    public ExternalSignatureResolver.AlternativeMethodSignature resolveAlternativeMethodSignature(@NotNull JavaMember methodOrConstructor, boolean hasSuperMethods, @Nullable KotlinType returnType2, @Nullable KotlinType receiverType, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<TypeParameterDescriptor> typeParameters, boolean hasStableParameterNames) {
        if (methodOrConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodOrConstructor", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolveAlternativeMethodSignature"));
        }
        if (valueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolveAlternativeMethodSignature"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolveAlternativeMethodSignature"));
        }
        assert (methodOrConstructor instanceof JavaMethod || methodOrConstructor instanceof JavaConstructor) : "Not a method or a constructor: " + methodOrConstructor.getName();
        AlternativeMethodSignatureData data = new AlternativeMethodSignatureData(methodOrConstructor, receiverType, this.project, valueParameters, returnType2, typeParameters, hasSuperMethods);
        if (data.isAnnotated() && !data.hasErrors()) {
            if (JavaDescriptorResolverKt.getPLATFORM_TYPES()) {
                ExternalSignatureResolver.AlternativeMethodSignature alternativeMethodSignature = new ExternalSignatureResolver.AlternativeMethodSignature(returnType2, receiverType, valueParameters, typeParameters, Collections.<String>emptyList(), hasStableParameterNames);
                if (alternativeMethodSignature == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolveAlternativeMethodSignature"));
                }
                return alternativeMethodSignature;
            }
            ExternalSignatureResolver.AlternativeMethodSignature alternativeMethodSignature = new ExternalSignatureResolver.AlternativeMethodSignature(data.getReturnType(), receiverType, data.getValueParameters(), data.getTypeParameters(), Collections.<String>emptyList(), true);
            if (alternativeMethodSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolveAlternativeMethodSignature"));
            }
            return alternativeMethodSignature;
        }
        List<String> error = data.hasErrors() ? Collections.singletonList(data.getError()) : Collections.emptyList();
        ExternalSignatureResolver.AlternativeMethodSignature alternativeMethodSignature = new ExternalSignatureResolver.AlternativeMethodSignature(returnType2, receiverType, valueParameters, typeParameters, error, hasStableParameterNames);
        if (alternativeMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolveAlternativeMethodSignature"));
        }
        return alternativeMethodSignature;
    }

    @Override
    @NotNull
    public ExternalSignatureResolver.AlternativeFieldSignature resolveAlternativeFieldSignature(@NotNull JavaField field, @NotNull KotlinType returnType2, boolean isVar) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolveAlternativeFieldSignature"));
        }
        if (returnType2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolveAlternativeFieldSignature"));
        }
        AlternativeFieldSignatureData data = new AlternativeFieldSignatureData(field, returnType2, this.project, isVar);
        if (data.isAnnotated() && !data.hasErrors()) {
            if (JavaDescriptorResolverKt.getPLATFORM_TYPES()) {
                ExternalSignatureResolver.AlternativeFieldSignature alternativeFieldSignature = new ExternalSignatureResolver.AlternativeFieldSignature(returnType2, null);
                if (alternativeFieldSignature == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolveAlternativeFieldSignature"));
                }
                return alternativeFieldSignature;
            }
            ExternalSignatureResolver.AlternativeFieldSignature alternativeFieldSignature = new ExternalSignatureResolver.AlternativeFieldSignature(data.getReturnType(), null);
            if (alternativeFieldSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolveAlternativeFieldSignature"));
            }
            return alternativeFieldSignature;
        }
        String error = data.hasErrors() ? data.getError() : null;
        ExternalSignatureResolver.AlternativeFieldSignature alternativeFieldSignature = new ExternalSignatureResolver.AlternativeFieldSignature(returnType2, error);
        if (alternativeFieldSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolveAlternativeFieldSignature"));
        }
        return alternativeFieldSignature;
    }

    @Override
    public void reportSignatureErrors(@NotNull CallableMemberDescriptor descriptor2, @NotNull List<String> signatureErrors) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "reportSignatureErrors"));
        }
        if (signatureErrors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signatureErrors", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "reportSignatureErrors"));
        }
        this.trace.record(JavaBindingContext.LOAD_FROM_JAVA_SIGNATURE_ERRORS, descriptor2.getOriginal(), signatureErrors);
    }
}

