/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.impl.ClassDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PackageFragmentDescriptorImpl;
import org.jetbrains.kotlin.load.kotlin.BuiltInClassesAreSerializableOnJvm;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.platform.JvmBuiltIns;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.serialization.deserialization.AdditionalSupertypes;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedClassDescriptor;
import org.jetbrains.kotlin.types.DelegatingType;
import org.jetbrains.kotlin.types.KotlinType;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"1\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!yQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\f\u0015\u0001Q!\u0001\u0007\u0002\u0019\u0001I\u0012\u0001'\u0001\"\u000e%\u0019\u0001\"A\u0007\u00021\u0007\t6!\u0001\u0005\u0003K\u0011!\u0011\u0001c\u0002\u000e\u0003a\u0019Qe\u0003\u0003\f\u0011\u0011iA!\u0003\u0002\n\u0003a\u0019\u0001\u0014B\r\u0004\u0011\u0015i\u0011\u0001g\u0003&\u0011\u0011\t\u0001BB\u0007\u00021\u001bI2\u0001C\u0004\u000e\u0003a=\u0011f\u0002\u0003B\u0011!\u0015Q\"\u0001\r\u0004#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001\"A\u0007\u00021\u0007\t6!A\u0003\u0001"}, strings={"Lorg/jetbrains/kotlin/load/kotlin/BuiltInClassesAreSerializableOnJvm;", "Lorg/jetbrains/kotlin/serialization/deserialization/AdditionalSupertypes;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)V", "mockSerializableType", "Lorg/jetbrains/kotlin/types/KotlinType;", "createMockJavaIoSerializableType", "forClass", "", "classDescriptor", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedClassDescriptor;", "isSerializableInJava", "", "classFqName", "Lorg/jetbrains/kotlin/name/FqName;"}, moduleName="kotlin-compiler")
public final class BuiltInClassesAreSerializableOnJvm
implements AdditionalSupertypes {
    private final KotlinType mockSerializableType;
    private final ModuleDescriptor moduleDescriptor;

    private final KotlinType createMockJavaIoSerializableType() {
        PackageFragmentDescriptorImpl mockJavaIoPackageFragment2 = new PackageFragmentDescriptorImpl(this.moduleDescriptor, new FqName("java.io")){

            @NotNull
            public MemberScope.Empty getMemberScope() {
                return MemberScope.Empty.INSTANCE;
            }
        };
        List<createMockJavaIoSerializableType.superTypes.1> superTypes2 = CollectionsKt.listOf(new DelegatingType(){

            @NotNull
            protected KotlinType getDelegate() {
                KotlinType kotlinType = JvmBuiltIns.Companion.getInstance().getAnyType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "JvmBuiltIns.Instance.anyType");
                return kotlinType;
            }
        });
        ClassDescriptorImpl mockSerializableClass = new ClassDescriptorImpl(mockJavaIoPackageFragment2, Name.identifier("Serializable"), Modality.ABSTRACT, (Collection<KotlinType>)superTypes2, SourceElement.NO_SOURCE);
        mockSerializableClass.initialize(MemberScope.Empty.INSTANCE, SetsKt.<ConstructorDescriptor>emptySet(), null);
        KotlinType kotlinType = mockSerializableClass.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "mockSerializableClass.defaultType");
        return kotlinType;
    }

    @Override
    @NotNull
    public Collection<KotlinType> forClass(@NotNull DeserializedClassDescriptor classDescriptor) {
        Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
        if (this.isSerializableInJava(DescriptorUtilsKt.getFqNameSafe(classDescriptor))) {
            return CollectionsKt.listOf(this.mockSerializableType);
        }
        return CollectionsKt.listOf();
    }

    private final boolean isSerializableInJava(FqName classFqName) {
        Class<?> clazz;
        FqNameUnsafe fqNameUnsafe = classFqName.toUnsafe();
        if (Intrinsics.areEqual(fqNameUnsafe, KotlinBuiltIns.FQ_NAMES.array) || KotlinBuiltIns.isPrimitiveArray(fqNameUnsafe)) {
            return true;
        }
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqNameUnsafe);
        if (classId == null) {
            return false;
        }
        ClassId javaClassId = classId;
        try {
            clazz = Class.forName(javaClassId.asSingleFqName().asString());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        Class<?> classViaReflection = clazz;
        return Serializable.class.isAssignableFrom(classViaReflection);
    }

    public BuiltInClassesAreSerializableOnJvm(@NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkParameterIsNotNull(moduleDescriptor, "moduleDescriptor");
        this.moduleDescriptor = moduleDescriptor;
        this.mockSerializableType = this.createMockJavaIoSerializableType();
    }
}

