/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DeclarationChecker;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={")\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\r\u0001e\t\u0001\u0014AQ\u0003#\u000e\t\u0001\"A\u0013\u0015\t-A\u0019!D\u0001\u0019\u0005e\u0019\u0001RA\u0007\u00021\rI2\u0001c\u0002\u000e\u0003a!\u0011d\u0001E\u0005\u001b\u0005AR!G\u0002\t\f5\t\u0001D\u0002"}, strings={"Lorg/jetbrains/kotlin/resolve/DataClassAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;"}, moduleName="kotlin-compiler")
public final class DataClassAnnotationChecker
implements DeclarationChecker {
    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext2, "bindingContext");
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return;
        }
        if (!(declaration instanceof KtClassOrObject)) {
            return;
        }
        if (((ClassDescriptor)descriptor2).isData()) {
            List<KtParameter> parameters2;
            KtPrimaryConstructor primaryConstructor2;
            List<KtParameter> list;
            if (((ClassDescriptor)descriptor2).getUnsubstitutedPrimaryConstructor() == null && CollectionsKt.isNotEmpty(((ClassDescriptor)descriptor2).getConstructors())) {
                Unit unit;
                PsiElement psiElement2 = ((KtClassOrObject)declaration).getNameIdentifier();
                if (psiElement2 != null) {
                    void $receiver;
                    PsiElement psiElement3 = psiElement2;
                    PsiElement it = (PsiElement)$receiver;
                    diagnosticHolder.report(Errors.PRIMARY_CONSTRUCTOR_REQUIRED_FOR_DATA_CLASS.on(it));
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
            if ((list = (primaryConstructor2 = ((KtClassOrObject)declaration).getPrimaryConstructor())) == null || (list = ((KtConstructor)((Object)list)).getValueParameters()) == null) {
                list = parameters2 = CollectionsKt.emptyList();
            }
            if (parameters2.isEmpty()) {
                Unit unit;
                PsiElement psiElement3 = ((KtClassOrObject)declaration).getNameIdentifier();
                if (psiElement3 != null) {
                    void $receiver;
                    PsiElement $i$a$1 = psiElement3;
                    PsiElement it = (PsiElement)$receiver;
                    diagnosticHolder.report(Errors.DATA_CLASS_WITHOUT_PARAMETERS.on(it));
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
            for (KtParameter parameter : parameters2) {
                if (parameter.isVarArg()) {
                    diagnosticHolder.report(Errors.DATA_CLASS_VARARG_PARAMETER.on((KtParameter)((PsiElement)parameter)));
                }
                if (parameter.hasValOrVar()) continue;
                diagnosticHolder.report(Errors.DATA_CLASS_NOT_PROPERTY_PARAMETER.on((KtParameter)((PsiElement)parameter)));
            }
        }
    }
}

