/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.DescriptorEquivalenceForOverrides;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"3\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!-Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001!1-\u0001\u0007\u00013\u0005A\n!i\u0002\u0005\u0003E\u001b\u0011\u0001C\u0001&\u0019\u0011\t\u00012A\u0007\u00021\tI2\u0001#\u0002\u000e\u0003a\u0019\u0011d\u0001E\u0004\u001b\u0005A2!\n\u0007\u0005\u0003!!Q\"\u0001\r\u00033\rA)!D\u0001\u0019\ne\u0019\u0001rA\u0007\u00021\u0013)S\u0002C\u0003\u000e\u0003a\u0011\u0011\u0004\u0002E\u0003\u001b\ta\t\u0001g\u0003\u001a\t!\u001dQB\u0001G\u00011\u0017)C\u0004B\u0001\t\r5\t\u0001DA\r\u0004\u0011\u000bi\u0011\u0001'\u0004\u001a\u0007!\u001dQ\"\u0001M\u00073=!\u0011\u0001C\u0004\u000e\u0019%\u0019\u0011B\u0001G\u00011\u0017I1!\u0003\u0002\r\u0002a-\u0011BA\u0005\u00021\tAz!J\u000e\u0005\u0003!AQ\"\u0001\r\u00033\rA)!D\u0001\u0019\fe\u0019\u0001rA\u0007\u00021\u0017Ib\u0002C\u0004\u000e\u0019%\u0019\u0011B\u0001G\u00011\u0017I1!\u0003\u0002\r\u0002a-\u0011BA\u0005\u00021\tAz\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/DescriptorEquivalenceForOverrides;", "", "()V", "areCallableMemberDescriptorsEquivalent", "", "a", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "b", "areClassesEquivalent", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "areEquivalent", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "areTypeParametersEquivalent", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "equivalentCallables", "Lkotlin/Function2;", "ownersEquivalent"}, moduleName="kotlin-compiler")
public final class DescriptorEquivalenceForOverrides {
    public static final DescriptorEquivalenceForOverrides INSTANCE;
    public static final DescriptorEquivalenceForOverrides INSTANCE$;

    public final boolean areEquivalent(@Nullable DeclarationDescriptor a, @Nullable DeclarationDescriptor b) {
        return a instanceof ClassDescriptor && b instanceof ClassDescriptor ? this.areClassesEquivalent((ClassDescriptor)a, (ClassDescriptor)b) : (a instanceof TypeParameterDescriptor && b instanceof TypeParameterDescriptor ? DescriptorEquivalenceForOverrides.areTypeParametersEquivalent$default(this, (TypeParameterDescriptor)a, (TypeParameterDescriptor)b, null, 4) : (a instanceof CallableMemberDescriptor && b instanceof CallableMemberDescriptor ? this.areCallableMemberDescriptorsEquivalent((CallableMemberDescriptor)a, (CallableMemberDescriptor)b) : (a instanceof PackageFragmentDescriptor && b instanceof PackageFragmentDescriptor ? Intrinsics.areEqual(((PackageFragmentDescriptor)a).getFqName(), ((PackageFragmentDescriptor)b).getFqName()) : Intrinsics.areEqual(a, b))));
    }

    private final boolean areClassesEquivalent(ClassDescriptor a, ClassDescriptor b) {
        return Intrinsics.areEqual(a.getTypeConstructor(), b.getTypeConstructor());
    }

    private final boolean areTypeParametersEquivalent(TypeParameterDescriptor a, TypeParameterDescriptor b, Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, ? extends Boolean> equivalentCallables) {
        if (Intrinsics.areEqual(a, b)) {
            return true;
        }
        if (Intrinsics.areEqual(a.getContainingDeclaration(), b.getContainingDeclaration())) {
            return false;
        }
        if (!this.ownersEquivalent(a, b, equivalentCallables)) {
            return false;
        }
        return a.getIndex() == b.getIndex();
    }

    static /* bridge */ /* synthetic */ boolean areTypeParametersEquivalent$default(DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides, TypeParameterDescriptor typeParameterDescriptor, TypeParameterDescriptor typeParameterDescriptor2, Function2 function2, int n) {
        if ((n & 4) != 0) {
            function2 = areTypeParametersEquivalent.1.INSTANCE;
        }
        return descriptorEquivalenceForOverrides.areTypeParametersEquivalent(typeParameterDescriptor, typeParameterDescriptor2, function2);
    }

    private final boolean areCallableMemberDescriptorsEquivalent(CallableMemberDescriptor a, CallableMemberDescriptor b) {
        if (Intrinsics.areEqual(a, b)) {
            return true;
        }
        if (Intrinsics.areEqual(a.getName(), b.getName()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual(a.getContainingDeclaration(), b.getContainingDeclaration())) {
            return false;
        }
        if (DescriptorUtils.isLocal(a) || DescriptorUtils.isLocal(b)) {
            return false;
        }
        if (!this.ownersEquivalent(a, b, areCallableMemberDescriptorsEquivalent.1.INSTANCE)) {
            return false;
        }
        OverridingUtil overridingUtil2 = OverridingUtil.createWithEqualityAxioms(new KotlinTypeChecker.TypeConstructorEquality(a, b){
            final /* synthetic */ CallableMemberDescriptor $a;
            final /* synthetic */ CallableMemberDescriptor $b;

            public final boolean invoke(@NotNull TypeConstructor c1, @NotNull TypeConstructor c2) {
                Intrinsics.checkParameterIsNotNull(c1, "c1");
                Intrinsics.checkParameterIsNotNull(c2, "c2");
                if (Intrinsics.areEqual(c1, c2)) {
                    return true;
                }
                ClassifierDescriptor d1 = c1.getDeclarationDescriptor();
                ClassifierDescriptor d2 = c2.getDeclarationDescriptor();
                if (!(d1 instanceof TypeParameterDescriptor) || !(d2 instanceof TypeParameterDescriptor)) {
                    return false;
                }
                return DescriptorEquivalenceForOverrides.access$areTypeParametersEquivalent(DescriptorEquivalenceForOverrides.INSTANCE, (TypeParameterDescriptor)d1, (TypeParameterDescriptor)d2, (Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, ? extends Boolean>)new Function2<DeclarationDescriptor, DeclarationDescriptor, Boolean>(this){
                    final /* synthetic */ areCallableMemberDescriptorsEquivalent.overridingUtil.1 this$0;

                    public final boolean invoke(@Nullable DeclarationDescriptor x, @Nullable DeclarationDescriptor y) {
                        return Intrinsics.areEqual(x, this.this$0.$a) && Intrinsics.areEqual(y, this.this$0.$b);
                    }
                    {
                        this.this$0 = var1_1;
                        super(2);
                    }
                });
            }
            {
                this.$a = callableMemberDescriptor;
                this.$b = callableMemberDescriptor2;
            }
        });
        return Intrinsics.areEqual((Object)overridingUtil2.isOverridableByIncludingReturnType(a, b).getResult(), (Object)OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE) && Intrinsics.areEqual((Object)overridingUtil2.isOverridableByIncludingReturnType(b, a).getResult(), (Object)OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE);
    }

    private final boolean ownersEquivalent(DeclarationDescriptor a, DeclarationDescriptor b, Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, ? extends Boolean> equivalentCallables) {
        DeclarationDescriptor aOwner = a.getContainingDeclaration();
        DeclarationDescriptor bOwner = b.getContainingDeclaration();
        if (aOwner instanceof CallableMemberDescriptor || bOwner instanceof CallableMemberDescriptor) {
            return equivalentCallables.invoke(aOwner, bOwner);
        }
        return this.areEquivalent(aOwner, bOwner);
    }

    static {
        new DescriptorEquivalenceForOverrides();
    }

    private DescriptorEquivalenceForOverrides() {
        INSTANCE = this;
        INSTANCE$ = this;
    }

    public static final /* synthetic */ boolean access$areTypeParametersEquivalent(DescriptorEquivalenceForOverrides $this, @NotNull TypeParameterDescriptor a, @NotNull TypeParameterDescriptor b, @NotNull Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, ? extends Boolean> equivalentCallables) {
        return $this.areTypeParametersEquivalent(a, b, equivalentCallables);
    }
}

