/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.descriptorUtil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.PreconditionsKt;
import kotlin.Sequence;
import kotlin.SequencesKt;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.utils.DFS;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"\u007f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001c\u0003\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0005!!!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0019\u0005)\u0011\u0001\"\u0002\u0006\u0003!\u0001R!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0005!)!B\u0001\r\u00035=\u0001rF\u0007\u0003\u0019\u0003A\u0002$F\u0001\u00192Q\u001b)!$\u0004\t35\t\u0001\u0004B\u000b\u00021\u0011!6QAG\u0007\u0011gi\u0011\u0001G\u0001\u0016\u0003a\tAk!\u0002\u000e\u0010!QRB\u0001G\u00011\u0005)\u0012\u0001'\u000eU\u0007\u000biy\u0001C\u000e\u000e\u00051\u0005\u0001\u0004B\u000b\u00021\u0011!6QAG\u0007\u0011oi\u0011\u0001\u0007\u0003\u0016\u0003a!Ak!\u0002\u000e\u000e!aR\"\u0001\r\r+\u0005AJ\u0004VB\u0003\u001b\u001bAQ$D\u0001\u0019\u0019U\t\u0001\u0014\u0007+\u0004\u000655\u00012H\u0007\u000211)\u0012\u0001'\rU\u0007\u000bi)\u0003\u0003\u0010\u000e\u00051\u0005\u0001\u0004B\u000b\u00021CIJ\u0001#\u0010\u000e\u0003aA\u0001k!\u0001\u001a\n!yR\"\u0001M !\u000e\tAk!\u0002\u0012\u001c\u0011\u0019\u0005\u0002\u0003\u0001\u000e\u0003a\u0005Q#\u0001\r\u00029\r\n6aA\u0007\u0003\t\u0007A!\u0001VB\u0003#7!1\t\u0003\u0005\u0004\u001b\u0005A:!F\u0001\u0019\tq\u0019\u0013kA\u0002\u000e\u0005\u0011%\u0001\"\u0002+\u0004\u0006EuAa\u0011\u0005\t\f5\u0011A\u0012\u0001\r\u0007+\u0005AB\u0001H\u0012R\u0007\ri!\u0001\"\u0004\t\u000fQ\u001b)!e\u0007\u0005\u0007\"Ay!D\u0001\u0019\u0011U\t\u0001$\u0001\u000f$#\u000e\u0019QB\u0001C\t\u0011%!6QAI\u000e\t\rC\u00012C\u0007\u00021))\u0012\u0001G\u0001\u001dGE\u001b1!\u0004\u0002\u0005\u0016!YAk!\u0002\u0012\u001c\u0011\u0019\u0005\u0002c\u0006\u000e\u0003aaQ#\u0001\r\u00059\r\n6aA\u0007\u0003\t3AQ\u0002VB\u0003#7!1\t\u0003E\u000e\u001b\u0005AB\"F\u0001\u0019\u001dq\u0019\u0013kA\u0002\u000e\u0005\u0011m\u0001R\u0004+\u0004\u0006EmAa\u0011\u0005\t\u001f5\t\u0001\u0004D\u000b\u00021\u0005a2%U\u0002\u0004\u001b\t!q\u0002c\bU\u0007\u000b\tZ\u0002B\"\t\u0011Ai\u0011\u0001'\t\u0016\u0003a\tAdI)\u0004\u00075\u0011A!\u0005E\u0012)\u000e\u0015\u0011\u0013\u0005\u0003D\u0011!\u0011R\u0002B\u0005\u0003\u0013\u0005A\u0012\u0001'\n\u0016\u0003a\tAdI)\u0004\u00075\u0011Aa\u0005E\u0014)\u000e\u0015\u0011\u0013\u0005\u0003D\u0011!!R\u0002B\u0005\u0003\u0013\u0005A\u0012\u0001'\n\u0016\u0003a\tAdI)\u0004\u00075\u0011A\u0011\u0006E\u0014)\u000e\u0015\u0011\u0013\u0005\u0003D\u0011!)R\u0002B\u0005\u0003\u0013\u0005Ab\u0003g\u000b\u0016\u0003a!AdI)\u0004\u00075\u0011AQ\u0006\u0005\u0018)\u000e\u0015\u0001"}, strings={"builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getBuiltIns", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "DescriptorUtilsKt", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getClassId", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)Lorg/jetbrains/kotlin/name/ClassId;", "classObjectType", "Lorg/jetbrains/kotlin/types/KotlinType;", "getClassObjectType", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)Lorg/jetbrains/kotlin/types/KotlinType;", "fqNameSafe", "Lorg/jetbrains/kotlin/name/FqName;", "getFqNameSafe", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/name/FqName;", "fqNameUnsafe", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "getFqNameUnsafe", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "hasClassObjectType", "", "getHasClassObjectType", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)Z", "isEffectivelyPublicApi", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;)Z", "isExtension", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getModule", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "parents", "Lkotlin/Sequence;", "getParents", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lkotlin/Sequence;", "parentsWithSelf", "getParentsWithSelf", "secondaryConstructors", "", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "getSecondaryConstructors", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)Ljava/util/List;", "getAnnotationRetention", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinRetention;", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotated;", "getClassObjectReferenceTarget", "getImportableDescriptor", "getOwnerForEffectiveDispatchReceiverParameter", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getSuperClassNotAny", "getSuperClassOrAny", "hasDefaultValue", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "isDocumentedAnnotation", "isRepeatableAnnotation", "resolveTopLevelClass", "topLevelClassFqName", "location", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;"}, moduleName="kotlin-compiler")
public final class DescriptorUtilsKt {
    @NotNull
    public static final ClassDescriptor getClassObjectReferenceTarget(ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassDescriptor classDescriptor = $receiver.getCompanionObjectDescriptor();
        if (classDescriptor == null) {
            classDescriptor = $receiver;
        }
        return classDescriptor;
    }

    @NotNull
    public static final DeclarationDescriptor getImportableDescriptor(DeclarationDescriptor $receiver) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver instanceof ConstructorDescriptor) {
            DeclarationDescriptor declarationDescriptor2 = ((ConstructorDescriptor)$receiver).getContainingDeclaration();
            declarationDescriptor = declarationDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor2, "getContainingDeclaration()");
        } else if ($receiver instanceof PropertyAccessorDescriptor) {
            DeclarationDescriptor declarationDescriptor3 = ((PropertyAccessorDescriptor)$receiver).getCorrespondingProperty();
            declarationDescriptor = declarationDescriptor3;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor3, "getCorrespondingProperty()");
        } else {
            declarationDescriptor = $receiver;
        }
        return declarationDescriptor;
    }

    @NotNull
    public static final FqNameUnsafe getFqNameUnsafe(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName($receiver);
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe, "DescriptorUtils.getFqName(this)");
        return fqNameUnsafe;
    }

    @NotNull
    public static final FqName getFqNameSafe(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        FqName fqName2 = DescriptorUtils.getFqNameSafe($receiver);
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "DescriptorUtils.getFqNameSafe(this)");
        return fqName2;
    }

    public static final boolean isExtension(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver instanceof CallableDescriptor && ((CallableDescriptor)$receiver).getExtensionReceiverParameter() != null;
    }

    @NotNull
    public static final ModuleDescriptor getModule(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule($receiver);
        Intrinsics.checkExpressionValueIsNotNull(moduleDescriptor, "DescriptorUtils.getContainingModule(this)");
        return moduleDescriptor;
    }

    @Nullable
    public static final ClassDescriptor resolveTopLevelClass(ModuleDescriptor $receiver, @NotNull FqName topLevelClassFqName, @NotNull LookupLocation location2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(topLevelClassFqName, "topLevelClassFqName");
        Intrinsics.checkParameterIsNotNull(location2, "location");
        PreconditionsKt.assert(!topLevelClassFqName.isRoot());
        FqName fqName2 = topLevelClassFqName.parent();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "topLevelClassFqName.parent()");
        MemberScope memberScope2 = $receiver.getPackage(fqName2).getMemberScope();
        Name name = topLevelClassFqName.shortName();
        Intrinsics.checkExpressionValueIsNotNull(name, "topLevelClassFqName.shortName()");
        ClassifierDescriptor classifierDescriptor = memberScope2.getContributedClassifier(name, location2);
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        return (ClassDescriptor)classifierDescriptor;
    }

    @NotNull
    public static final ClassId getClassId(ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        DeclarationDescriptor owner = $receiver.getContainingDeclaration();
        if (owner instanceof PackageFragmentDescriptor) {
            return new ClassId(((PackageFragmentDescriptor)owner).getFqName(), $receiver.getName());
        }
        if (owner instanceof ClassDescriptor) {
            ClassId classId = DescriptorUtilsKt.getClassId((ClassDescriptor)owner).createNestedClassId($receiver.getName());
            Intrinsics.checkExpressionValueIsNotNull(classId, "owner.classId.createNestedClassId(getName())");
            return classId;
        }
        throw (Throwable)new IllegalStateException("Illegal container: " + owner);
    }

    public static final boolean getHasClassObjectType(ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return DescriptorUtilsKt.getClassObjectType($receiver) != null;
    }

    @Nullable
    public static final KotlinType getClassObjectType(ClassDescriptor $receiver) {
        ClassDescriptor correspondingDescriptor;
        ClassDescriptor classDescriptor;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassKind classKind = $receiver.getKind();
        if (Intrinsics.areEqual((Object)classKind, (Object)ClassKind.OBJECT)) {
            classDescriptor = $receiver;
        } else if (Intrinsics.areEqual((Object)classKind, (Object)ClassKind.ENUM_ENTRY)) {
            DeclarationDescriptor container = $receiver.getContainingDeclaration();
            PreconditionsKt.assert(container instanceof ClassDescriptor && Intrinsics.areEqual((Object)((ClassDescriptor)container).getKind(), (Object)ClassKind.ENUM_CLASS));
            DeclarationDescriptor declarationDescriptor = container;
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            classDescriptor = (ClassDescriptor)declarationDescriptor;
        } else {
            classDescriptor = $receiver.getCompanionObjectDescriptor();
        }
        ClassDescriptor classDescriptor2 = correspondingDescriptor = classDescriptor;
        return classDescriptor2 != null ? classDescriptor2.getDefaultType() : null;
    }

    public static final boolean isEffectivelyPublicApi(DeclarationDescriptorWithVisibility $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        DeclarationDescriptorWithVisibility parent2 = $receiver;
        while (parent2 != null) {
            if (!parent2.getVisibility().isPublicAPI()) {
                return false;
            }
            parent2 = DescriptorUtils.getParentOfType(parent2, DeclarationDescriptorWithVisibility.class);
        }
        return true;
    }

    @Nullable
    public static final ClassDescriptor getSuperClassNotAny(ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        for (KotlinType supertype : $receiver.getDefaultType().getConstructor().getSupertypes()) {
            ClassifierDescriptor superClassifier = supertype.getConstructor().getDeclarationDescriptor();
            if (KotlinBuiltIns.isAnyOrNullableAny(supertype) || !DescriptorUtils.isClass(superClassifier) && !DescriptorUtils.isEnumClass(superClassifier)) continue;
            ClassifierDescriptor classifierDescriptor = superClassifier;
            if (classifierDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            return (ClassDescriptor)classifierDescriptor;
        }
        return null;
    }

    @NotNull
    public static final ClassDescriptor getSuperClassOrAny(ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getSuperClassNotAny($receiver);
        if (classDescriptor == null) {
            ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getBuiltIns($receiver).getAny();
            classDescriptor = classDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "builtIns.getAny()");
        }
        return classDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ConstructorDescriptor> getSecondaryConstructors(ClassDescriptor $receiver) {
        void var3_3;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Iterable $receiver3 = $receiver.getConstructors();
        Iterable iterable = $receiver3;
        Collection destination = new ArrayList();
        for (Object element : $receiver2) {
            ConstructorDescriptor it = (ConstructorDescriptor)element;
            if (it.isPrimary()) continue;
            destination.add(element);
        }
        return (List)var3_3;
    }

    @NotNull
    public static final KotlinBuiltIns getBuiltIns(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return DescriptorUtilsKt.getModule($receiver).getBuiltIns();
    }

    @Nullable
    public static final DeclarationDescriptor getOwnerForEffectiveDispatchReceiverParameter(CallableDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver instanceof CallableMemberDescriptor && Intrinsics.areEqual((Object)((CallableMemberDescriptor)$receiver).getKind(), (Object)CallableMemberDescriptor.Kind.FAKE_OVERRIDE)) {
            return ((CallableMemberDescriptor)$receiver).getContainingDeclaration();
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = $receiver.getDispatchReceiverParameter();
        return receiverParameterDescriptor != null ? receiverParameterDescriptor.getContainingDeclaration() : null;
    }

    public static final boolean hasDefaultValue(ValueParameterDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        DFS.AbstractNodeHandler<ValueParameterDescriptor, Boolean> handler2 = new DFS.AbstractNodeHandler<ValueParameterDescriptor, Boolean>(){
            private boolean result;

            public final boolean getResult() {
                return this.result;
            }

            public final void setResult(boolean bl) {
                this.result = bl;
            }

            public boolean beforeChildren(@NotNull ValueParameterDescriptor current) {
                Intrinsics.checkParameterIsNotNull(current, "current");
                this.result = this.result || current.declaresDefaultValue();
                return !this.result;
            }

            @NotNull
            public Boolean result() {
                return this.result;
            }
        };
        DFS.dfs((Collection)CollectionsKt.listOf($receiver), hasDefaultValue.1.INSTANCE, handler2);
        return handler2.result();
    }

    public static final boolean isRepeatableAnnotation(Annotated $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Annotations annotations2 = $receiver.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.repeatable;
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "KotlinBuiltIns.FQ_NAMES.repeatable");
        return annotations2.findAnnotation(fqName2) != null;
    }

    public static final boolean isDocumentedAnnotation(Annotated $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Annotations annotations2 = $receiver.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.mustBeDocumented;
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "KotlinBuiltIns.FQ_NAMES.mustBeDocumented");
        return annotations2.findAnnotation(fqName2) != null;
    }

    @Nullable
    public static final KotlinRetention getAnnotationRetention(Annotated $receiver) {
        Object v3;
        block4: {
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            Annotations annotations2 = $receiver.getAnnotations();
            FqName fqName2 = KotlinBuiltIns.FQ_NAMES.retention;
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "KotlinBuiltIns.FQ_NAMES.retention");
            AnnotationDescriptor annotationDescriptor = annotations2.findAnnotation(fqName2);
            if (annotationDescriptor == null) {
                return null;
            }
            AnnotationDescriptor annotationEntryDescriptor = annotationDescriptor;
            Object $receiver2 = annotationEntryDescriptor.getAllValueArguments();
            $receiver2 = $receiver2.entrySet();
            Iterator iterator2 = $receiver2.iterator();
            while (iterator2.hasNext()) {
                Object element = iterator2.next();
                Map.Entry it = (Map.Entry)element;
                if (!Intrinsics.areEqual(((ValueParameterDescriptor)it.getKey()).getName().asString(), "value")) continue;
                v3 = element;
                break block4;
            }
            v3 = null;
        }
        Map.Entry entry = v3;
        ConstantValue constantValue = entry != null ? (ConstantValue)CollectionsKt.getValue(entry) : null;
        if (!(constantValue instanceof EnumValue)) {
            constantValue = null;
        }
        EnumValue enumValue = (EnumValue)constantValue;
        if (enumValue == null) {
            return null;
        }
        EnumValue retentionArgumentValue = enumValue;
        String string = ((ClassDescriptor)retentionArgumentValue.getValue()).getName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "retentionArgumentValue.value.name.asString()");
        return KotlinRetention.valueOf(string);
    }

    @NotNull
    public static final Sequence<DeclarationDescriptor> getParentsWithSelf(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return SequencesKt.sequence($receiver, (Function1)parentsWithSelf.1.INSTANCE);
    }

    @NotNull
    public static final Sequence<DeclarationDescriptor> getParents(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return SequencesKt.drop(DescriptorUtilsKt.getParentsWithSelf($receiver), 1);
    }
}

