/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes.receivers;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ThisReceiver;
import org.jetbrains.kotlin.types.KotlinType;

public class ScriptReceiver
implements ThisReceiver {
    private final ScriptDescriptor scriptDescriptor;

    public ScriptReceiver(@NotNull ScriptDescriptor scriptDescriptor) {
        if (scriptDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptDescriptor", "org/jetbrains/kotlin/resolve/scopes/receivers/ScriptReceiver", "<init>"));
        }
        this.scriptDescriptor = scriptDescriptor;
    }

    @Override
    @NotNull
    public ScriptDescriptor getDeclarationDescriptor() {
        ScriptDescriptor scriptDescriptor = this.scriptDescriptor;
        if (scriptDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/scopes/receivers/ScriptReceiver", "getDeclarationDescriptor"));
        }
        return scriptDescriptor;
    }

    @Override
    @NotNull
    public KotlinType getType() {
        KotlinType kotlinType = DescriptorUtilsKt.getBuiltIns(this.scriptDescriptor).getAnyType();
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/scopes/receivers/ScriptReceiver", "getType"));
        }
        return kotlinType;
    }

    @Override
    public boolean exists() {
        return true;
    }
}

