/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.rmi.service;

import java.io.Closeable;
import java.io.File;
import java.io.FilterInputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"#\u0015\u0001Q!\u0001\u0005\b\u000b\u0005!!!B\u0001\t\n\u0015\tAQA\u0003\u0002\u0011\u0017)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\n\u001b#AY!D\u0001\u0019\re\u0019\u0001RB\u0007\u00021\u001d!6AAG\u0007\u0011\u001fi\u0011\u0001\u0007\u0005\u0016\u0003a9Ak\u0001\u0002\u0012\u0019\u0011\u0019\u0005*\u0001\u0005\u0001\u001b\u0005A\n!U\u0002\u0005\u000b\u0001i!\u0001B\u0001\t\u0004Q\u001b!!\u0005\u0007\u0005\u0007\"\u000b\u0001RA\u0007\u00021\r\t6\u0001B\u0003\u0001\u001b\t!9\u0001\u0003\u0003U\u0007\t\tB\u0002B\"I\u0003!%Q\"\u0001\r\u0004#\u000e!Q\u0001A\u0007\u0003\t\u0015AA\u0001V\u0002\u0003"}, strings={"CLASSPATH_FILE_ID_DIGEST", "", "getCLASSPATH_FILE_ID_DIGEST", "()Ljava/lang/String;", "LazyClasspathWatcherKt", "DEFAULT_CLASSPATH_DIGEST_WATCH_PERIOD_MS", "", "getDEFAULT_CLASSPATH_DIGEST_WATCH_PERIOD_MS", "()J", "DEFAULT_CLASSPATH_WATCH_PERIOD_MS", "getDEFAULT_CLASSPATH_WATCH_PERIOD_MS", "isClasspathFile", "", "file", "Ljava/io/File;", "md5Digest", ""}, moduleName="kotlin-compiler")
public final class LazyClasspathWatcherKt {
    @NotNull
    private static final String CLASSPATH_FILE_ID_DIGEST = "MD5";
    private static final long DEFAULT_CLASSPATH_WATCH_PERIOD_MS = 1000L;
    private static final long DEFAULT_CLASSPATH_DIGEST_WATCH_PERIOD_MS = 300000L;

    @NotNull
    public static final String getCLASSPATH_FILE_ID_DIGEST() {
        return CLASSPATH_FILE_ID_DIGEST;
    }

    public static final long getDEFAULT_CLASSPATH_WATCH_PERIOD_MS() {
        return DEFAULT_CLASSPATH_WATCH_PERIOD_MS;
    }

    public static final long getDEFAULT_CLASSPATH_DIGEST_WATCH_PERIOD_MS() {
        return DEFAULT_CLASSPATH_DIGEST_WATCH_PERIOD_MS;
    }

    public static final boolean isClasspathFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        return file.isFile() && CollectionsKt.listOf("class", "jar").contains(StringsKt.toLowerCase(FilesKt.getExtension(file)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] md5Digest(File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        MessageDigest md = MessageDigest.getInstance(CLASSPATH_FILE_ID_DIGEST);
        Closeable $receiver2 = new DigestInputStream(FilesKt.inputStream($receiver), md);
        boolean closed = false;
        try {
            Object it2 = (DigestInputStream)$receiver2;
            byte[] buf = new byte[1024];
            while (((FilterInputStream)it2).read(buf) != -1) {
            }
            ((FilterInputStream)it2).close();
            it2 = Unit.INSTANCE;
        }
        catch (Exception e) {
            closed = true;
            try {
                $receiver2.close();
            }
            catch (Exception closeException) {
                // empty catch block
            }
            throw (Throwable)e;
        }
        finally {
            if (!closed) {
                $receiver2.close();
            }
        }
        byte[] byArray = md.digest();
        Intrinsics.checkExpressionValueIsNotNull(byArray, "md.digest()");
        return byArray;
    }

    static {
        CLASSPATH_FILE_ID_DIGEST = CLASSPATH_FILE_ID_DIGEST;
        DEFAULT_CLASSPATH_WATCH_PERIOD_MS = 1000L;
        DEFAULT_CLASSPATH_DIGEST_WATCH_PERIOD_MS = 300000L;
    }
}

