/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LanguageFileType
implements FileType {
    private final Language myLanguage;

    protected LanguageFileType(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/openapi/fileTypes/LanguageFileType", "<init>"));
        }
        this.myLanguage = language;
    }

    @NotNull
    public final Language getLanguage() {
        Language language = this.myLanguage;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/LanguageFileType", "getLanguage"));
        }
        return language;
    }

    @Override
    public final boolean isBinary() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/LanguageFileType", "getCharset"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileTypes/LanguageFileType", "getCharset"));
        }
        return null;
    }

    @Deprecated
    public boolean isJVMDebuggingSupported() {
        return false;
    }

    public Charset extractCharsetFromFileContent(@Nullable Project project, @Nullable VirtualFile file, @NotNull String content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileTypes/LanguageFileType", "extractCharsetFromFileContent"));
        }
        return null;
    }

    public Charset extractCharsetFromFileContent(@Nullable Project project, @Nullable VirtualFile file, @NotNull CharSequence content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileTypes/LanguageFileType", "extractCharsetFromFileContent"));
        }
        return this.extractCharsetFromFileContent(project, file, content.toString());
    }
}

