/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import org.jetbrains.annotations.Nullable;

public class ExternallyRenamedChange
extends Change {
    private String myRenamedTargetName;
    private boolean myCopied;
    private final String myOriginUrl;

    public ExternallyRenamedChange(ContentRevision beforeRevision, ContentRevision afterRevision, String originUrl) {
        super(beforeRevision, afterRevision);
        this.myOriginUrl = originUrl;
        this.myCopied = true;
    }

    public void setRenamedOrMovedTarget(FilePath target) {
        this.myRenamed = false;
        this.myMoved = false;
        if (this.getBeforeRevision() != null || this.getAfterRevision() == null) {
            return;
        }
        FilePath localPath = ChangesUtil.getFilePath(this);
        if (localPath.getIOFile().getAbsolutePath().equals(target.getIOFile().getAbsolutePath())) {
            return;
        }
        if (Comparing.equal((Object)target.getParentPath(), (Object)localPath.getParentPath())) {
            this.myRenamed = true;
        } else {
            this.myMoved = true;
        }
        this.myCopied = false;
        this.myRenamedTargetName = target.getName();
        this.myRenameOrMoveCached = true;
    }

    @Override
    public String getOriginText(Project project) {
        if (this.myCopied) {
            return VcsBundle.message("change.file.copied.from.text", this.myOriginUrl);
        }
        return super.getOriginText(project);
    }

    @Override
    @Nullable
    protected String getRenamedText() {
        if (this.myRenamedTargetName != null) {
            return VcsBundle.message(this.getBeforeRevision() != null ? "change.file.renamed.to.text" : "change.file.renamed.from.text", this.myRenamedTargetName);
        }
        return super.getRenamedText();
    }

    @Override
    @Nullable
    protected String getMovedText(Project project) {
        if (this.myRenamedTargetName != null) {
            return VcsBundle.message(this.getBeforeRevision() != null ? "change.file.moved.to.text" : "change.file.moved.from.text", this.myRenamedTargetName);
        }
        return super.getMovedText(project);
    }

    public boolean isCopied() {
        return this.myCopied;
    }

    public void setCopied(boolean copied) {
        this.myCopied = copied;
    }

    public String getOriginUrl() {
        return this.myOriginUrl;
    }
}

