/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.history.ShortVcsRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import org.jetbrains.annotations.NotNull;

public class TextRevisionNumber
implements ShortVcsRevisionNumber {
    @NotNull
    private final String myFullRevisionNumber;
    @NotNull
    private final String myShortRevisionNumber;

    public TextRevisionNumber(@NotNull String fullRevisionNumber) {
        if (fullRevisionNumber == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullRevisionNumber", "com/intellij/openapi/vcs/changes/TextRevisionNumber", "<init>"));
        }
        this(fullRevisionNumber, fullRevisionNumber.substring(0, Math.min(7, fullRevisionNumber.length())));
    }

    public TextRevisionNumber(@NotNull String fullRevisionNumber, @NotNull String shortRevisionNumber) {
        if (fullRevisionNumber == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullRevisionNumber", "com/intellij/openapi/vcs/changes/TextRevisionNumber", "<init>"));
        }
        if (shortRevisionNumber == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortRevisionNumber", "com/intellij/openapi/vcs/changes/TextRevisionNumber", "<init>"));
        }
        this.myFullRevisionNumber = fullRevisionNumber;
        this.myShortRevisionNumber = shortRevisionNumber;
    }

    @Override
    public String asString() {
        return this.myFullRevisionNumber;
    }

    @Override
    public int compareTo(@NotNull VcsRevisionNumber o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/openapi/vcs/changes/TextRevisionNumber", "compareTo"));
        }
        return Comparing.compare((Comparable)((Object)this.myFullRevisionNumber), (Comparable)((Object)((TextRevisionNumber)o).myFullRevisionNumber));
    }

    @Override
    public String toShortString() {
        return this.myShortRevisionNumber;
    }
}

