/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.HighlightableComponent;
import com.intellij.ui.HighlightedRegion;
import java.util.ArrayList;

public class HighlightedText {
    private final StringBuffer myBuffer = new StringBuffer();
    private final ArrayList myHighlightedRegions = new ArrayList(3);

    public void appendText(String text, TextAttributes attributes) {
        int startOffset = this.myBuffer.length();
        this.myBuffer.append(text);
        if (attributes != null) {
            this.myHighlightedRegions.add(new HighlightedRegion(startOffset, this.myBuffer.length(), attributes));
        }
    }

    public void insertTextAtStart(String text, TextAttributes attributes) {
        int textLength = text.length();
        for (int i = 0; i < this.myHighlightedRegions.size(); ++i) {
            HighlightedRegion info = (HighlightedRegion)this.myHighlightedRegions.get(i);
            info.startOffset += textLength;
            info.endOffset += textLength;
        }
        this.myBuffer.insert(0, text);
        if (attributes != null) {
            this.myHighlightedRegions.add(new HighlightedRegion(0, textLength, attributes));
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof HighlightedText)) {
            return false;
        }
        HighlightedText highlightedText = (HighlightedText)o;
        if (!this.myBuffer.equals(highlightedText.myBuffer)) {
            return false;
        }
        return this.myHighlightedRegions.equals(highlightedText.myHighlightedRegions);
    }

    public String getText() {
        return this.myBuffer.toString();
    }

    public void applyToComponent(HighlightableComponent renderer) {
        renderer.setText(this.myBuffer.toString());
        for (int i = 0; i < this.myHighlightedRegions.size(); ++i) {
            HighlightedRegion info = (HighlightedRegion)this.myHighlightedRegions.get(i);
            renderer.addHighlighter(info.startOffset, info.endOffset, info.textAttributes);
        }
    }
}

