/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure.treetable;

import com.intellij.ui.table.JBTable;
import com.intellij.ui.treeStructure.treetable.TreeTableCellEditor;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableModelAdapter;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class TreeTable
extends JBTable {
    private TreeTableTree myTree;
    private TreeTableModel myTableModel;
    private PropertyChangeListener myTreeRowHeightPropertyListener;

    public TreeTable(TreeTableModel treeTableModel) {
        this.setModel(treeTableModel);
    }

    public void setModel(TreeTableModel treeTableModel) {
        if (this.myTree != null) {
            this.myTree.removePropertyChangeListener("rowHeight", this.myTreeRowHeightPropertyListener);
        }
        this.myTree = new TreeTableTree(treeTableModel, this);
        this.setRowHeight(this.myTree.getRowHeight());
        this.myTreeRowHeightPropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                int treeRowHeight = TreeTable.this.myTree.getRowHeight();
                if (treeRowHeight == TreeTable.this.getRowHeight()) {
                    return;
                }
                TreeTable.this.setRowHeight(treeRowHeight);
            }
        };
        this.myTree.addPropertyChangeListener("rowHeight", this.myTreeRowHeightPropertyListener);
        this.setTableModel(treeTableModel);
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        this.myTree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        TreeTableCellRenderer treeTableCellRenderer = this.createTableRenderer(treeTableModel);
        this.setDefaultRenderer(TreeTableModel.class, treeTableCellRenderer);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor(treeTableCellRenderer));
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.myTree.getRowHeight() < 1) {
            this.setRowHeight(18);
        } else {
            this.setRowHeight(this.getRowHeight());
        }
    }

    public TreeTableModel getTableModel() {
        return this.myTableModel;
    }

    public void setTableModel(TreeTableModel treeTableModel) {
        this.myTableModel = treeTableModel;
        super.setModel(this.adapt(treeTableModel));
    }

    protected TreeTableModelAdapter adapt(TreeTableModel treeTableModel) {
        return new TreeTableModelAdapter(treeTableModel, this.myTree, this);
    }

    public void setRootVisible(boolean visible) {
        this.myTree.setRootVisible(visible);
    }

    public void putTreeClientProperty(Object key, Object value) {
        this.myTree.putClientProperty(key, value);
    }

    public void setTreeCellRenderer(TreeCellRenderer renderer) {
        this.myTree.setCellRenderer(renderer);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.myTree != null) {
            this.myTree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    @Override
    public int getEditingRow() {
        return this.editingColumn == -1 || this.isTreeColumn(this.editingColumn) ? -1 : this.editingRow;
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.myTree != null && this.myTree.getRowHeight() < rowHeight) {
            this.myTree.setRowHeight(this.getRowHeight());
        }
    }

    public TreeTableTree getTree() {
        return this.myTree;
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        int keyCode = e.getKeyCode();
        int selColumn = this.columnModel.getSelectionModel().getAnchorSelectionIndex();
        boolean treeHasFocus = selColumn == -1 || selColumn >= 0 && this.isTreeColumn(selColumn);
        boolean oneRowSelected = this.getSelectedRowCount() == 1;
        int rowToSelect = -1;
        if (treeHasFocus && oneRowSelected && (keyCode == 37 || keyCode == 39)) {
            TreePath selectionPath = this.myTree.getSelectionPath();
            this.myTree._processKeyEvent(e);
            if (this.myTree.isExpanded(selectionPath)) {
                this.myTree.setSelectionPath(selectionPath);
            } else if (keyCode == 37) {
                rowToSelect = this.myTree.getRowForPath(this.myTree.getSelectionPath());
                if (!this.getScrollableTracksViewportHeight()) {
                    int visibleYPosition = this.getVisibleRect().y;
                    Rectangle cellRect = this.getCellRect(rowToSelect, 0, false);
                    int selectedRowYPosition = cellRect.y;
                    if (selectedRowYPosition < visibleYPosition) {
                        this.scrollRectToVisible(cellRect);
                    }
                }
            }
        } else {
            super.processKeyEvent(e);
        }
        if (rowToSelect > -1) {
            this.getSelectionModel().setSelectionInterval(rowToSelect, rowToSelect);
        }
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        boolean editResult = super.editCellAt(row, column, e);
        if (e instanceof MouseEvent && this.isTreeColumn(column)) {
            MouseEvent me = (MouseEvent)e;
            int y = me.getY();
            if (this.getRowHeight() != this.myTree.getRowHeight()) {
                Rectangle tableCellRect = this.getCellRect(row, column, true);
                y = Math.min(y - tableCellRect.y, this.myTree.getRowHeight() - 1) + row * this.myTree.getRowHeight();
            }
            MouseEvent newEvent = new MouseEvent(this.myTree, me.getID(), me.getWhen(), me.getModifiers(), me.getX() - this.getCellRect((int)0, (int)column, (boolean)true).x, y, me.getClickCount(), me.isPopupTrigger());
            this.myTree.dispatchEvent(newEvent);
            if (newEvent.getID() == 501) {
                MouseEvent newME2 = new MouseEvent(this.myTree, 502, me.getWhen(), me.getModifiers(), me.getX() - this.getCellRect((int)0, (int)column, (boolean)true).x, y - this.getCellRect((int)0, (int)column, (boolean)true).y, me.getClickCount(), me.isPopupTrigger());
                this.myTree.dispatchEvent(newME2);
            }
        }
        return editResult;
    }

    private boolean isTreeColumn(int column) {
        return TreeTableModel.class.isAssignableFrom(this.getColumnClass(column));
    }

    public void addSelectedPath(TreePath path2) {
        int row = this.getTree().getRowForPath(path2);
        this.getTree().addSelectionPath(path2);
        this.getSelectionModel().addSelectionInterval(row, row);
    }

    public void removeSelectedPath(TreePath path2) {
        int row = this.getTree().getRowForPath(path2);
        this.getTree().removeSelectionPath(path2);
        this.getSelectionModel().removeSelectionInterval(row, row);
    }

    public TreeTableCellRenderer createTableRenderer(TreeTableModel treeTableModel) {
        return new TreeTableCellRenderer(this, this.myTree);
    }

    public void setMinRowHeight(int i) {
        this.setRowHeight(Math.max(this.getRowHeight(), i));
    }

    private class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    HashSet<Integer> selectedRows = new HashSet<Integer>();
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    if (min != -1 && max != -1) {
                        for (int counter = min; counter <= max; ++counter) {
                            if (!this.listSelectionModel.isSelectedIndex(counter)) continue;
                            selectedRows.add(new Integer(counter));
                        }
                    }
                    super.resetRowSelection();
                    this.listSelectionModel.clearSelection();
                    for (Object e : selectedRows) {
                        Integer row = (Integer)e;
                        this.listSelectionModel.addSelectionInterval(row, row);
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (min != -1 && max != -1) {
                        ArrayList<TreePath> selectionPaths = new ArrayList<TreePath>();
                        for (int counter = min; counter <= max; ++counter) {
                            TreePath selPath;
                            if (!this.listSelectionModel.isSelectedIndex(counter) || (selPath = TreeTable.this.myTree.getPathForRow(counter)) == null) continue;
                            selectionPaths.add(selPath);
                        }
                        if (!selectionPaths.isEmpty()) {
                            this.addSelectionPaths(selectionPaths.toArray(new TreePath[selectionPaths.size()]));
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }
}

