/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.annotations.NonNull;
import com.android.ide.common.resources.ScanningContext;
import com.google.common.io.Closeables;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class ValidatingResourceParser {
    private final boolean mIsFramework;
    private ScanningContext mContext;

    public ValidatingResourceParser(@NonNull ScanningContext context, boolean isFramework) {
        this.mContext = context;
        this.mIsFramework = isFramework;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parse(String path, InputStream input) throws IOException {
        if (this.mIsFramework) {
            try {
                Closeables.close((Closeable)input, (boolean)true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        if (this.mContext.needsFullAapt()) {
            try {
                Closeables.close((Closeable)input, (boolean)true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        KXmlParser parser = new KXmlParser();
        try {
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            if (input instanceof FileInputStream) {
                input = new BufferedInputStream(input);
            }
            parser.setInput(input, "UTF-8");
            boolean bl = this.parse(path, parser);
            return bl;
        }
        catch (XmlPullParserException e) {
            String message = e.getMessage();
            int index = message.indexOf("(position:");
            if (index != -1) {
                message = message.substring(0, index);
            }
            String error = String.format("%1$s:%2$d: Error: %3$s", path, parser.getLineNumber(), message);
            this.mContext.addError(error);
            boolean bl = false;
            return bl;
        }
        catch (RuntimeException e) {
            String message = e.getMessage();
            String error = String.format("%1$s:%2$d: Error: %3$s", path, parser.getLineNumber(), message);
            this.mContext.addError(error);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                Closeables.close((Closeable)input, (boolean)true);
            }
            catch (IOException iOException) {}
        }
    }

    private boolean parse(String path, KXmlParser parser) throws XmlPullParserException, IOException {
        boolean checkForErrors;
        boolean bl = checkForErrors = !this.mIsFramework && !this.mContext.needsFullAapt();
        block0: while (true) {
            int event;
            if ((event = parser.next()) == 2) {
                int i = 0;
                int n = parser.getAttributeCount();
                while (true) {
                    String uri;
                    if (i >= n) continue block0;
                    String attribute = parser.getAttributeName(i);
                    String value = parser.getAttributeValue(i);
                    assert (value != null) : attribute;
                    if (checkForErrors && !this.mContext.checkValue(uri = parser.getAttributeNamespace(i), attribute, value)) {
                        this.mContext.requestFullAapt();
                        return false;
                    }
                    ++i;
                }
            }
            if (event == 1) break;
        }
        return true;
    }
}

