/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public class License {
    private final String mLicense;
    private final String mLicenseRef;
    private final String mLicenseHash;
    private static final String LICENSE_DIR = "licenses";

    public License(@NonNull String license, @Nullable String licenseRef) {
        this.mLicense = license;
        this.mLicenseRef = licenseRef;
        this.mLicenseHash = Hashing.sha1().hashBytes(this.mLicense.getBytes()).toString();
    }

    @NonNull
    public String getLicense() {
        return this.mLicense;
    }

    @NonNull
    public String getLicenseHash() {
        return this.mLicenseHash;
    }

    @Nullable
    public String getLicenseRef() {
        return this.mLicenseRef;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<License ref:").append(this.mLicenseRef).append(", text:").append(this.mLicense).append(">");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mLicense == null ? 0 : this.mLicense.hashCode());
        result = 31 * result + (this.mLicenseRef == null ? 0 : this.mLicenseRef.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof License)) {
            return false;
        }
        License other = (License)obj;
        if (this.mLicense == null ? other.mLicense != null : !this.mLicense.equals(other.mLicense)) {
            return false;
        }
        return !(this.mLicenseRef == null ? other.mLicenseRef != null : !this.mLicenseRef.equals(other.mLicenseRef));
    }

    public boolean checkAccepted(@Nullable File sdkRoot) {
        if (sdkRoot == null) {
            return false;
        }
        File licenseDir = new File(sdkRoot, LICENSE_DIR);
        File licenseFile = new File(licenseDir, this.mLicenseRef == null ? this.mLicenseHash : this.mLicenseRef);
        if (!licenseFile.exists()) {
            return false;
        }
        try {
            String hash = Files.readFirstLine((File)licenseFile, (Charset)Charsets.UTF_8);
            return hash.equals(this.mLicenseHash);
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean setAccepted(@Nullable File sdkRoot) {
        if (sdkRoot == null) {
            return false;
        }
        if (this.checkAccepted(sdkRoot)) {
            return true;
        }
        File licenseDir = new File(sdkRoot, LICENSE_DIR);
        if (licenseDir.exists() && !licenseDir.isDirectory()) {
            return false;
        }
        if (!licenseDir.exists()) {
            licenseDir.mkdir();
        }
        File licenseFile = new File(licenseDir, this.mLicenseRef == null ? this.mLicenseHash : this.mLicenseRef);
        try {
            Files.write((CharSequence)this.mLicenseHash, (File)licenseFile, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

