/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import org.jetbrains.annotations.NotNull;

public class CharArrayQueue {
    private char[] myArray;
    private int mySize;
    private int myTail;
    private int myHead;

    public CharArrayQueue(int initialCapacity) {
        this.myArray = new char[initialCapacity];
        this.mySize = 0;
        this.myTail = 0;
        this.myHead = 0;
    }

    public void add(char c) {
        this.resizeIfNeeded(this.mySize + 1);
        this.doAdd(c);
    }

    public void addAll(char[] buffer) {
        this.resizeIfNeeded(this.mySize + buffer.length);
        for (char c : buffer) {
            this.doAdd(c);
        }
    }

    public void add(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/util/containers/CharArrayQueue", "add"));
        }
        this.resizeIfNeeded(this.mySize + str.length());
        for (int i = 0; i < str.length(); ++i) {
            this.doAdd(str.charAt(i));
        }
    }

    private void doAdd(char c) {
        this.myArray[this.myTail] = c;
        ++this.myTail;
        if (this.myTail >= this.myArray.length) {
            this.myTail = 0;
        }
        ++this.mySize;
    }

    public int poll() {
        if (this.mySize == 0) {
            return -1;
        }
        char res = this.myArray[this.myHead];
        ++this.myHead;
        if (this.myHead >= this.myArray.length) {
            this.myHead = 0;
        }
        --this.mySize;
        return res;
    }

    public boolean isEmpty() {
        return this.mySize == 0;
    }

    public int size() {
        return this.mySize;
    }

    private void resizeIfNeeded(int newSize) {
        int len = this.myArray.length;
        if (newSize > len) {
            char[] newArray = new char[Math.max(len << 1, newSize)];
            if (this.myHead < this.myTail) {
                System.arraycopy(this.myArray, this.myHead, newArray, 0, this.myTail - this.myHead);
            } else {
                System.arraycopy(this.myArray, this.myHead, newArray, 0, len - this.myHead);
                System.arraycopy(this.myArray, 0, newArray, len - this.myHead, this.myTail);
            }
            this.myArray = newArray;
            this.myHead = 0;
            this.myTail = this.mySize;
        }
    }
}

