/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.reference.SoftReference;
import com.intellij.util.containers.RefHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class SoftHashMap<K, V>
extends RefHashMap<K, V> {
    public SoftHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public SoftHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public SoftHashMap() {
    }

    public SoftHashMap(@NotNull Map<K, V> t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/util/containers/SoftHashMap", "<init>"));
        }
        super(t);
    }

    public SoftHashMap(@NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/SoftHashMap", "<init>"));
        }
        super(hashingStrategy);
    }

    @Override
    @NotNull
    protected <T> RefHashMap.Key<T> createKey(@NotNull T k, @NotNull ReferenceQueue<? super T> q) {
        if (k == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k", "com/intellij/util/containers/SoftHashMap", "createKey"));
        }
        if (q == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "q", "com/intellij/util/containers/SoftHashMap", "createKey"));
        }
        SoftKey softKey = new SoftKey(k, q);
        if (softKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/SoftHashMap", "createKey"));
        }
        return softKey;
    }

    private static class SoftKey<T>
    extends SoftReference<T>
    implements RefHashMap.Key<T> {
        private final int myHash;

        private SoftKey(@NotNull T k, @NotNull ReferenceQueue<? super T> q) {
            if (k == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k", "com/intellij/util/containers/SoftHashMap$SoftKey", "<init>"));
            }
            if (q == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "q", "com/intellij/util/containers/SoftHashMap$SoftKey", "<init>"));
            }
            super(k, q);
            this.myHash = k.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RefHashMap.Key)) {
                return false;
            }
            if (this.myHash != o.hashCode()) {
                return false;
            }
            Object t = this.get();
            Object u = ((RefHashMap.Key)o).get();
            if (t == null || u == null) {
                return false;
            }
            if (t == u) {
                return true;
            }
            return t.equals(u);
        }

        public int hashCode() {
            return this.myHash;
        }

        @NonNls
        public String toString() {
            return "SoftHashMap.SoftKey(" + this.get() + ")";
        }
    }
}

