/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import java.util.List;
import kotlin.PreconditionsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"!\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\u000f\u0015\tA!A\u0003\u0002\u0011A)\u0001!B\u0001\r\u0003\u0015\tAQ\u0001\u0007\u00013\u0005A\n!(A\u0007C\u001bI1\u0001C\u0001\u000e\u0003a\r\u0011kA\u0001\t\u0005%RA!\u0011\u0005\t\u00065!\u0011BA\u0005\u00021\u0007A2!U\u0002\u0002\u000b\u0001IS\u0002B\"\t\u0011\u000fiA\u0001$\u0001\u0019\t%\n\u0001\u0004A)\u0004\t\u0015\u0001QB\u0001C\u0005\u0011\u0015I#\u0002B\"\t\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0011)\u0001!\u0004\u0002\u0005\f!1\u0001"}, strings={"Lorg/intellij/markdown/parser/LookaheadText;", "", "text", "", "(Ljava/lang/String;)V", "lines", "", "startPosition", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "getStartPosition", "()Lorg/intellij/markdown/parser/LookaheadText$Position;", "getText", "()Ljava/lang/String;", "Position"}, moduleName="intellij-markdown")
public final class LookaheadText {
    private final List<? extends String> lines;
    @Nullable
    private final Position startPosition;
    @NotNull
    private final String text;

    @Nullable
    public final Position getStartPosition() {
        return this.startPosition;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public LookaheadText(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.text = text;
        this.lines = StringsKt.split$default((CharSequence)this.text, (char[])new char[]{'\n'}, (boolean)false, (int)0, (int)6);
        this.startPosition = StringsKt.isNotEmpty((CharSequence)this.text) ? Position.nextPosition$default(new Position(0, -1, -1), 0, 1) : (Position)null;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"3\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\t\u0015\tAAA\u0003\u0002\u0011\u0019)\u0011\u0001b\u0001\u0006\u0003!9Q!\u0001C\u0002\u000b\u0005Ai!B\u0001\u0005\u0015\u0015\tA\"A\u0003\u0002\t\u0007!1I\u0001\u0007\u00013\u0005A\n!\t\u000b\u0005\u0001%%\u0001\"A\u0007\u00021\u0007\u00016\u0011AE\u0005\u0011\ti\u0011\u0001g\u0001Q\u0007\u0005II\u0001#\u0002\u000e\u0003a\r\u0001ka\u0001R\u0007\u0005A1!*\u0004\t$5\u0011A\u0012\u0001M\u0002#\u000e\t\u0001rC\u0013\u0007\u0011IiA\u0001$\u0001\u0019\u0001%\n\u0001TE\u0013\f\u0011MiA\u0001$\u0001\u0019\u0001%\n\u0001TE\r\u0005\t\u0005A9#D\u0001\u0019\u0004\u0015\"Aa\u0003\u0005\u0015\u001b\u0005Ab!\u000b\u0006\u0005\u0007\"A9!D\u0001\u0019\tq\u0019\u0013kA\u0002\u000e\u0005\u0011%\u0001\"B\u0015\u000b\t\rC\u00012B\u0007\u00021\u0019a2%U\u0002\u0004\u001b\t!i\u0001C\u0004*\u0015\u0011\u0019\u0005\u0002c\u0004\u000e\u0003aAAdI)\u0004\u00075\u0011A\u0011\u0003\u0005\nS\u001d!\u0011\t\u0003E\u0003\u001b\u0005A\u001a!U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"A!!D\u0001\u0019\u0004E\u001b\u0011!\u0002\u0001*\u0017\u0011\u0019\u0005\u0002c\u0005\u000e\u00051\u0005\u0001D\u0002\u000f$#\u000e\u0019QB\u0001\u0003\u000b\u0011\u001dI3\u0002B\"\t\u0011+i!\u0001$\u0001\u0019\u0004q\u0019\u0013kA\u0002\u000e\u0005\u0011Y\u0001rC\u0015\u000b\t\rC\u0001\u0002D\u0007\u00021\u0007a2%U\u0002\u0004\u001b\t!I\u0002C\u0007*\u0015\u0011\u0019\u0005\u0002c\u0007\u000e\u0003a\rAdI)\u0004\u00075\u0011AA\u0004\u0005\u000eS)!1\t\u0003E\u000f\u001b\u0005A\u001a\u0001H\u0012R\u0007\ri!\u0001B\b\t\u001b%ZAa\u0011\u0005\t 5\u0011A\u0012\u0001\r\u00079\r\n6aA\u0007\u0003\tAAq!\u000b\u0006\u0005\u0007\"A\t#D\u0001\u0019\u0011q\u0019\u0013kA\u0002\u000e\u0005\u0011\t\u0002\"\u0003"}, strings={"Lorg/intellij/markdown/parser/LookaheadText$Position;", "", "lineN", "", "localPos", "globalPos", "(Lorg/intellij/markdown/parser/LookaheadText;III)V", "char", "", "getChar", "()C", "currentLine", "", "getCurrentLine", "()Ljava/lang/String;", "currentLineFromPosition", "", "getCurrentLineFromPosition", "()Ljava/lang/CharSequence;", "nextLine", "getNextLine", "nextLineOffset", "getNextLineOffset", "()Ljava/lang/Integer;", "nextLineOrEofOffset", "getNextLineOrEofOffset", "()I", "offset", "getOffset", "offsetInCurrentLine", "getOffsetInCurrentLine", "prevLine", "getPrevLine", "textFromPosition", "getTextFromPosition", "charsToNonWhitespace", "nextLinePosition", "Lorg/intellij/markdown/parser/LookaheadText;", "nextPosition", "delta", "toString"}, moduleName="intellij-markdown")
    public final class Position {
        private final int lineN;
        private final int localPos;
        private final int globalPos;

        @NotNull
        public String toString() {
            return "Position: '" + (this.localPos == -1 ? "\\n" + this.getCurrentLine() : StringsKt.substring((String)this.getCurrentLine(), (int)this.localPos)) + "'";
        }

        public final int getOffset() {
            return this.globalPos;
        }

        public final int getOffsetInCurrentLine() {
            return this.localPos;
        }

        @Nullable
        public final Integer getNextLineOffset() {
            return this.lineN + 1 < LookaheadText.this.lines.size() ? Integer.valueOf(this.globalPos + (this.getCurrentLine().length() - this.localPos)) : (Integer)null;
        }

        public final int getNextLineOrEofOffset() {
            return this.globalPos + (this.getCurrentLine().length() - this.localPos);
        }

        @NotNull
        public final CharSequence getTextFromPosition() {
            return LookaheadText.this.getText().subSequence(this.globalPos, LookaheadText.this.getText().length());
        }

        @NotNull
        public final String getCurrentLine() {
            return LookaheadText.this.lines.get(this.lineN);
        }

        @NotNull
        public final CharSequence getCurrentLineFromPosition() {
            return this.getCurrentLine().subSequence(this.getOffsetInCurrentLine(), this.getCurrentLine().length());
        }

        @Nullable
        public final String getNextLine() {
            return this.lineN + 1 < LookaheadText.this.lines.size() ? LookaheadText.this.lines.get(this.lineN + 1) : (String)null;
        }

        @Nullable
        public final String getPrevLine() {
            return this.lineN > 0 ? LookaheadText.this.lines.get(this.lineN - 1) : (String)null;
        }

        public final char getChar() {
            return LookaheadText.this.getText().charAt(this.globalPos);
        }

        @Nullable
        public final Position nextPosition(int delta) {
            int remaining = delta;
            Position currentPosition = this;
            while (currentPosition.localPos + remaining >= currentPosition.getCurrentLine().length()) {
                Integer nextLine = currentPosition.getNextLineOffset();
                if (nextLine == null) {
                    return null;
                }
                int payload = currentPosition.getCurrentLine().length() - currentPosition.localPos;
                currentPosition = new Position(currentPosition.lineN + 1, -1, currentPosition.globalPos + payload);
                remaining -= payload;
            }
            return new Position(currentPosition.lineN, currentPosition.localPos + remaining, currentPosition.globalPos + remaining);
        }

        @Nullable
        public static /* bridge */ /* synthetic */ Position nextPosition$default(Position position, int n, int n2) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            return position.nextPosition(n);
        }

        @Nullable
        public final Position nextLinePosition() {
            Integer n = this.getNextLineOffset();
            if (n == null) {
                return null;
            }
            int nextLine = ((Number)n).intValue();
            return this.nextPosition(nextLine - this.getOffset());
        }

        @Nullable
        public final Integer charsToNonWhitespace() {
            String line = this.getCurrentLine();
            for (int offset = this.localPos; offset < line.length(); ++offset) {
                char c;
                if (offset < 0 || (c = line.charAt(offset)) == ' ' || c == '\t') continue;
                return offset - this.localPos;
            }
            return null;
        }

        public Position(int lineN, int localPos, int globalPos) {
            this.lineN = lineN;
            this.localPos = localPos;
            this.globalPos = globalPos;
            PreconditionsKt.assert((this.lineN < LookaheadText.this.lines.size() ? 1 : 0) != 0);
            PreconditionsKt.assert((this.localPos >= -1 && this.localPos < LookaheadText.this.lines.get(this.lineN).length() ? 1 : 0) != 0);
        }
    }
}

