/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.Namer;
import org.gradle.api.Rule;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.internal.AbstractDynamicObject;
import org.gradle.api.internal.BeanDynamicObject;
import org.gradle.api.internal.CompositeDynamicObject;
import org.gradle.api.internal.DefaultDomainObjectCollection;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.ExtensibleDynamicObject;
import org.gradle.api.internal.collections.CollectionEventRegister;
import org.gradle.api.internal.collections.CollectionFilter;
import org.gradle.api.internal.plugins.DefaultConvention;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNamedDomainObjectCollection<T>
extends DefaultDomainObjectCollection<T>
implements NamedDomainObjectCollection<T>,
DynamicObjectAware {
    private final Instantiator instantiator;
    private final Namer<? super T> namer;
    private final Index<T> index;
    private final ContainerElementsDynamicObject elementsDynamicObject = new ContainerElementsDynamicObject();
    private final Convention convention;
    private final DynamicObject dynamicObject;
    private final List<Rule> rules = new ArrayList<Rule>();
    private Set<String> applyingRulesFor = new HashSet<String>();

    public DefaultNamedDomainObjectCollection(Class<? extends T> type, Collection<T> store, Instantiator instantiator, Namer<? super T> namer) {
        super(type, store);
        this.instantiator = instantiator;
        this.convention = new DefaultConvention(instantiator);
        this.dynamicObject = new ExtensibleDynamicObject((Object)this, (AbstractDynamicObject)new ContainerDynamicObject(this.elementsDynamicObject), this.convention);
        this.namer = namer;
        this.index = new UnfilteredIndex();
        this.index();
    }

    protected void index() {
        for (Object t : this.getStore()) {
            this.index.put(this.namer.determineName(t), t);
        }
    }

    protected DefaultNamedDomainObjectCollection(Class<? extends T> type, Collection<T> store, CollectionEventRegister<T> eventRegister, Index<T> index, Instantiator instantiator, Namer<? super T> namer) {
        super(type, store, eventRegister);
        this.instantiator = instantiator;
        this.convention = new DefaultConvention(instantiator);
        this.dynamicObject = new ExtensibleDynamicObject((Object)this, (AbstractDynamicObject)new ContainerDynamicObject(this.elementsDynamicObject), this.convention);
        this.namer = namer;
        this.index = index;
    }

    public DefaultNamedDomainObjectCollection(DefaultNamedDomainObjectCollection<? super T> collection, CollectionFilter<T> filter, Instantiator instantiator, Namer<? super T> namer) {
        this(filter.getType(), collection.filteredStore(filter), collection.filteredEvents(filter), collection.filteredIndex(filter), instantiator, namer);
    }

    @Override
    public boolean add(T o) {
        if (!this.hasWithName(this.namer.determineName(o))) {
            return super.add(o);
        }
        this.handleAttemptToAddItemWithNonUniqueName(o);
        return false;
    }

    @Override
    protected void didAdd(T toAdd) {
        this.index.put(this.namer.determineName(toAdd), toAdd);
    }

    @Override
    public void clear() {
        super.clear();
        this.index.clear();
    }

    @Override
    protected void didRemove(T t) {
        this.index.remove(this.namer.determineName(t));
    }

    protected void handleAttemptToAddItemWithNonUniqueName(T o) {
    }

    protected void assertCanAdd(String name) {
        if (this.hasWithName(name)) {
            throw new InvalidUserDataException(String.format("Cannot add a %s with name '%s' as a %s with that name already exists.", this.getTypeDisplayName(), name, this.getTypeDisplayName()));
        }
    }

    protected void assertCanAdd(T t) {
        this.assertCanAdd(this.getNamer().determineName(t));
    }

    @Override
    public Namer<T> getNamer() {
        return this.namer;
    }

    protected Instantiator getInstantiator() {
        return this.instantiator;
    }

    protected <S extends T> Index<S> filteredIndex(CollectionFilter<S> filter) {
        return this.index.filter(filter);
    }

    @Override
    protected <S extends T> DefaultNamedDomainObjectCollection<S> filtered(CollectionFilter<S> filter) {
        return (DefaultNamedDomainObjectCollection)this.instantiator.newInstance(DefaultNamedDomainObjectCollection.class, new Object[]{this, filter, this.instantiator, this.namer});
    }

    public String getDisplayName() {
        return String.format("%s container", this.getTypeDisplayName());
    }

    @Override
    public SortedMap<String, T> getAsMap() {
        return this.index.asMap();
    }

    @Override
    public SortedSet<String> getNames() {
        return this.index.asMap().navigableKeySet();
    }

    @Override
    public <S extends T> NamedDomainObjectCollection<S> withType(Class<S> type) {
        return this.filtered((CollectionFilter)this.createFilter(type));
    }

    @Override
    public NamedDomainObjectCollection<T> matching(Spec<? super T> spec) {
        return this.filtered(this.createFilter(spec));
    }

    @Override
    public NamedDomainObjectCollection<T> matching(Closure spec) {
        return this.matching(Specs.convertClosureToSpec((Closure)spec));
    }

    @Override
    public T findByName(String name) {
        T value = this.findByNameWithoutRules(name);
        if (value != null) {
            return value;
        }
        this.applyRules(name);
        return this.findByNameWithoutRules(name);
    }

    protected boolean hasWithName(String name) {
        return this.findByNameWithoutRules(name) != null;
    }

    protected T findByNameWithoutRules(String name) {
        return this.index.get(name);
    }

    protected T removeByName(String name) {
        T it = this.getByName(name);
        if (it != null) {
            if (this.remove(it)) {
                return it;
            }
            throw new IllegalStateException(String.format("found '%s' with name '%s' but remove() returned false", it, name));
        }
        return null;
    }

    @Override
    public T getByName(String name) throws UnknownDomainObjectException {
        T t = this.findByName(name);
        if (t == null) {
            throw this.createNotFoundException(name);
        }
        return t;
    }

    @Override
    public T getByName(String name, Closure configureClosure) throws UnknownDomainObjectException {
        T t = this.getByName(name);
        ConfigureUtil.configure(configureClosure, t);
        return t;
    }

    @Override
    public T getAt(String name) throws UnknownDomainObjectException {
        return this.getByName(name);
    }

    @Override
    public DynamicObject getAsDynamicObject() {
        return this.dynamicObject;
    }

    public Convention getConvention() {
        return this.convention;
    }

    public ExtensionContainer getExtensions() {
        return this.convention;
    }

    protected DynamicObject getElementsAsDynamicObject() {
        return this.elementsDynamicObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyRules(String name) {
        if (this.applyingRulesFor.contains(name)) {
            return;
        }
        this.applyingRulesFor.add(name);
        try {
            for (Rule rule : this.rules) {
                rule.apply(name);
            }
        }
        finally {
            this.applyingRulesFor.remove(name);
        }
    }

    @Override
    public Rule addRule(Rule rule) {
        this.rules.add(rule);
        return rule;
    }

    @Override
    public Rule addRule(final String description, final Closure ruleAction) {
        Rule rule = new Rule(){

            public String getDescription() {
                return description;
            }

            public void apply(String taskName) {
                ruleAction.call((Object)taskName);
            }

            public String toString() {
                return "Rule: " + description;
            }
        };
        this.rules.add(rule);
        return rule;
    }

    @Override
    public List<Rule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    protected UnknownDomainObjectException createNotFoundException(String name) {
        return new UnknownDomainObjectException(String.format("%s with name '%s' not found.", this.getTypeDisplayName(), name));
    }

    protected String getTypeDisplayName() {
        return this.getType().getSimpleName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilteredIndex<T>
    implements Index<T> {
        private final Index<? super T> delegate;
        private final CollectionFilter<T> filter;

        public FilteredIndex(Index<? super T> delegate, CollectionFilter<T> filter) {
            this.delegate = delegate;
            this.filter = filter;
        }

        @Override
        public void put(String name, T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T get(String name) {
            return this.filter.filter(this.delegate.get(name));
        }

        @Override
        public void remove(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NavigableMap<String, T> asMap() {
            NavigableMap<String, T> delegateMap = this.delegate.asMap();
            TreeMap filtered = new TreeMap();
            for (Map.Entry entry : delegateMap.entrySet()) {
                T obj = this.filter.filter(entry.getValue());
                if (obj == null) continue;
                filtered.put(entry.getKey(), obj);
            }
            return filtered;
        }

        @Override
        public <S extends T> Index<S> filter(CollectionFilter<S> filter) {
            return new FilteredIndex<T>(this.delegate, this.filter.and(filter));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class UnfilteredIndex<T>
    implements Index<T> {
        private final NavigableMap<String, T> map = new TreeMap<String, T>();

        protected UnfilteredIndex() {
        }

        @Override
        public NavigableMap<String, T> asMap() {
            return this.map;
        }

        @Override
        public void put(String name, T value) {
            this.map.put(name, value);
        }

        @Override
        public T get(String name) {
            return (T)this.map.get(name);
        }

        @Override
        public void remove(String name) {
            this.map.remove(name);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public <S extends T> Index<S> filter(CollectionFilter<S> filter) {
            return new FilteredIndex<S>(this, filter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface Index<T> {
        public void put(String var1, T var2);

        public T get(String var1);

        public void remove(String var1);

        public void clear();

        public NavigableMap<String, T> asMap();

        public <S extends T> Index<S> filter(CollectionFilter<S> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ContainerElementsDynamicObject
    extends AbstractDynamicObject {
        private ContainerElementsDynamicObject() {
        }

        @Override
        protected String getDisplayName() {
            return DefaultNamedDomainObjectCollection.this.getDisplayName();
        }

        @Override
        public boolean hasProperty(String name) {
            return DefaultNamedDomainObjectCollection.this.findByName(name) != null;
        }

        public T getProperty(String name) throws MissingPropertyException {
            Object t = DefaultNamedDomainObjectCollection.this.findByName(name);
            if (t == null) {
                return super.getProperty(name);
            }
            return t;
        }

        public Map<String, T> getProperties() {
            return DefaultNamedDomainObjectCollection.this.getAsMap();
        }

        @Override
        public boolean hasMethod(String name, Object ... arguments) {
            return this.isConfigureMethod(name, arguments);
        }

        @Override
        public Object invokeMethod(String name, Object ... arguments) throws MissingMethodException {
            if (this.isConfigureMethod(name, arguments)) {
                return ConfigureUtil.configure((Closure)arguments[0], DefaultNamedDomainObjectCollection.this.getByName(name));
            }
            return super.invokeMethod(name, arguments);
        }

        private boolean isConfigureMethod(String name, Object ... arguments) {
            return arguments.length == 1 && arguments[0] instanceof Closure && this.hasProperty(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ContainerDynamicObject
    extends CompositeDynamicObject {
        private ContainerDynamicObject(ContainerElementsDynamicObject elementsDynamicObject) {
            this.setObjects(new BeanDynamicObject(DefaultNamedDomainObjectCollection.this), elementsDynamicObject, DefaultNamedDomainObjectCollection.this.convention.getExtensionsAsDynamicObject());
        }

        @Override
        protected String getDisplayName() {
            return DefaultNamedDomainObjectCollection.this.getDisplayName();
        }
    }
}

