/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.gradle.api.internal.file.AbstractFileResource;
import org.gradle.api.internal.resources.ResourceIsAFolderException;
import org.gradle.api.resources.MissingResourceException;

public class FileResource
extends AbstractFileResource {
    public FileResource(File file) {
        super(file);
    }

    public InputStream read() {
        if (this.file.isDirectory()) {
            throw new ResourceIsAFolderException(String.format("Cannot read resource %s because it is a folder.", this.file.getName()));
        }
        try {
            FileInputStream fis = new FileInputStream(this.file);
            return new BufferedInputStream(fis);
        }
        catch (FileNotFoundException e) {
            throw new MissingResourceException(String.format("Cannot read the file resource because the file %s does not exist", this.file.getName()));
        }
    }
}

